/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.domain_service;

import io.gravitee.apim.core.portal_page.exception.PortalPageSpecificationException;
import io.gravitee.apim.core.portal_page.model.PageId;
import io.gravitee.apim.core.portal_page.model.PortalViewContext;
import java.util.function.Predicate;

public class PageExistsSpecification<T> {
    private final Predicate<T> existenceChecker;

    public PageExistsSpecification(Predicate<T> existenceChecker) {
        this.existenceChecker = existenceChecker;
    }

    public boolean satisfies(T locator) {
        return this.existenceChecker.test(locator);
    }

    public String getErrorMessage() {
        return "Page does not exist";
    }

    public void throwIfNotSatisfied(T locator) {
        if (!this.satisfies(locator)) {
            throw new PortalPageSpecificationException(this.getErrorMessage());
        }
    }

    public static PageExistsSpecification<PortalViewContext> byPortalViewContext(Predicate<PortalViewContext> existenceChecker) {
        return new PageExistsSpecification<PortalViewContext>(existenceChecker);
    }

    public static PageExistsSpecification<PageId> byPageId(Predicate<PageId> existenceChecker) {
        return new PageExistsSpecification<PageId>(existenceChecker);
    }
}

