/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.query_service;

import io.gravitee.apim.core.analytics.model.Aggregation;
import io.gravitee.apim.core.analytics.model.AnalyticsQueryParameters;
import io.gravitee.apim.core.analytics.model.EventAnalytics;
import io.gravitee.apim.core.analytics.model.GroupByAnalytics;
import io.gravitee.apim.core.analytics.model.HistogramAnalytics;
import io.gravitee.apim.core.analytics.model.ResponseStatusOvertime;
import io.gravitee.apim.core.analytics.model.StatsAnalytics;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.model.analytics.TopHitsApps;
import io.gravitee.rest.api.model.v4.analytics.ApiMetricsDetail;
import io.gravitee.rest.api.model.v4.analytics.AverageConnectionDuration;
import io.gravitee.rest.api.model.v4.analytics.AverageMessagesPerRequest;
import io.gravitee.rest.api.model.v4.analytics.RequestResponseTime;
import io.gravitee.rest.api.model.v4.analytics.RequestsCount;
import io.gravitee.rest.api.model.v4.analytics.ResponseStatusRanges;
import io.gravitee.rest.api.model.v4.analytics.TopFailedApis;
import io.gravitee.rest.api.model.v4.analytics.TopHitsApis;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.reactivex.rxjava3.core.Maybe;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public interface AnalyticsQueryService {
    public Optional<RequestsCount> searchRequestsCount(ExecutionContext var1, String var2, Instant var3, Instant var4);

    public Optional<AverageMessagesPerRequest> searchAverageMessagesPerRequest(ExecutionContext var1, String var2, Instant var3, Instant var4);

    public Optional<AverageConnectionDuration> searchAverageConnectionDuration(ExecutionContext var1, String var2, Instant var3, Instant var4);

    public Optional<ResponseStatusRanges> searchResponseStatusRanges(ExecutionContext var1, AnalyticsQueryParameters var2);

    public Optional<TopHitsApis> searchTopHitsApis(ExecutionContext var1, AnalyticsQueryParameters var2);

    public Maybe<Map<String, Double>> searchAvgResponseTimeOverTime(ExecutionContext var1, List<String> var2, Instant var3, Instant var4, Duration var5, Collection<DefinitionVersion> var6);

    public ResponseStatusOvertime searchResponseStatusOvertime(ExecutionContext var1, ResponseStatusOverTimeQuery var2);

    public Optional<TopHitsApps> searchTopHitsApps(ExecutionContext var1, AnalyticsQueryParameters var2);

    public RequestResponseTime searchRequestResponseTime(ExecutionContext var1, AnalyticsQueryParameters var2);

    public Optional<TopFailedApis> searchTopFailedApis(ExecutionContext var1, AnalyticsQueryParameters var2);

    public Optional<HistogramAnalytics> searchHistogramAnalytics(ExecutionContext var1, HistogramQuery var2);

    public Optional<GroupByAnalytics> searchGroupByAnalytics(ExecutionContext var1, GroupByQuery var2);

    public Optional<StatsAnalytics> searchStatsAnalytics(ExecutionContext var1, StatsQuery var2);

    public Optional<RequestsCount> searchRequestsCountByEvent(ExecutionContext var1, CountQuery var2);

    public Optional<ApiMetricsDetail> findApiMetricsDetail(ExecutionContext var1, String var2, String var3);

    public Optional<EventAnalytics> searchEventAnalytics(ExecutionContext var1, HistogramQuery var2);

    public record ResponseStatusOverTimeQuery(List<String> apiIds, Instant from, Instant to, Duration interval, Collection<DefinitionVersion> versions) {
        public ResponseStatusOverTimeQuery(List<String> apiIds, Instant from, Instant to, Duration interval, Collection<DefinitionVersion> versions) {
            this.apiIds = apiIds;
            this.from = from;
            this.to = to;
            this.interval = interval;
            this.versions = versions == null || versions.isEmpty() ? List.of(DefinitionVersion.V4) : versions;
        }
    }

    public record StatsQuery(SearchTermId searchTermId, String field, Instant from, Instant to, Optional<String> query) {
    }

    public record GroupByQuery(SearchTermId searchTermId, Instant from, Instant to, String field, List<Group> groups, Optional<Order> order, Optional<String> query) {

        public record Order(String field, boolean order, String type) {
            public static Order valueOf(String param) {
                String field = null;
                boolean order = true;
                String type = null;
                if (param != null) {
                    String[] parts = param.split(":");
                    boolean bl = order = !parts[0].startsWith("-");
                    if (parts.length == 2) {
                        type = order ? parts[0] : parts[0].substring(1);
                        field = parts[1];
                    } else {
                        field = order ? parts[0] : parts[0].substring(1);
                    }
                }
                return new Order(field, order, type);
            }
        }

        public record Group(long from, long to) {
        }
    }

    public record HistogramQuery(SearchTermId searchTermId, Instant from, Instant to, Duration interval, List<Aggregation> aggregations, Optional<String> query) {
    }

    public record CountQuery(SearchTermId searchTermId, Instant from, Instant to, Optional<String> query) {
    }

    public record SearchTermId(SearchTerm searchTerm, String id) {
        public static SearchTermId forApi(String apiId) {
            return new SearchTermId(SearchTerm.API, apiId);
        }
    }

    public static enum SearchTerm {
        API("api-id");

        private final String field;

        private SearchTerm(String field) {
            this.field = field;
        }

        @Generated
        public String getField() {
            return this.field;
        }
    }
}

