/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.event.Event;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.rest.api.model.InvalidateRoleCacheCommandEntity;
import io.gravitee.rest.api.model.command.CommandEntity;
import io.gravitee.rest.api.model.command.CommandTags;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.event.CommandEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InvalidateRoleCacheCommandListener
implements EventListener<CommandEvent, CommandEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InvalidateRoleCacheCommandListener.class);
    private final ObjectMapper objectMapper;
    private final MembershipService membershipService;

    public InvalidateRoleCacheCommandListener(ObjectMapper objectMapper, MembershipService membershipService, EventManager eventManager) {
        this.objectMapper = objectMapper;
        this.membershipService = membershipService;
        eventManager.subscribeForEvents((EventListener)this, CommandEvent.class);
    }

    public void onEvent(Event<CommandEvent, CommandEntity> event) {
        if (event != null && CommandEvent.TO_PROCESS.equals(event.type()) && event.content() != null && ((CommandEntity)event.content()).getTags().contains(CommandTags.GROUP_DEFAULT_ROLES_UPDATE)) {
            InvalidateRoleCacheCommandEntity eventData;
            String content = ((CommandEntity)event.content()).getContent();
            log.debug("Command event: {}", (Object)content);
            try {
                eventData = (InvalidateRoleCacheCommandEntity)this.objectMapper.readValue(content, InvalidateRoleCacheCommandEntity.class);
            }
            catch (JsonProcessingException e) {
                log.error("Failed to deserialize map of properties {}", (Object)content, (Object)e);
                return;
            }
            if (eventData != null) {
                this.membershipService.invalidateRoleCache(eventData.getReferenceType(), eventData.getReferenceId(), eventData.getMemberType(), eventData.getMemberId());
            }
        }
    }
}

