/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.notification.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.group.domain_service.ValidateGroupsDomainService;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.rest.api.model.notification.NotificationConfigType;
import io.gravitee.rest.api.model.notification.PortalNotificationConfigEntity;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

@DomainService
public class ValidatePortalNotificationDomainService
implements Validator<Input> {
    private final ValidateGroupsDomainService groupsValidator;

    @Override
    public Validator.Result<Input> validateAndSanitize(Input input) {
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        PortalNotificationConfigEntity consoleNotification = input.portalNotificationConfig();
        if (consoleNotification != null) {
            if (consoleNotification.getConfigType() != NotificationConfigType.PORTAL) {
                errors.add(Validator.Error.severe("The reference type of console notification should be '%s'", NotificationConfigType.PORTAL.name()));
            }
            this.groupsValidator.validateAndSanitize(new ValidateGroupsDomainService.Input(input.auditInfo.environmentId(), CollectionUtils.stream(consoleNotification.getGroups()).collect(Collectors.toSet()), input.definitionVersion(), null, false)).peek(sanitized -> consoleNotification.setGroups(CollectionUtils.stream(sanitized.groups()).toList()), errors::addAll);
            Set allowedGroups = CollectionUtils.stream(input.allowedGroups()).collect(Collectors.toSet());
            Set consoleNotificationGroup = CollectionUtils.stream(consoleNotification.getGroups()).collect(Collectors.toSet());
            if (!allowedGroups.containsAll(consoleNotificationGroup)) {
                errors.add(Validator.Error.severe("Console notification configuration contains the following groups %s where only those are allowed %s", input.portalNotificationConfig.getGroups(), input.allowedGroups));
            }
            return Validator.Result.ofBoth(input, errors);
        }
        return Validator.Result.ofBoth(input, errors);
    }

    @Generated
    public ValidatePortalNotificationDomainService(ValidateGroupsDomainService groupsValidator) {
        this.groupsValidator = groupsValidator;
    }

    public record Input(PortalNotificationConfigEntity portalNotificationConfig, String definitionVersion, Set<String> allowedGroups, AuditInfo auditInfo) implements Validator.Input
    {
    }
}

