/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.targettoken.TargetTokenCommand;
import io.gravitee.cockpit.api.command.v1.targettoken.TargetTokenCommandPayload;
import io.gravitee.cockpit.api.command.v1.targettoken.TargetTokenReply;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.exchange.api.command.CommandStatus;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.NewExternalUserEntity;
import io.gravitee.rest.api.model.NewRoleEntity;
import io.gravitee.rest.api.model.NewTokenEntity;
import io.gravitee.rest.api.model.TokenEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.TokenService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.DefaultRoleEntityDefinition;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.reactivex.rxjava3.core.Single;
import java.util.Collections;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TargetTokenCommandHandler
implements CommandHandler<TargetTokenCommand, TargetTokenReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TargetTokenCommandHandler.class);
    public static final String CLOUD_TOKEN_SOURCE = "cloud-token";
    public static final String TARGET_TOKEN_USER_NAME = "Cloud Token User";
    public static final String TARGET_TOKEN_NAME = "Cloud Target Token";
    private final UserService userService;
    private final MembershipService membershipService;
    private final RoleService roleService;
    private final TokenService tokenService;

    public String supportType() {
        return CockpitCommandType.TARGET_TOKEN.name();
    }

    public Single<TargetTokenReply> handle(TargetTokenCommand command) {
        TargetTokenCommandPayload payload = (TargetTokenCommandPayload)command.getPayload();
        ExecutionContext context = new ExecutionContext(payload.organizationId(), payload.environmentId());
        UserEntity user = null;
        TokenEntity tokenEntity = null;
        try {
            user = this.createUser(context, command);
            if (user == null) {
                return Single.just((Object)new TargetTokenReply(command.getId(), "Failed to create user."));
            }
            if (!this.assignOrganizationRole(context, payload, user)) {
                this.rollbackUserCreation(context, user);
                return Single.just((Object)new TargetTokenReply(command.getId(), "Failed to assign organization role."));
            }
            if (!this.assignEnvironmentRole(context, payload, user)) {
                this.rollbackMemberships(context, user);
                this.rollbackUserCreation(context, user);
                return Single.just((Object)new TargetTokenReply(command.getId(), "Failed to assign environment role."));
            }
            tokenEntity = this.createToken(context, user);
            return Single.just((Object)new TargetTokenReply(command.getId(), CommandStatus.SUCCEEDED, tokenEntity.getToken()));
        }
        catch (Exception e) {
            log.error("Rolling back due to failure in handling target token command.", (Throwable)e);
            this.rollbackTokenCreation(context, tokenEntity);
            this.rollbackMemberships(context, user);
            this.rollbackUserCreation(context, user);
            String errorDetails = String.format("Error occurred creating cloud target token for organization [%s] and environment [%s].", payload.organizationId(), payload.environmentId());
            return Single.just((Object)new TargetTokenReply(command.getId(), errorDetails));
        }
    }

    private UserEntity createUser(ExecutionContext context, TargetTokenCommand command) {
        NewExternalUserEntity newUser = new NewExternalUserEntity();
        newUser.setSourceId(((TargetTokenCommandPayload)command.getPayload()).id());
        newUser.setSource(CLOUD_TOKEN_SOURCE);
        newUser.setLastname(TARGET_TOKEN_USER_NAME);
        try {
            UserEntity userEntity = this.userService.create(context, newUser, false);
            log.info("Cloud target token user created with id [{}].", (Object)userEntity.getId());
            return userEntity;
        }
        catch (Exception e) {
            log.error("Error occurred when creating cloud target token user.", (Throwable)e);
            return null;
        }
    }

    private boolean assignOrganizationRole(ExecutionContext context, TargetTokenCommandPayload payload, UserEntity user) {
        String roleName;
        String string = roleName = payload.scope() == TargetTokenCommandPayload.Scope.GKO ? SystemRole.ADMIN.name() : DefaultRoleEntityDefinition.DEFAULT_ROLE_ORGANIZATION_USER.getName();
        if (this.roleService.findByScopeAndName(RoleScope.ORGANIZATION, roleName, payload.organizationId()).isEmpty()) {
            log.error("Couldn't find {} role for organization with id [{}]", (Object)roleName, (Object)payload.organizationId());
            return false;
        }
        MembershipService.MembershipMember member = new MembershipService.MembershipMember(user.getId(), null, MembershipMemberType.USER);
        MembershipService.MembershipReference reference = new MembershipService.MembershipReference(MembershipReferenceType.ORGANIZATION, payload.organizationId());
        MembershipService.MembershipRole role = new MembershipService.MembershipRole(RoleScope.ORGANIZATION, roleName);
        this.membershipService.updateRolesToMemberOnReference(context, reference, member, Collections.singletonList(role), "cockpit", false);
        return true;
    }

    private boolean assignEnvironmentRole(ExecutionContext context, TargetTokenCommandPayload payload, UserEntity user) {
        NewRoleEntity newRole;
        NewRoleEntity newRoleEntity = newRole = payload.scope() == TargetTokenCommandPayload.Scope.FEDERATION ? DefaultRoleEntityDefinition.ROLE_ENVIRONMENT_FEDERATION_AGENT : DefaultRoleEntityDefinition.ROLE_ENVIRONMENT_API_PUBLISHER;
        if (this.roleService.findByScopeAndName(RoleScope.ENVIRONMENT, newRole.getName(), payload.organizationId()).isEmpty()) {
            log.error("Couldn't find role {} with scope {} for organization with id [{}]", new Object[]{newRole.getName(), RoleScope.ENVIRONMENT, payload.organizationId()});
            return false;
        }
        MembershipService.MembershipMember member = new MembershipService.MembershipMember(user.getId(), null, MembershipMemberType.USER);
        MembershipService.MembershipReference reference = new MembershipService.MembershipReference(MembershipReferenceType.ENVIRONMENT, payload.environmentId());
        MembershipService.MembershipRole role = new MembershipService.MembershipRole(RoleScope.ENVIRONMENT, newRole.getName());
        this.membershipService.updateRolesToMemberOnReference(context, reference, member, Collections.singletonList(role), "cockpit", false);
        return true;
    }

    private TokenEntity createToken(ExecutionContext context, UserEntity user) {
        NewTokenEntity token = new NewTokenEntity();
        token.setName(TARGET_TOKEN_NAME);
        return this.tokenService.create(context, token, user.getId());
    }

    private void rollbackUserCreation(ExecutionContext context, UserEntity user) {
        if (user != null) {
            this.userService.delete(context, user.getId());
            log.info("Rolled back user creation with id [{}].", (Object)user.getId());
        }
    }

    private void rollbackMemberships(ExecutionContext context, UserEntity user) {
        if (user != null) {
            this.membershipService.removeMemberMemberships(context, MembershipMemberType.USER, user.getId());
            log.info("Rolled back memberships for user [{}].", (Object)user.getId());
        }
    }

    private void rollbackTokenCreation(ExecutionContext context, TokenEntity tokenEntity) {
        if (tokenEntity != null) {
            this.tokenService.revoke(context, tokenEntity.getId());
            log.info("Revoked token with id [{}].", (Object)tokenEntity.getId());
        }
    }

    @Generated
    public TargetTokenCommandHandler(UserService userService, MembershipService membershipService, RoleService roleService, TokenService tokenService) {
        this.userService = userService;
        this.membershipService = membershipService;
        this.roleService = roleService;
        this.tokenService = tokenService;
    }
}

