/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.theme.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.theme.crud_service.ThemeCrudService;
import io.gravitee.apim.core.theme.model.NewTheme;
import io.gravitee.apim.core.theme.model.Theme;
import io.gravitee.apim.core.theme.model.UpdateTheme;
import io.gravitee.rest.api.service.common.UuidString;
import java.time.ZonedDateTime;
import lombok.Generated;

@DomainService
public class ThemeDomainService {
    private final ThemeCrudService themeCrudService;

    public Theme create(NewTheme newTheme) {
        ZonedDateTime currentTime = ZonedDateTime.now();
        Theme themeToBeCreated = Theme.builder().name(newTheme.getName()).referenceId(newTheme.getReferenceId()).referenceType(newTheme.getReferenceType()).definitionPortal(newTheme.getDefinitionPortal()).definitionPortalNext(newTheme.getDefinitionPortalNext()).type(newTheme.getType()).enabled(newTheme.isEnabled()).logo(newTheme.getLogo()).optionalLogo(newTheme.getOptionalLogo()).favicon(newTheme.getFavicon()).backgroundImage(newTheme.getBackgroundImage()).id(UuidString.generateRandom()).createdAt(currentTime).updatedAt(currentTime).build();
        return this.themeCrudService.create(themeToBeCreated);
    }

    public Theme update(UpdateTheme updateTheme, Theme existingTheme) {
        Theme existingThemeWithUpdates = existingTheme.toBuilder().name(updateTheme.getName()).definitionPortal(updateTheme.getDefinitionPortal()).definitionPortalNext(updateTheme.getDefinitionPortalNext()).enabled(updateTheme.isEnabled()).logo(updateTheme.getLogo()).optionalLogo(updateTheme.getOptionalLogo()).favicon(updateTheme.getFavicon()).backgroundImage(updateTheme.getBackgroundImage()).updatedAt(ZonedDateTime.now()).build();
        return this.themeCrudService.update(existingThemeWithUpdates);
    }

    @Generated
    public ThemeDomainService(ThemeCrudService themeCrudService) {
        this.themeCrudService = themeCrudService;
    }
}

