/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiCategoryOrderRepository;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApiCategoryOrder;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Visibility;
import io.gravitee.rest.api.model.CategoryEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.CategoryService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.v4.ApiCategoryService;
import io.gravitee.rest.api.service.v4.ApiNotificationService;
import io.gravitee.rest.api.service.v4.exception.ApiNotInCategoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiCategoryServiceImpl
implements ApiCategoryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiCategoryServiceImpl.class);
    private final ApiRepository apiRepository;
    private final ApiCategoryOrderRepository apiCategoryOrderRepository;
    private final CategoryService categoryService;
    private final ApiNotificationService apiNotificationService;
    private final AuditService auditService;
    private final MembershipService membershipService;
    private final RoleService roleService;

    public ApiCategoryServiceImpl(@Lazy ApiRepository apiRepository, @Lazy ApiCategoryOrderRepository apiCategoryOrderRepository, CategoryService categoryService, ApiNotificationService apiNotificationService, AuditService auditService, @Lazy MembershipService membershipService, @Lazy RoleService roleService) {
        this.apiRepository = apiRepository;
        this.apiCategoryOrderRepository = apiCategoryOrderRepository;
        this.categoryService = categoryService;
        this.apiNotificationService = apiNotificationService;
        this.auditService = auditService;
        this.membershipService = membershipService;
        this.roleService = roleService;
    }

    @Override
    public Set<CategoryEntity> listCategories(Collection<String> apis, String environment) {
        try {
            ApiCriteria criteria = new ApiCriteria.Builder().ids(apis.toArray(new String[apis.size()])).build();
            Set categoryIds = this.apiRepository.listCategories(criteria);
            return this.categoryService.findByIdIn(environment, categoryIds);
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to list categories for APIs {}", apis, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to list categories for APIs {}" + String.valueOf(apis), ex);
        }
    }

    @Override
    public void deleteCategoryFromAPIs(ExecutionContext executionContext, String categoryId) {
        this.apiRepository.search(new ApiCriteria.Builder().category(categoryId).build(), null, ApiFieldFilter.allFields()).forEach(api -> this.removeCategoryFromApi(executionContext, (Api)api, categoryId));
    }

    private void removeCategoryFromApi(ExecutionContext executionContext, Api api, String categoryId) {
        try {
            Api apiSnapshot = new Api(api);
            api.getCategories().remove(categoryId);
            api.setUpdatedAt(new Date());
            this.apiRepository.update((Object)api);
            this.apiNotificationService.triggerUpdateNotification(executionContext, api);
            this.auditService.createApiAuditLog(executionContext, api.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, api.getUpdatedAt(), apiSnapshot, api);
            this.apiCategoryOrderRepository.delete(api.getId(), categoryId);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error has occurred while removing category " + categoryId + " from API " + api.getId(), e);
        }
    }

    @Override
    public ToLongFunction<String> countApisPublishedGroupedByCategoriesForUser(String userId) {
        Page foundApiIds;
        ArrayList<ApiCriteria> criteriaList = new ArrayList<ApiCriteria>();
        criteriaList.add(new ApiCriteria.Builder().visibility(Visibility.PUBLIC).lifecycleStates(List.of(ApiLifecycleState.PUBLISHED)).build());
        if (userId != null) {
            List<String> userGroupIdsWithApiRole;
            List<String> userMembershipApiIds = this.getUserMembershipApiIds(userId);
            if (!userMembershipApiIds.isEmpty()) {
                criteriaList.add(new ApiCriteria.Builder().lifecycleStates(List.of(ApiLifecycleState.PUBLISHED)).ids(userMembershipApiIds).build());
            }
            if (!(userGroupIdsWithApiRole = this.getUserGroupIdsWithApiRole(userId)).isEmpty()) {
                criteriaList.add(new ApiCriteria.Builder().lifecycleStates(List.of(ApiLifecycleState.PUBLISHED)).groups(userGroupIdsWithApiRole).build());
            }
        }
        if ((foundApiIds = this.apiRepository.searchIds(criteriaList, new PageableBuilder().pageSize(Integer.MAX_VALUE).build(), null)).getContent() == null || foundApiIds.getContent().isEmpty()) {
            return categoryId -> 0L;
        }
        HashMap apiByCatgeory = this.apiRepository.search(new ApiCriteria.Builder().ids((Collection)foundApiIds.getContent()).build(), null, ApiFieldFilter.defaultFields()).filter(api -> api.getCategories() != null && !api.getCategories().isEmpty()).flatMap(api -> api.getCategories().stream().map(cat -> Pair.of((Object)cat, (Object)api))).collect(Collectors.groupingBy(Pair::getKey, HashMap::new, Collectors.counting()));
        return categoryId -> apiByCatgeory.getOrDefault(categoryId, 0L);
    }

    @Override
    public void addApiToCategories(String apiId, Set<String> categoryIds) {
        if (Objects.isNull(categoryIds) || categoryIds.isEmpty()) {
            return;
        }
        categoryIds.forEach(categoryId -> {
            Set currentCategoryApis = this.apiCategoryOrderRepository.findAllByCategoryId(categoryId);
            if (currentCategoryApis.stream().anyMatch(c -> Objects.equals(c.getApiId(), apiId))) {
                return;
            }
            ApiCategoryOrder.ApiCategoryOrderBuilder apiCategoryOrderToSave = ApiCategoryOrder.builder().apiId(apiId).categoryId(categoryId);
            if (currentCategoryApis.isEmpty()) {
                apiCategoryOrderToSave.order(0);
            } else {
                ApiCategoryOrder maxOrder = currentCategoryApis.stream().max(Comparator.comparing(ApiCategoryOrder::getOrder)).get();
                apiCategoryOrderToSave.order(maxOrder.getOrder() + 1);
            }
            try {
                this.apiCategoryOrderRepository.create(apiCategoryOrderToSave.build());
            }
            catch (TechnicalException e) {
                log.error("Could not create ApiCategoryOrder, {}", (Object)apiCategoryOrderToSave.build(), (Object)e);
            }
        });
    }

    @Override
    public void changeApiOrderInCategory(String apiId, String categoryId, int newOrder) {
        Set allByCategoryId = this.apiCategoryOrderRepository.findAllByCategoryId(categoryId);
        ApiCategoryOrder apiCategoryToUpdate = allByCategoryId.stream().filter(apiCategoryOrder -> Objects.equals(apiCategoryOrder.getApiId(), apiId)).findFirst().orElseThrow(() -> new ApiNotInCategoryException(Map.of("api", apiId, "category", categoryId)));
        int oldOrder = apiCategoryToUpdate.getOrder();
        if (oldOrder == newOrder) {
            return;
        }
        boolean isMovingUp = oldOrder > newOrder;
        allByCategoryId.stream().filter(apiCategoryOrder -> {
            if (isMovingUp) {
                return apiCategoryOrder.getOrder() >= newOrder && apiCategoryOrder.getOrder() < oldOrder;
            }
            return apiCategoryOrder.getOrder() <= newOrder && apiCategoryOrder.getOrder() > oldOrder;
        }).forEach(apiCategoryOrder -> this.updateOrder((ApiCategoryOrder)apiCategoryOrder, isMovingUp ? apiCategoryOrder.getOrder() + 1 : apiCategoryOrder.getOrder() - 1));
        this.updateOrder(apiCategoryToUpdate, newOrder);
    }

    @Override
    public void updateApiCategories(String apiId, Set<String> categoryIds) {
        if (Objects.isNull(categoryIds)) {
            return;
        }
        Set currentApiCategoryIds = this.apiCategoryOrderRepository.findAllByApiId(apiId).stream().map(ApiCategoryOrder::getCategoryId).collect(Collectors.toSet());
        Set<String> categoriesToAdd = categoryIds.stream().filter(cat -> !currentApiCategoryIds.contains(cat)).collect(Collectors.toSet());
        this.addApiToCategories(apiId, categoriesToAdd);
        currentApiCategoryIds.stream().filter(cat -> !categoryIds.contains(cat)).forEach(cat -> this.removeApiFromCategory(apiId, (String)cat));
    }

    @Override
    public void deleteApiFromCategories(String apiId) {
        this.apiCategoryOrderRepository.findAllByApiId(apiId).forEach(apiCategoryOrder -> this.removeApiFromCategory(apiId, apiCategoryOrder.getCategoryId()));
    }

    private List<String> getUserMembershipApiIds(String userId) {
        return this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.API).stream().map(MembershipEntity::getReferenceId).collect(Collectors.toList());
    }

    private List<String> getUserGroupIdsWithApiRole(String userId) {
        return this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.GROUP).stream().filter(m -> {
            RoleEntity roleInGroup = this.roleService.findById(m.getRoleId());
            return m.getRoleId() != null && roleInGroup.getScope().equals((Object)RoleScope.API);
        }).map(MembershipEntity::getReferenceId).collect(Collectors.toList());
    }

    private void updateOrder(ApiCategoryOrder apiCategoryOrder, int newOrder) {
        apiCategoryOrder.setOrder(newOrder);
        try {
            this.apiCategoryOrderRepository.update(apiCategoryOrder);
        }
        catch (TechnicalException e) {
            log.error("Could not update ApiCategoryOrder position [{}]", (Object)apiCategoryOrder, (Object)e);
        }
    }

    private void removeApiFromCategory(String apiId, String categoryId) {
        Set allByCategoryId = this.apiCategoryOrderRepository.findAllByCategoryId(categoryId);
        ApiCategoryOrder apiCategoryToDelete = allByCategoryId.stream().filter(apiCategoryOrder -> Objects.equals(apiCategoryOrder.getApiId(), apiId)).findFirst().orElseThrow(() -> new ApiNotInCategoryException(Map.of("api", apiId, "category", categoryId)));
        try {
            this.apiCategoryOrderRepository.delete(apiCategoryToDelete.getApiId(), apiCategoryToDelete.getCategoryId());
        }
        catch (TechnicalException e) {
            log.error("Could not delete API [{}] from ApiCategoryOrders", (Object)apiId, (Object)e);
            return;
        }
        allByCategoryId.stream().filter(apiCategoryOrder1 -> apiCategoryOrder1.getOrder() > apiCategoryToDelete.getOrder()).forEach(apiCategoryOrder -> this.updateOrder((ApiCategoryOrder)apiCategoryOrder, apiCategoryOrder.getOrder() - 1));
    }
}

