/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.WorkflowRepository;
import io.gravitee.repository.management.model.Workflow;
import io.gravitee.rest.api.model.WorkflowReferenceType;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.WorkflowType;
import io.gravitee.rest.api.service.WorkflowService;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class WorkflowServiceImpl
extends TransactionalService
implements WorkflowService {
    private final Logger LOGGER = LoggerFactory.getLogger(WorkflowServiceImpl.class);
    @Lazy
    @Autowired
    private WorkflowRepository workflowRepository;

    @Override
    public Workflow create(WorkflowReferenceType referenceType, String referenceId, WorkflowType type, String user, WorkflowState state, String comment) {
        Workflow workflow = new Workflow();
        workflow.setId(UuidString.generateRandom());
        workflow.setReferenceType(referenceType.name());
        workflow.setReferenceId(referenceId);
        workflow.setType(type.name());
        workflow.setUser(user);
        workflow.setState(state.name());
        workflow.setComment(comment);
        workflow.setCreatedAt(new Date());
        try {
            return (Workflow)this.workflowRepository.create((Object)workflow);
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to create workflow of type " + workflow.getType();
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public List<Workflow> findByReferenceAndType(WorkflowReferenceType referenceType, String referenceId, WorkflowType type) {
        try {
            return this.workflowRepository.findByReferenceAndType(referenceType.name(), referenceId, type.name());
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to find workflow by ref " + String.valueOf(referenceType) + "/" + referenceId + " and type " + String.valueOf(type);
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }
}

