/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.scoring.model.ScoringRuleset;
import io.gravitee.apim.infra.adapter.ScoringRulesetAdapter;
import io.gravitee.repository.management.model.ScoringRuleset;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class ScoringRulesetAdapterImpl
implements ScoringRulesetAdapter {
    @Override
    public ScoringRuleset toEntity(io.gravitee.repository.management.model.ScoringRuleset source) {
        if (source == null) {
            return null;
        }
        ScoringRuleset.ScoringRulesetBuilder scoringRuleset = ScoringRuleset.builder();
        scoringRuleset.id(source.getId());
        scoringRuleset.name(source.getName());
        scoringRuleset.description(source.getDescription());
        scoringRuleset.format(this.map(source.getFormat()));
        scoringRuleset.referenceId(source.getReferenceId());
        if (source.getReferenceType() != null) {
            scoringRuleset.referenceType(Enum.valueOf(ScoringRuleset.ReferenceType.class, source.getReferenceType()));
        }
        scoringRuleset.payload(source.getPayload());
        if (source.getCreatedAt() != null) {
            scoringRuleset.createdAt(ZonedDateTime.ofInstant(source.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (source.getUpdatedAt() != null) {
            scoringRuleset.updatedAt(ZonedDateTime.ofInstant(source.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        return scoringRuleset.build();
    }

    @Override
    public io.gravitee.repository.management.model.ScoringRuleset toRepository(ScoringRuleset source) {
        if (source == null) {
            return null;
        }
        ScoringRuleset.ScoringRulesetBuilder scoringRuleset = io.gravitee.repository.management.model.ScoringRuleset.builder();
        scoringRuleset.id(source.id());
        scoringRuleset.name(source.name());
        scoringRuleset.description(source.description());
        scoringRuleset.format(this.map(source.format()));
        scoringRuleset.referenceId(source.referenceId());
        if (source.referenceType() != null) {
            scoringRuleset.referenceType(source.referenceType().name());
        }
        if (source.createdAt() != null) {
            scoringRuleset.createdAt(Date.from(source.createdAt().toInstant()));
        }
        if (source.updatedAt() != null) {
            scoringRuleset.updatedAt(Date.from(source.updatedAt().toInstant()));
        }
        scoringRuleset.payload(source.payload());
        return scoringRuleset.build();
    }
}

