/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.exception;

import io.gravitee.common.util.Maps;
import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class InvalidHostException
extends AbstractManagementException {
    private final String host;
    private final List<String> restrictions;

    public InvalidHostException(String host, List<String> restrictions) {
        this.host = host;
        this.restrictions = restrictions;
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getTechnicalCode() {
        return "path.host.invalid";
    }

    @Override
    public Map<String, String> getParameters() {
        return Maps.builder().put((Object)"host", (Object)this.host).put((Object)"restrictions", (Object)String.join((CharSequence)",", this.restrictions)).build();
    }

    @Override
    public String getMessage() {
        return "Host [" + this.host + "] must be a subdomain of " + String.valueOf(this.restrictions);
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public List<String> getRestrictions() {
        return this.restrictions;
    }
}

