/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.apim.core.api.domain_service.NotificationCRDDomainService;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.DefinitionContext;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.model.BasePlanEntity;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.api.ApiCRDEntity;
import io.gravitee.rest.api.model.api.ApiCRDStatusEntity;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.api.DefinitionContextEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.ApiCRDService;
import io.gravitee.rest.api.service.ApiDefinitionContextService;
import io.gravitee.rest.api.service.ApiDuplicatorService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import jakarta.inject.Inject;
import jakarta.ws.rs.BadRequestException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ApiCRDServiceImpl
extends AbstractService
implements ApiCRDService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiCRDServiceImpl.class);
    @Inject
    private ObjectMapper objectMapper;
    @Inject
    private ApiService apiService;
    @Inject
    private ApiDuplicatorService apiDuplicatorService;
    @Inject
    private ParameterService parameterService;
    @Inject
    private PlanService planService;
    @Inject
    private ApiDefinitionContextService definitionContextService;
    @Inject
    private MembershipService membershipService;
    @Inject
    private NotificationCRDDomainService notificationCRDService;

    @Override
    public ApiCRDStatusEntity importApiDefinitionCRD(ExecutionContext executionContext, ApiCRDEntity api) {
        try {
            ApiEntity existingApiEntity = this.apiService.findByEnvironmentIdAndCrossId(executionContext.getEnvironmentId(), api.getCrossId()).orElse(null);
            String sanitizedApiDefinition = this.objectMapper.writeValueAsString((Object)api);
            ApiEntity importedApi = existingApiEntity != null ? this.apiDuplicatorService.updateWithImportedDefinition(executionContext, null, sanitizedApiDefinition) : this.apiDuplicatorService.createWithImportedDefinition(executionContext, sanitizedApiDefinition);
            this.updateApiDefinitionContext(importedApi, api);
            if (api.getDefinitionContext().isSyncFromManagement()) {
                this.apiService.deploy(executionContext, importedApi.getId(), this.getAuthenticatedUsername(), EventType.PUBLISH_API, new ApiDeploymentEntity());
            }
            this.updateApiState(existingApiEntity, importedApi);
            this.transferOwnerShip(executionContext, importedApi.getId());
            Map<String, String> plansByCrossId = this.planService.findByApi(executionContext, importedApi.getId()).stream().collect(Collectors.toMap(BasePlanEntity::getCrossId, BasePlanEntity::getId));
            this.notificationCRDService.syncApiPortalNotifications(importedApi.getId(), this.getAuthenticatedUsername(), api.getConsoleNotificationConfiguration());
            return new ApiCRDStatusEntity(executionContext.getOrganizationId(), executionContext.getEnvironmentId(), importedApi.getId(), importedApi.getCrossId(), api.getState(), null, plansByCrossId);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("An error occurs while trying to JSON deserialize the API {}", (Object)api, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to JSON deserialize the API definition.");
        }
    }

    private void updateApiDefinitionContext(ApiEntity importedApi, ApiCRDEntity api) {
        if (!importedApi.getDefinitionContext().equals((Object)api.getDefinitionContext())) {
            DefinitionContext definitionContext = api.getDefinitionContext();
            this.definitionContextService.setDefinitionContext(importedApi.getId(), new DefinitionContextEntity(definitionContext.getOrigin(), definitionContext.getMode(), definitionContext.getSyncFrom()));
        }
    }

    private void transferOwnerShip(ExecutionContext executionContext, String apiId) {
        UserDetails authenticatedUser = this.getAuthenticatedUser();
        MembershipEntity currentPrimaryOwner = this.membershipService.getPrimaryOwner(executionContext.getOrganizationId(), MembershipReferenceType.API, apiId);
        if (currentPrimaryOwner.getMemberId().equals(authenticatedUser.getUsername())) {
            LOGGER.debug("user {} is already the primary owner of API {}", (Object)authenticatedUser.getUsername(), (Object)apiId);
            return;
        }
        MembershipService.MembershipMember primaryOwner = new MembershipService.MembershipMember(authenticatedUser.getUsername(), null, MembershipMemberType.USER);
        this.membershipService.transferApiOwnership(executionContext, apiId, primaryOwner, List.of());
    }

    private void updateApiState(ApiEntity existingApiEntity, ApiEntity importedApi) {
        if (existingApiEntity == null || existingApiEntity.getState() != importedApi.getState()) {
            if (Lifecycle.State.STARTED == importedApi.getState()) {
                this.checkApiLifeCycle(importedApi);
                this.apiService.start(GraviteeContext.getExecutionContext(), importedApi.getId(), this.getAuthenticatedUsername());
            } else if (Lifecycle.State.STOPPED == importedApi.getState()) {
                this.checkApiLifeCycle(importedApi);
                this.apiService.stop(GraviteeContext.getExecutionContext(), importedApi.getId(), this.getAuthenticatedUsername());
            }
        }
    }

    private void checkApiLifeCycle(ApiEntity api) {
        boolean apiReviewEnabled;
        if (ApiLifecycleState.ARCHIVED.equals((Object)api.getLifecycleState())) {
            throw new BadRequestException(String.format("lifecycle state of deleted API [%s] cannot be changed", api.getId()));
        }
        if (api.getState() == Lifecycle.State.STOPPED && (apiReviewEnabled = this.parameterService.findAsBoolean(GraviteeContext.getExecutionContext(), Key.API_REVIEW_ENABLED, ParameterReferenceType.ENVIRONMENT)) && api.getWorkflowState() != null && !WorkflowState.REVIEW_OK.equals((Object)api.getWorkflowState())) {
            throw new BadRequestException("API cannot be started without being reviewed");
        }
    }
}

