/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.shared_policy_group.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.apim.core.shared_policy_group.crud_service.SharedPolicyGroupCrudService;
import io.gravitee.apim.core.shared_policy_group.domain_service.ValidateSharedPolicyGroupCRDDomainService;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroupCRD;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroupCRDStatus;
import io.gravitee.apim.core.shared_policy_group.use_case.CreateSharedPolicyGroupUseCase;
import io.gravitee.apim.core.shared_policy_group.use_case.DeploySharedPolicyGroupUseCase;
import io.gravitee.apim.core.shared_policy_group.use_case.UpdateSharedPolicyGroupUseCase;
import io.gravitee.apim.core.validation.Validator;
import java.util.Optional;
import lombok.Generated;

@UseCase
public class ImportSharedPolicyGroupCRDCRDUseCase {
    private final CreateSharedPolicyGroupUseCase createSharedPolicyGroupUseCase;
    private final UpdateSharedPolicyGroupUseCase updateSharedPolicyGroupUseCase;
    private final DeploySharedPolicyGroupUseCase deploySharedPolicyGroupUseCase;
    private final ValidateSharedPolicyGroupCRDDomainService validateSharedPolicyGroupCRDDomainService;
    private final SharedPolicyGroupCrudService sharedPolicyGroupCrudService;

    public Output execute(Input input) {
        Validator.Result<ValidateSharedPolicyGroupCRDDomainService.Input> validationResult = this.validateSharedPolicyGroupCRDDomainService.validateAndSanitize(new ValidateSharedPolicyGroupCRDDomainService.Input(input.auditInfo, input.crd));
        validationResult.severe().ifPresent(errors -> {
            throw new ValidationDomainException(String.format("Unable to import because of errors [%s]", String.join((CharSequence)",", errors.stream().map(Validator.Error::getMessage).toList())));
        });
        Optional<SharedPolicyGroup> sharedPolicyGroup = this.sharedPolicyGroupCrudService.findByEnvironmentIdAndCrossId(input.auditInfo.environmentId(), input.crd.getCrossId());
        if (sharedPolicyGroup.isPresent()) {
            return this.updateSharedPolicyGroup(input);
        }
        return this.createSharedPolicyGroup(input);
    }

    private Output createSharedPolicyGroup(Input input) {
        CreateSharedPolicyGroupUseCase.Output output = this.createSharedPolicyGroupUseCase.execute(new CreateSharedPolicyGroupUseCase.Input(input.crd().toCreateSharedPolicyGroup(), input.auditInfo));
        Output result = new Output(new SharedPolicyGroupCRDStatus(output.sharedPolicyGroup().getCrossId(), output.sharedPolicyGroup().getId(), input.auditInfo.organizationId(), input.auditInfo.environmentId(), null));
        this.deploySharedPolicyGroupUseCase.execute(new DeploySharedPolicyGroupUseCase.Input(output.sharedPolicyGroup().getId(), input.auditInfo.environmentId(), input.auditInfo));
        return result;
    }

    private Output updateSharedPolicyGroup(Input input) {
        UpdateSharedPolicyGroupUseCase.Output output = this.updateSharedPolicyGroupUseCase.execute(new UpdateSharedPolicyGroupUseCase.Input(input.crd.getSharedPolicyGroupId(), input.crd.toUpdateSharedPolicyGroup(), input.auditInfo));
        if (output.sharedPolicyGroup().getLifecycleState() != SharedPolicyGroup.SharedPolicyGroupLifecycleState.DEPLOYED) {
            this.deploySharedPolicyGroupUseCase.execute(new DeploySharedPolicyGroupUseCase.Input(output.sharedPolicyGroup().getId(), input.auditInfo.environmentId(), input.auditInfo));
        }
        return new Output(new SharedPolicyGroupCRDStatus(output.sharedPolicyGroup().getCrossId(), output.sharedPolicyGroup().getId(), input.auditInfo.organizationId(), input.auditInfo.environmentId(), null));
    }

    @Generated
    public ImportSharedPolicyGroupCRDCRDUseCase(CreateSharedPolicyGroupUseCase createSharedPolicyGroupUseCase, UpdateSharedPolicyGroupUseCase updateSharedPolicyGroupUseCase, DeploySharedPolicyGroupUseCase deploySharedPolicyGroupUseCase, ValidateSharedPolicyGroupCRDDomainService validateSharedPolicyGroupCRDDomainService, SharedPolicyGroupCrudService sharedPolicyGroupCrudService) {
        this.createSharedPolicyGroupUseCase = createSharedPolicyGroupUseCase;
        this.updateSharedPolicyGroupUseCase = updateSharedPolicyGroupUseCase;
        this.deploySharedPolicyGroupUseCase = deploySharedPolicyGroupUseCase;
        this.validateSharedPolicyGroupCRDDomainService = validateSharedPolicyGroupCRDDomainService;
        this.sharedPolicyGroupCrudService = sharedPolicyGroupCrudService;
    }

    public record Input(AuditInfo auditInfo, SharedPolicyGroupCRD crd) {
    }

    public record Output(SharedPolicyGroupCRDStatus status) {
    }
}

