/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.PlanAuditEvent;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.exception.InvalidPlanStatusForDeprecationException;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import java.util.Map;
import lombok.Generated;

@DomainService
public class DeprecatePlanDomainService {
    private final PlanCrudService planCrudService;
    private final AuditDomainService auditService;

    public void deprecate(String planId, AuditInfo auditInfo, boolean allowStaging) {
        Plan originalPlan = this.planCrudService.getById(planId);
        if (PlanStatus.DEPRECATED == originalPlan.getPlanStatus() || PlanStatus.CLOSED == originalPlan.getPlanStatus() || PlanStatus.STAGING == originalPlan.getPlanStatus() && !allowStaging) {
            throw new InvalidPlanStatusForDeprecationException(originalPlan.getId(), originalPlan.getPlanStatus());
        }
        Plan planToDeprecate = originalPlan.copy();
        planToDeprecate.setUpdatedAt(TimeProvider.now());
        planToDeprecate.setPlanStatus(PlanStatus.DEPRECATED);
        Plan deprecatedPlan = this.planCrudService.update(planToDeprecate);
        this.createAuditLog(originalPlan, deprecatedPlan, auditInfo);
    }

    private void createAuditLog(Plan originalPlan, Plan planUpdated, AuditInfo auditInfo) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(originalPlan.getApiId()).event(PlanAuditEvent.PLAN_DEPRECATED).actor(auditInfo.actor()).oldValue(originalPlan).newValue(planUpdated).createdAt(TimeProvider.now()).properties(Map.of(AuditProperties.PLAN, originalPlan.getId())).build());
    }

    @Generated
    public DeprecatePlanDomainService(PlanCrudService planCrudService, AuditDomainService auditService) {
        this.planCrudService = planCrudService;
        this.auditService = auditService;
    }
}

