/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiIndexerDomainService;
import io.gravitee.apim.core.api.domain_service.CreateApiDomainService;
import io.gravitee.apim.core.api.domain_service.UpdateFederatedApiDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateFederatedApiDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.async_job.crud_service.AsyncJobCrudService;
import io.gravitee.apim.core.async_job.model.AsyncJob;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.exception.NotAllowedDomainException;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.exception.FederatedAgentIngestionException;
import io.gravitee.apim.core.integration.exception.IntegrationNotFoundException;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.integration.service_provider.A2aAgentFetcher;
import io.gravitee.apim.core.integration.service_provider.IntegrationAgent;
import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerFactory;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.domain_service.CreatePlanDomainService;
import io.gravitee.apim.core.plan.domain_service.UpdatePlanDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.federation.FederatedAgent;
import io.gravitee.definition.model.federation.FederatedPlan;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.model.v4.plan.PlanSecurityType;
import io.gravitee.rest.api.service.common.UuidString;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class StartIngestIntegrationApisUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StartIngestIntegrationApisUseCase.class);
    private final IntegrationCrudService integrationCrudService;
    private final AsyncJobCrudService asyncJobCrudService;
    private final IntegrationAgent integrationAgent;
    private final LicenseDomainService licenseDomainService;
    private final CreateApiDomainService createApiDomainService;
    private final UpdateFederatedApiDomainService updateFederatedApiDomainService;
    private final ApiIndexerDomainService apiIndexerDomainService;
    private final A2aAgentFetcher a2aAgentFetcher;
    private final ApiPrimaryOwnerFactory apiPrimaryOwnerFactory;
    private final ValidateFederatedApiDomainService validateFederatedApi;
    private final CreatePlanDomainService createPlanDomainService;
    private final UpdatePlanDomainService updatePlanDomainService;
    private final PlanCrudService planCrudService;
    private final ApiCrudService apiCrudService;

    public Single<AsyncJob.Status> execute(Input input) {
        AuditInfo auditInfo = input.auditInfo;
        String integrationId = input.integrationId;
        String organizationId = auditInfo.organizationId();
        String environmentId = auditInfo.environmentId();
        if (!this.licenseDomainService.isFederationFeatureAllowed(organizationId)) {
            return Single.error((Throwable)NotAllowedDomainException.noLicenseForFederation());
        }
        Optional<Integration> integ = this.integrationCrudService.findById(integrationId).filter(integration -> integration.environmentId().equals(environmentId));
        if (integ.isEmpty()) {
            return Single.error((Throwable)new IntegrationNotFoundException(integrationId));
        }
        Integration integration2 = integ.get();
        Objects.requireNonNull(integration2);
        Integration integration3 = integration2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integration.ApiIntegration.class, Integration.A2aIntegration.class}, (Object)integration3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Integration.ApiIntegration apiIntegration = (Integration.ApiIntegration)integration3;
                yield Single.just((Object)apiIntegration).flatMap(integration -> this.startApiIngestion(input, (Integration.ApiIntegration)integration, auditInfo)).doOnError(throwable -> log.error("Error to start ingest {}", (Object)integrationId, throwable));
            }
            case 1 -> {
                Integration.A2aIntegration a2aIntegration = (Integration.A2aIntegration)integration3;
                yield this.a2aIngestions(a2aIntegration, auditInfo);
            }
        };
    }

    private Single<AsyncJob.Status> startApiIngestion(Input input, Integration.ApiIntegration integration, AuditInfo auditInfo) {
        return this.integrationAgent.startIngest(integration.id(), UuidString.generateRandom(), input.apiIds()).map(ingestStarted -> {
            log.info("Ingestion started for integration {}", (Object)integration.id());
            if (ingestStarted.total() == 0L) {
                log.info("No APIs to ingest for integration {}", (Object)integration.id());
                return AsyncJob.Status.SUCCESS;
            }
            this.asyncJobCrudService.create(this.newIngestJob(ingestStarted.ingestJobId(), integration, auditInfo.actor().userId(), ingestStarted.total()));
            return AsyncJob.Status.PENDING;
        });
    }

    private Single<AsyncJob.Status> a2aIngestions(Integration.A2aIntegration a2aIntegration, AuditInfo auditInfo) {
        Single single;
        block8: {
            ApiIndexerDomainService.Bulk bulk = this.apiIndexerDomainService.bulk(auditInfo);
            try {
                single = Flowable.fromIterable(a2aIntegration.wellKnownUrls()).flatMapMaybe(url -> this.a2aIngestion(bulk, url.url(), a2aIntegration, auditInfo)).toList().flatMap(failedUrls -> {
                    if (!failedUrls.isEmpty()) {
                        return Single.error((Throwable)new FederatedAgentIngestionException((List<String>)failedUrls));
                    }
                    return Single.just((Object)((Object)AsyncJob.Status.SUCCESS));
                });
                if (bulk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (bulk != null) {
                        try {
                            bulk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Single.error((Throwable)new FederatedAgentIngestionException("Ingestion failed", e));
                }
            }
            bulk.close();
        }
        return single;
    }

    private Maybe<String> a2aIngestion(ApiIndexerDomainService.Bulk bulk, String url, Integration.A2aIntegration a2aIntegration, AuditInfo auditInfo) {
        return this.a2aAgentFetcher.fetchAgentCard(url).toMaybe().flatMap(federatedAgent -> {
            PrimaryOwnerEntity owner = this.apiPrimaryOwnerFactory.createForNewApi(auditInfo.organizationId(), a2aIntegration.environmentId(), auditInfo.actor().userId());
            String id = UuidString.generateForEnvironment(a2aIntegration.environmentId(), a2aIntegration.id(), url, federatedAgent.getUrl());
            Object api = ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)Api.builder().id(id)).name(federatedAgent.getName())).description(federatedAgent.getDescription())).version(federatedAgent.getVersion())).createdAt(TimeProvider.now())).updatedAt(TimeProvider.now())).definitionVersion(DefinitionVersion.FEDERATED_AGENT)).environmentId(a2aIntegration.environmentId())).originContext((OriginContext)new OriginContext.Integration(a2aIntegration.id(), a2aIntegration.name(), a2aIntegration.provider()))).federatedAgent((FederatedAgent)federatedAgent)).build();
            UnaryOperator<Api> updater = StartIngestIntegrationApisUseCase.update(api);
            this.apiCrudService.findById(id).ifPresentOrElse(previous -> this.updateFederatedApiDomainService.update(id, updater, bulk.auditInfo(), owner, bulk.get()), () -> this.createApiDomainService.create((Api)api, owner, auditInfo, e -> this.validateFederatedApi.validateAndSanitizeForCreation((Api)e, owner), bulk.get()));
            Plan plan = StartIngestIntegrationApisUseCase.fromIntegration(api);
            this.planCrudService.findById(plan.getId()).ifPresentOrElse(existingPlan -> this.updatePlanDomainService.update(plan, List.of(), Map.of(), (Api)api, bulk.auditInfo()), () -> this.createPlanDomainService.create(plan, List.of(), (Api)api, bulk.auditInfo()));
            return Maybe.empty();
        }).onErrorReturnItem((Object)url);
    }

    public AsyncJob newIngestJob(String id, Integration integration, String initiatorId, Long total) {
        ZonedDateTime now = TimeProvider.now();
        return AsyncJob.builder().id(id).sourceId(integration.id()).environmentId(integration.environmentId()).initiatorId(initiatorId).type(AsyncJob.Type.FEDERATED_APIS_INGESTION).status(AsyncJob.Status.PENDING).upperLimit(total).createdAt(now).updatedAt(now).deadLine(now.plus(Duration.ofMinutes(5L))).build();
    }

    static UnaryOperator<Api> update(Api newOne) {
        return previousApi -> ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)previousApi.toBuilder().name(newOne.getName())).description(newOne.getDescription())).version(newOne.getVersion())).federatedAgent(newOne.getFederatedAgent())).build();
    }

    public static Plan fromIntegration(Api api) {
        String id = UuidString.generateForEnvironment(api.getId(), PlanSecurityType.KEY_LESS.getLabel());
        ZonedDateTime now = TimeProvider.now();
        String oid = api.getFederatedAgent().getProvider() != null ? api.getFederatedAgent().getProvider().organization() : null;
        return ((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)Plan.builder().id(id)).name("Key less plan")).description("Default plan")).apiId(api.getId())).federatedPlanDefinition(FederatedPlan.builder().id(id).providerId(oid).security(PlanSecurity.builder().type(PlanSecurityType.KEY_LESS.getLabel()).build()).status(PlanStatus.PUBLISHED).build())).characteristics(List.of())).environmentId(api.getEnvironmentId())).createdAt(now)).updatedAt(now)).validation(Plan.PlanValidationType.MANUAL)).build();
    }

    @Generated
    public StartIngestIntegrationApisUseCase(IntegrationCrudService integrationCrudService, AsyncJobCrudService asyncJobCrudService, IntegrationAgent integrationAgent, LicenseDomainService licenseDomainService, CreateApiDomainService createApiDomainService, UpdateFederatedApiDomainService updateFederatedApiDomainService, ApiIndexerDomainService apiIndexerDomainService, A2aAgentFetcher a2aAgentFetcher, ApiPrimaryOwnerFactory apiPrimaryOwnerFactory, ValidateFederatedApiDomainService validateFederatedApi, CreatePlanDomainService createPlanDomainService, UpdatePlanDomainService updatePlanDomainService, PlanCrudService planCrudService, ApiCrudService apiCrudService) {
        this.integrationCrudService = integrationCrudService;
        this.asyncJobCrudService = asyncJobCrudService;
        this.integrationAgent = integrationAgent;
        this.licenseDomainService = licenseDomainService;
        this.createApiDomainService = createApiDomainService;
        this.updateFederatedApiDomainService = updateFederatedApiDomainService;
        this.apiIndexerDomainService = apiIndexerDomainService;
        this.a2aAgentFetcher = a2aAgentFetcher;
        this.apiPrimaryOwnerFactory = apiPrimaryOwnerFactory;
        this.validateFederatedApi = validateFederatedApi;
        this.createPlanDomainService = createPlanDomainService;
        this.updatePlanDomainService = updatePlanDomainService;
        this.planCrudService = planCrudService;
        this.apiCrudService = apiCrudService;
    }

    public record Input(String integrationId, List<String> apiIds, AuditInfo auditInfo) {
    }
}

