/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.async_job.model.AsyncJob;
import io.gravitee.apim.core.async_job.query_service.AsyncJobQueryService;
import io.gravitee.apim.core.exception.NotAllowedDomainException;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.exception.IntegrationNotFoundException;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.integration.model.IntegrationView;
import io.gravitee.apim.core.integration.service_provider.IntegrationAgent;
import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import io.gravitee.apim.core.membership.domain_service.IntegrationPrimaryOwnerDomainService;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

@UseCase
public class GetIntegrationUseCase {
    private final IntegrationCrudService integrationCrudService;
    private final AsyncJobQueryService asyncJobQueryService;
    private final LicenseDomainService licenseDomainService;
    private final IntegrationAgent integrationAgent;
    private final IntegrationPrimaryOwnerDomainService integrationPrimaryOwnerDomainService;

    public Output execute(Input input) {
        String integrationId = input.integrationId();
        if (!this.licenseDomainService.isFederationFeatureAllowed(input.organizationId())) {
            throw NotAllowedDomainException.noLicenseForFederation();
        }
        Integration integration = this.integrationCrudService.findById(integrationId).orElseThrow(() -> new IntegrationNotFoundException(integrationId));
        IntegrationView.PrimaryOwner primaryOwner = (IntegrationView.PrimaryOwner)this.integrationPrimaryOwnerDomainService.getIntegrationPrimaryOwner(input.organizationId(), integration.id()).map(po -> new IntegrationView.PrimaryOwner(po.id(), po.email(), po.displayName())).onErrorComplete().blockingGet();
        Integration integration2 = integration;
        Objects.requireNonNull(integration2);
        Integration integration3 = integration2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integration.ApiIntegration.class, Integration.A2aIntegration.class}, (Object)integration3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Integration.ApiIntegration apiIntegration = (Integration.ApiIntegration)integration3;
                IntegrationView.AgentStatus agentStatus = (IntegrationView.AgentStatus)((Object)this.integrationAgent.getAgentStatusFor(integrationId).map(status -> IntegrationView.AgentStatus.valueOf(status.name())).blockingGet());
                Optional<AsyncJob> pendingJob = this.asyncJobQueryService.findPendingJobFor(integrationId);
                yield new Output(new IntegrationView(apiIntegration, agentStatus, (AsyncJob)pendingJob.orElse(null), primaryOwner));
            }
            case 1 -> {
                Integration.A2aIntegration a2aIntegration = (Integration.A2aIntegration)integration3;
                yield new Output(new IntegrationView(a2aIntegration, primaryOwner));
            }
        };
    }

    @Generated
    public GetIntegrationUseCase(IntegrationCrudService integrationCrudService, AsyncJobQueryService asyncJobQueryService, LicenseDomainService licenseDomainService, IntegrationAgent integrationAgent, IntegrationPrimaryOwnerDomainService integrationPrimaryOwnerDomainService) {
        this.integrationCrudService = integrationCrudService;
        this.asyncJobQueryService = asyncJobQueryService;
        this.licenseDomainService = licenseDomainService;
        this.integrationAgent = integrationAgent;
        this.integrationPrimaryOwnerDomainService = integrationPrimaryOwnerDomainService;
    }

    public record Input(String integrationId, String organizationId) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String integrationId;
            @Generated
            private String organizationId;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder integrationId(String integrationId) {
                this.integrationId = integrationId;
                return this;
            }

            @Generated
            public InputBuilder organizationId(String organizationId) {
                this.organizationId = organizationId;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.integrationId, this.organizationId);
            }

            @Generated
            public String toString() {
                return "GetIntegrationUseCase.Input.InputBuilder(integrationId=" + this.integrationId + ", organizationId=" + this.organizationId + ")";
            }
        }
    }

    public record Output(IntegrationView integration) {
    }
}

