/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiFieldFilter;
import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.apim.core.api.model.factory.ApiModelFactory;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.exception.NotAllowedDomainException;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.exception.IntegrationNotFoundException;
import io.gravitee.apim.core.integration.model.IntegrationApi;
import io.gravitee.apim.core.integration.service_provider.IntegrationAgent;
import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class DiscoveryUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiscoveryUseCase.class);
    private final IntegrationAgent integrationAgent;
    private final LicenseDomainService licenseDomainService;
    private final ApiQueryService apiQueryService;
    private final IntegrationCrudService integrationCrudService;

    public Single<Output> execute(Input input) {
        if (!this.licenseDomainService.isFederationFeatureAllowed(input.auditInfo.organizationId())) {
            return Single.error((Throwable)NotAllowedDomainException.noLicenseForFederation());
        }
        String integrationId = input.integrationId;
        Function<IntegrationApi, Output.State> computeState = this.apiStateComputing(input.auditInfo().environmentId(), integrationId);
        return Maybe.fromOptional(this.integrationCrudService.findApiIntegrationById(integrationId)).filter(integration -> integration.environmentId().equals(input.auditInfo.environmentId())).switchIfEmpty((SingleSource)Single.error((Throwable)new IntegrationNotFoundException(integrationId))).flatMapPublisher(integration -> this.integrationAgent.discoverApis(integration.id())).map(discoveredApi -> new Output.PreviewApi((IntegrationApi)discoveredApi, (Output.State)((Object)((Object)computeState.apply((IntegrationApi)discoveredApi))))).toList().map(Output::new).doOnError(throwable -> {
            if (!(throwable instanceof IntegrationNotFoundException)) {
                log.error("Error during discovery on integration {}", (Object)integrationId, throwable);
            }
        });
    }

    private Function<IntegrationApi, Output.State> apiStateComputing(String environmentId, String integrationId) {
        Set alreadyIngestedApisIds = this.apiQueryService.search(ApiSearchCriteria.builder().integrationId(integrationId).build(), null, ApiFieldFilter.builder().pictureExcluded(true).definitionExcluded(true).build()).map(Api::getId).collect(Collectors.toSet());
        return discoveredApi -> {
            String discoveredApiId = ApiModelFactory.generateFederatedApiId(environmentId, integrationId, discoveredApi);
            return alreadyIngestedApisIds.contains(discoveredApiId) ? Output.State.UPDATE : Output.State.NEW;
        };
    }

    @Generated
    public DiscoveryUseCase(IntegrationAgent integrationAgent, LicenseDomainService licenseDomainService, ApiQueryService apiQueryService, IntegrationCrudService integrationCrudService) {
        this.integrationAgent = integrationAgent;
        this.licenseDomainService = licenseDomainService;
        this.apiQueryService = apiQueryService;
        this.integrationCrudService = integrationCrudService;
    }

    public record Input(String integrationId, AuditInfo auditInfo) {
    }

    public record Output(Collection<PreviewApi> apis) {

        public static enum State {
            NEW,
            UPDATE;

        }

        public record PreviewApi(String id, String name, String version, State state) {
            public PreviewApi(IntegrationApi api, State state) {
                this(api.id(), api.name(), api.version(), state);
            }
        }
    }
}

