/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.event.model;

import io.gravitee.rest.api.model.EventType;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public class Event {
    private String id;
    private EventType type;
    private String payload;
    private String parentId;
    private EnumMap<EventProperties, String> properties;
    private Set<String> environments;
    private ZonedDateTime createdAt;
    private ZonedDateTime updatedAt;

    @Generated
    private static EnumMap<EventProperties, String> $default$properties() {
        return new EnumMap<EventProperties, String>(EventProperties.class);
    }

    @Generated
    private static Set<String> $default$environments() {
        return Set.of();
    }

    @Generated
    protected Event(EventBuilder<?, ?> b) {
        this.id = b.id;
        this.type = b.type;
        this.payload = b.payload;
        this.parentId = b.parentId;
        this.properties = b.properties$set ? b.properties$value : Event.$default$properties();
        this.environments = b.environments$set ? b.environments$value : Event.$default$environments();
        this.createdAt = b.createdAt;
        this.updatedAt = b.updatedAt;
    }

    @Generated
    public static EventBuilder<?, ?> builder() {
        return new EventBuilderImpl();
    }

    @Generated
    public EventBuilder<?, ?> toBuilder() {
        return new EventBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public EventType getType() {
        return this.type;
    }

    @Generated
    public String getPayload() {
        return this.payload;
    }

    @Generated
    public String getParentId() {
        return this.parentId;
    }

    @Generated
    public EnumMap<EventProperties, String> getProperties() {
        return this.properties;
    }

    @Generated
    public Set<String> getEnvironments() {
        return this.environments;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setType(EventType type) {
        this.type = type;
    }

    @Generated
    public void setPayload(String payload) {
        this.payload = payload;
    }

    @Generated
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Generated
    public void setProperties(EnumMap<EventProperties, String> properties) {
        this.properties = properties;
    }

    @Generated
    public void setEnvironments(Set<String> environments) {
        this.environments = environments;
    }

    @Generated
    public void setCreatedAt(ZonedDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(ZonedDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        EventType this$type = this.getType();
        EventType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$payload = this.getPayload();
        String other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        EnumMap<EventProperties, String> this$properties = this.getProperties();
        EnumMap<EventProperties, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        Set<String> this$environments = this.getEnvironments();
        Set<String> other$environments = other.getEnvironments();
        if (this$environments == null ? other$environments != null : !((Object)this$environments).equals(other$environments)) {
            return false;
        }
        ZonedDateTime this$createdAt = this.getCreatedAt();
        ZonedDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        ZonedDateTime this$updatedAt = this.getUpdatedAt();
        ZonedDateTime other$updatedAt = other.getUpdatedAt();
        return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        EventType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        EnumMap<EventProperties, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        Set<String> $environments = this.getEnvironments();
        result = result * 59 + ($environments == null ? 43 : ((Object)$environments).hashCode());
        ZonedDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        ZonedDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Event(id=" + this.getId() + ", type=" + String.valueOf(this.getType()) + ", payload=" + this.getPayload() + ", parentId=" + this.getParentId() + ", properties=" + String.valueOf(this.getProperties()) + ", environments=" + String.valueOf(this.getEnvironments()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ")";
    }

    @Generated
    public Event() {
        this.properties = Event.$default$properties();
        this.environments = Event.$default$environments();
    }

    @Generated
    public Event(String id, EventType type, String payload, String parentId, EnumMap<EventProperties, String> properties, Set<String> environments, ZonedDateTime createdAt, ZonedDateTime updatedAt) {
        this.id = id;
        this.type = type;
        this.payload = payload;
        this.parentId = parentId;
        this.properties = properties;
        this.environments = environments;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public static enum EventProperties {
        ID("id"),
        API_DEFINITION_VERSION("definition_version"),
        API_ID("api_id"),
        DICTIONARY_ID("dictionary_id"),
        ORIGIN("origin"),
        USER("user"),
        DEPLOYMENT_LABEL("deployment_label"),
        DEPLOYMENT_NUMBER("deployment_number"),
        ORGANIZATION_ID("organization_id"),
        API_DEBUG_STATUS("api_debug_status"),
        GATEWAY_ID("gateway_id"),
        ENVIRONMENTS_HRIDS_PROPERTY("environments_hrids"),
        ORGANIZATIONS_HRIDS_PROPERTY("organizations_hrids"),
        SHARED_POLICY_GROUP_ID("shared_policy_group_id");

        private static final Map<String, EventProperties> LABELS_MAP;
        private final String label;

        public static EventProperties fromLabel(String label) {
            if (label != null) {
                return LABELS_MAP.get(label);
            }
            return null;
        }

        @Generated
        private EventProperties(String label) {
            this.label = label;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        static {
            LABELS_MAP = Arrays.stream(EventProperties.values()).collect(Collectors.toMap(entry -> entry.label, Function.identity()));
        }
    }

    @Generated
    public static abstract class EventBuilder<C extends Event, B extends EventBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private EventType type;
        @Generated
        private String payload;
        @Generated
        private String parentId;
        @Generated
        private boolean properties$set;
        @Generated
        private EnumMap<EventProperties, String> properties$value;
        @Generated
        private boolean environments$set;
        @Generated
        private Set<String> environments$value;
        @Generated
        private ZonedDateTime createdAt;
        @Generated
        private ZonedDateTime updatedAt;

        @Generated
        protected B $fillValuesFrom(C instance) {
            EventBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Event instance, EventBuilder<?, ?> b) {
            b.id(instance.id);
            b.type(instance.type);
            b.payload(instance.payload);
            b.parentId(instance.parentId);
            b.properties(instance.properties);
            b.environments(instance.environments);
            b.createdAt(instance.createdAt);
            b.updatedAt(instance.updatedAt);
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B type(EventType type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B payload(String payload) {
            this.payload = payload;
            return this.self();
        }

        @Generated
        public B parentId(String parentId) {
            this.parentId = parentId;
            return this.self();
        }

        @Generated
        public B properties(EnumMap<EventProperties, String> properties) {
            this.properties$value = properties;
            this.properties$set = true;
            return this.self();
        }

        @Generated
        public B environments(Set<String> environments) {
            this.environments$value = environments;
            this.environments$set = true;
            return this.self();
        }

        @Generated
        public B createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        @Generated
        public B updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Event.EventBuilder(id=" + this.id + ", type=" + String.valueOf(this.type) + ", payload=" + this.payload + ", parentId=" + this.parentId + ", properties$value=" + String.valueOf(this.properties$value) + ", environments$value=" + String.valueOf(this.environments$value) + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ")";
        }
    }

    @Generated
    private static final class EventBuilderImpl
    extends EventBuilder<Event, EventBuilderImpl> {
        @Generated
        private EventBuilderImpl() {
        }

        @Override
        @Generated
        protected EventBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Event build() {
            return new Event(this);
        }
    }
}

