/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ImportDefinitionCreateDomainService;
import io.gravitee.apim.core.api.model.ApiWithFlows;
import io.gravitee.apim.core.api.model.import_definition.ApiExport;
import io.gravitee.apim.core.api.model.import_definition.ImportDefinition;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.service.exceptions.ApiAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.ApiDefinitionVersionNotSupportedException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class ImportApiDefinitionUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportApiDefinitionUseCase.class);
    private final ApiCrudService apiCrudService;
    private final ImportDefinitionCreateDomainService importDefinitionCreateDomainService;

    public ImportApiDefinitionUseCase(ApiCrudService apiCrudService, ImportDefinitionCreateDomainService importDefinitionCreateDomainService) {
        this.apiCrudService = apiCrudService;
        this.importDefinitionCreateDomainService = importDefinitionCreateDomainService;
    }

    public Output execute(Input input) {
        this.ensureIsV4Api(input.importDefinition().getApiExport());
        this.ensureApiDoesNotExist(input);
        ApiWithFlows createdApi = this.importDefinitionCreateDomainService.create(input.auditInfo, input.importDefinition);
        return new Output(createdApi);
    }

    private void ensureApiDoesNotExist(Input input) {
        String apiId = input.importDefinition().getApiExport().getId();
        if (apiId != null && this.apiCrudService.existsById(apiId)) {
            throw new ApiAlreadyExistsException(apiId);
        }
    }

    private void ensureIsV4Api(ApiExport api) {
        if (api.getDefinitionVersion() != DefinitionVersion.V4) {
            throw new ApiDefinitionVersionNotSupportedException(api.getDefinitionVersion().getLabel());
        }
    }

    public record Input(ImportDefinition importDefinition, AuditInfo auditInfo) {
    }

    public record Output(ApiWithFlows apiWithFlows) {
    }
}

