/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.access_point.model;

import lombok.Generated;

public class AccessPoint {
    private String id;
    private ReferenceType referenceType;
    private String referenceId;
    private Target target;
    private String host;
    private boolean secured;
    private boolean overriding;

    public String buildInstallationAccess() {
        StringBuilder consoleUrl = new StringBuilder();
        if (this.secured) {
            consoleUrl.append("https");
        } else {
            consoleUrl.append("http");
        }
        consoleUrl.append("://").append(this.host);
        return consoleUrl.toString();
    }

    @Generated
    public static AccessPointBuilder builder() {
        return new AccessPointBuilder();
    }

    @Generated
    public AccessPointBuilder toBuilder() {
        return new AccessPointBuilder().id(this.id).referenceType(this.referenceType).referenceId(this.referenceId).target(this.target).host(this.host).secured(this.secured).overriding(this.overriding);
    }

    @Generated
    public AccessPoint() {
    }

    @Generated
    public AccessPoint(String id, ReferenceType referenceType, String referenceId, Target target, String host, boolean secured, boolean overriding) {
        this.id = id;
        this.referenceType = referenceType;
        this.referenceId = referenceId;
        this.target = target;
        this.host = host;
        this.secured = secured;
        this.overriding = overriding;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    @Generated
    public String getReferenceId() {
        return this.referenceId;
    }

    @Generated
    public Target getTarget() {
        return this.target;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public boolean isSecured() {
        return this.secured;
    }

    @Generated
    public boolean isOverriding() {
        return this.overriding;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setReferenceType(ReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    @Generated
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Generated
    public void setTarget(Target target) {
        this.target = target;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    @Generated
    public void setOverriding(boolean overriding) {
        this.overriding = overriding;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessPoint)) {
            return false;
        }
        AccessPoint other = (AccessPoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSecured() != other.isSecured()) {
            return false;
        }
        if (this.isOverriding() != other.isOverriding()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ReferenceType this$referenceType = this.getReferenceType();
        ReferenceType other$referenceType = other.getReferenceType();
        if (this$referenceType == null ? other$referenceType != null : !((Object)((Object)this$referenceType)).equals((Object)other$referenceType)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        Target this$target = this.getTarget();
        Target other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)((Object)this$target)).equals((Object)other$target)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccessPoint;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSecured() ? 79 : 97);
        result = result * 59 + (this.isOverriding() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ReferenceType $referenceType = this.getReferenceType();
        result = result * 59 + ($referenceType == null ? 43 : ((Object)((Object)$referenceType)).hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        Target $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)((Object)$target)).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AccessPoint(id=" + this.getId() + ", referenceType=" + String.valueOf((Object)this.getReferenceType()) + ", referenceId=" + this.getReferenceId() + ", target=" + String.valueOf((Object)this.getTarget()) + ", host=" + this.getHost() + ", secured=" + this.isSecured() + ", overriding=" + this.isOverriding() + ")";
    }

    @Generated
    public static class AccessPointBuilder {
        @Generated
        private String id;
        @Generated
        private ReferenceType referenceType;
        @Generated
        private String referenceId;
        @Generated
        private Target target;
        @Generated
        private String host;
        @Generated
        private boolean secured;
        @Generated
        private boolean overriding;

        @Generated
        AccessPointBuilder() {
        }

        @Generated
        public AccessPointBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public AccessPointBuilder referenceType(ReferenceType referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @Generated
        public AccessPointBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @Generated
        public AccessPointBuilder target(Target target) {
            this.target = target;
            return this;
        }

        @Generated
        public AccessPointBuilder host(String host) {
            this.host = host;
            return this;
        }

        @Generated
        public AccessPointBuilder secured(boolean secured) {
            this.secured = secured;
            return this;
        }

        @Generated
        public AccessPointBuilder overriding(boolean overriding) {
            this.overriding = overriding;
            return this;
        }

        @Generated
        public AccessPoint build() {
            return new AccessPoint(this.id, this.referenceType, this.referenceId, this.target, this.host, this.secured, this.overriding);
        }

        @Generated
        public String toString() {
            return "AccessPoint.AccessPointBuilder(id=" + this.id + ", referenceType=" + String.valueOf((Object)this.referenceType) + ", referenceId=" + this.referenceId + ", target=" + String.valueOf((Object)this.target) + ", host=" + this.host + ", secured=" + this.secured + ", overriding=" + this.overriding + ")";
        }
    }

    public static enum ReferenceType {
        ENVIRONMENT,
        ORGANIZATION;

    }

    public static enum Target {
        CONSOLE,
        CONSOLE_API,
        PORTAL,
        PORTAL_API,
        GATEWAY,
        TCP_GATEWAY,
        KAFKA_GATEWAY;

    }
}

