/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.Collections;
import java.util.Map;

public class InvalidFetchCronExpressionException
extends AbstractManagementException {
    private final String fetchCron;

    public InvalidFetchCronExpressionException(String fetchCron, IllegalArgumentException e) {
        super(e);
        this.fetchCron = fetchCron;
    }

    public InvalidFetchCronExpressionException(String message, Throwable cause) {
        super(message, cause);
        this.fetchCron = null;
    }

    public InvalidFetchCronExpressionException(String message) {
        super(message);
        this.fetchCron = null;
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getMessage() {
        return "The fetch cron expression is invalid: " + this.fetchCron;
    }

    @Override
    public String getTechnicalCode() {
        return "fetch.cron.invalid";
    }

    @Override
    public Map<String, String> getParameters() {
        return this.fetchCron != null ? Collections.singletonMap("fetchCron", this.fetchCron) : Collections.emptyMap();
    }
}

