/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Functions;
import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.api.model.crd.PageCRD;
import io.gravitee.apim.core.api.model.crd.PlanCRD;
import io.gravitee.apim.core.member.model.crd.MemberCRD;
import io.gravitee.definition.jackson.datatype.GraviteeMapper;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageSourceEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.ExportApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.nativeapi.NativeApiEntity;
import io.gravitee.rest.api.model.v4.nativeapi.NativePlanEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mapper
public interface ApiCRDAdapter {
    public static final ApiCRDAdapter INSTANCE = (ApiCRDAdapter)Mappers.getMapper(ApiCRDAdapter.class);
    public static final Logger logger = LoggerFactory.getLogger(ApiCRDAdapter.class);

    @Mappings(value={@Mapping(target="version", source="apiEntity.apiVersion"), @Mapping(target="metadata", source="exportEntity.metadata"), @Mapping(target="definitionContext", ignore=true), @Mapping(target="plans", expression="java(mapPlans(exportEntity))"), @Mapping(target="pages", expression="java(mapPages(exportEntity))"), @Mapping(target="members", expression="java(mapMembers(exportEntity))"), @Mapping(target="notifyMembers", expression="java(!exportEntity.getApiEntity().isDisableMembershipNotifications())")})
    public ApiCRDSpec toCRDSpec(ExportApiEntity var1, ApiEntity var2);

    @Mappings(value={@Mapping(target="version", source="apiEntity.apiVersion"), @Mapping(target="metadata", source="exportEntity.metadata"), @Mapping(target="definitionContext", ignore=true), @Mapping(target="plans", expression="java(mapPlans(exportEntity))"), @Mapping(target="pages", expression="java(mapPages(exportEntity))"), @Mapping(target="members", expression="java(mapMembers(exportEntity))"), @Mapping(target="notifyMembers", expression="java(!exportEntity.getApiEntity().isDisableMembershipNotifications())")})
    public ApiCRDSpec toCRDSpec(ExportApiEntity var1, NativeApiEntity var2);

    default public ApiCRDSpec toCRDSpec(ExportApiEntity exportEntity, GenericApiEntity apiEntity) {
        if (apiEntity instanceof ApiEntity) {
            return this.toCRDSpec(exportEntity, (ApiEntity)apiEntity);
        }
        if (apiEntity instanceof NativeApiEntity) {
            return this.toCRDSpec(exportEntity, (NativeApiEntity)apiEntity);
        }
        return null;
    }

    public PlanCRD toCRDPlan(PlanEntity var1);

    public PlanCRD toCRDPlan(NativePlanEntity var1);

    default public PlanCRD toCRDPlan(GenericPlanEntity genericPlanEntity) {
        if (genericPlanEntity instanceof PlanEntity) {
            PlanEntity planEntity = (PlanEntity)genericPlanEntity;
            return this.toCRDPlan(planEntity);
        }
        if (genericPlanEntity instanceof NativePlanEntity) {
            NativePlanEntity nativePlanEntity = (NativePlanEntity)genericPlanEntity;
            return this.toCRDPlan(nativePlanEntity);
        }
        return null;
    }

    default public Map<String, PlanCRD> mapPlans(ExportApiEntity definition) {
        HashMap<String, PlanCRD> plansMap = new HashMap<String, PlanCRD>();
        List<GenericPlanEntity> nonClosedPlans = definition.getPlans().stream().filter(plan -> !plan.isClosed()).toList();
        for (GenericPlanEntity plan2 : nonClosedPlans) {
            String key = plansMap.containsKey(plan2.getName()) ? ApiCRDAdapter.randomize(plan2.getName()) : plan2.getName();
            plansMap.put(key, this.toCRDPlan(plan2));
        }
        return plansMap;
    }

    @Mapping(target="source.configurationMap", source="source.configuration", qualifiedByName={"deserializeConfig"})
    public PageCRD toCRDPage(PageEntity var1);

    default public Map<String, PageCRD> mapPages(ExportApiEntity definition) {
        return definition.getPages() != null ? definition.getPages().stream().map(this::clearAutoFetchedContent).filter(Objects::nonNull).map(this::toCRDPage).collect(Collectors.toMap(this::pageKey, Functions.identity())) : null;
    }

    private PageEntity clearAutoFetchedContent(PageEntity page) {
        boolean isAutoFetch;
        PageSourceEntity source = page.getSource();
        if (source == null) {
            return page;
        }
        String pageType = source.getType();
        boolean isMarkdownOrSwagger = PageType.SWAGGER.name().equals(page.getType()) || PageType.MARKDOWN.name().equals(page.getType());
        boolean bl = isAutoFetch = "github-fetcher".equals(pageType) || "gitlab-fetcher".equals(pageType) || "git-fetcher".equals(pageType) || "http-fetcher".equals(pageType) || "bitbucket-fetcher".equals(pageType);
        if (isMarkdownOrSwagger && isAutoFetch) {
            if (page.getMetadata() != null && "auto_fetched".equals(page.getMetadata().get("graviteeio/fetcher_type"))) {
                return null;
            }
            page.setContent(null);
            page.setMetadata(null);
        } else if (PageType.FOLDER.name().equals(page.getType()) && isAutoFetch) {
            return null;
        }
        return page;
    }

    default public String pageKey(PageCRD page) {
        return page.getName() == null ? page.getId() : page.getName();
    }

    default public Set<MemberCRD> mapMembers(ExportApiEntity definition) {
        return definition.getMembers() != null ? definition.getMembers().stream().map(me -> new MemberCRD(me.getId(), null, null, ((RoleEntity)me.getRoles().get(0)).getName())).collect(Collectors.toSet()) : null;
    }

    @Named(value="deserializeConfig")
    default public Map<String, Object> deserializeConfig(String configuration) {
        if (Objects.isNull(configuration)) {
            return Map.of();
        }
        GraviteeMapper mapper = new GraviteeMapper();
        try {
            return (Map)mapper.readValue(configuration, LinkedHashMap.class);
        }
        catch (JsonProcessingException jse) {
            logger.debug("Cannot parse configuration as LinkedHashMap: " + configuration);
            return Map.of();
        }
    }

    private static String randomize(String strToRandomize) {
        return strToRandomize + "-" + RandomStringUtils.randomNumeric((int)8);
    }
}

