/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.definition.model.Origin;
import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.node.api.upgrader.UpgraderException;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.PortalNotificationConfigRepository;
import io.gravitee.repository.management.model.PortalNotificationConfig;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PortalNotificationConfigOriginUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PortalNotificationConfigOriginUpgrader.class);
    EnvironmentRepository environmentRepository;
    PortalNotificationConfigRepository portalNotificationConfigRepository;

    public PortalNotificationConfigOriginUpgrader(@Lazy PortalNotificationConfigRepository portalNotificationConfigRepository) {
        this.portalNotificationConfigRepository = portalNotificationConfigRepository;
    }

    public boolean upgrade() throws UpgraderException {
        return this.wrapException(this::applyUpgrade);
    }

    private boolean applyUpgrade() throws TechnicalException {
        List<PortalNotificationConfig> portalNotificationConfigs = this.portalNotificationConfigRepository.findAll().stream().filter(portalNotificationConfig -> portalNotificationConfig.getOrigin() == null).map(portalNotificationConfig -> {
            portalNotificationConfig.setOrigin(Origin.MANAGEMENT);
            try {
                this.portalNotificationConfigRepository.update(portalNotificationConfig);
            }
            catch (TechnicalException e) {
                throw new TechnicalManagementException(e);
            }
            return portalNotificationConfig;
        }).toList();
        log.info("Migrating portalNotificationConfig: {} with origin set", (Object)portalNotificationConfigs.size());
        return true;
    }

    public int getOrder() {
        return 190;
    }
}

