/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.event.Event;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.definition.model.command.SubscriptionFailureNotificationCommand;
import io.gravitee.rest.api.model.command.CommandEntity;
import io.gravitee.rest.api.model.command.CommandTags;
import io.gravitee.rest.api.service.SubscriptionCommandListener;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.event.CommandEvent;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SubscriptionFailureNotificationCommandListenerImpl
implements SubscriptionCommandListener {
    public static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionFailureNotificationCommandListenerImpl.class);
    private final SubscriptionService subscriptionService;
    private final ObjectMapper objectMapper;

    public SubscriptionFailureNotificationCommandListenerImpl(EventManager eventManager, SubscriptionService subscriptionService, ObjectMapper objectMapper) {
        this.subscriptionService = subscriptionService;
        this.objectMapper = objectMapper;
        eventManager.subscribeForEvents((EventListener)this, CommandEvent.class);
    }

    public void onEvent(Event<CommandEvent, CommandEntity> event) {
        if (CommandEvent.TO_PROCESS.equals(event.type()) && event.content() != null && ((CommandEntity)event.content()).getTags().contains(CommandTags.SUBSCRIPTION_FAILURE_NOTIFICATION_RETRY)) {
            LOGGER.debug("Command event: {}", (Object)((CommandEntity)event.content()).getContent());
            this.getSubscriptionCommand(event).ifPresent(command -> this.subscriptionService.notifyError(command.getSubscriptionId(), command.getFailureCause()));
        }
    }

    private Optional<SubscriptionFailureNotificationCommand> getSubscriptionCommand(Event<CommandEvent, CommandEntity> event) {
        try {
            if (((CommandEntity)event.content()).getContent() == null) {
                return Optional.empty();
            }
            return Optional.of((SubscriptionFailureNotificationCommand)this.objectMapper.readValue(((CommandEntity)event.content()).getContent(), SubscriptionFailureNotificationCommand.class));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error processing SubscriptionCommand", (Throwable)e);
            return Optional.empty();
        }
    }
}

