/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.common;

import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public class TimeBoundedCharSequence
implements CharSequence {
    private final CharSequence charSequence;
    private final long timeThreshold;

    public TimeBoundedCharSequence(CharSequence charSequence, Duration timeoutDuration) {
        this.charSequence = charSequence;
        this.timeThreshold = System.currentTimeMillis() + timeoutDuration.toMillis();
    }

    @Override
    public int length() {
        return this.charSequence.length();
    }

    @Override
    public char charAt(int index) {
        if (System.currentTimeMillis() > this.timeThreshold) {
            throw new IllegalStateException("Timeout has expired for exploring char sequence");
        }
        return this.charSequence.charAt(index);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return new TimeBoundedCharSequence(this.charSequence.subSequence(start, end), Duration.ofMillis(this.timeThreshold - System.currentTimeMillis()));
    }

    @Override
    public String toString() {
        return this.charSequence.toString();
    }
}

