/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import com.fasterxml.jackson.core.type.TypeReference;
import io.gravitee.apim.core.api.model.crd.PlanCRD;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.infra.adapter.GraviteeJacksonMapper;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.federation.FederatedPlan;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.nativeapi.NativePlan;
import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.rest.api.model.v4.nativeapi.NativePlanEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.model.v4.plan.NewPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanSecurityType;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mapper
public interface PlanAdapter {
    public static final Logger LOGGER = LoggerFactory.getLogger(PlanAdapter.class);
    public static final PlanAdapter INSTANCE = (PlanAdapter)Mappers.getMapper(PlanAdapter.class);

    @Mappings(value={@Mapping(source="api", target="apiId"), @Mapping(target="definitionVersion", defaultValue="V2"), @Mapping(target="planDefinitionHttpV4", expression="java(deserializeDefinitionHttpV4(plan))"), @Mapping(target="planDefinitionNativeV4", expression="java(deserializeDefinitionNativeV4(plan))"), @Mapping(target="planDefinitionV2", expression="java(deserializeDefinitionV2(plan))"), @Mapping(target="federatedPlanDefinition", expression="java(deserializeDefinitionFederated(plan))")})
    public Plan fromRepository(io.gravitee.repository.management.model.Plan var1);

    @Mappings(value={@Mapping(source="apiId", target="api"), @Mapping(target="security", source="planSecurity", qualifiedByName={"computeRepositorySecurityType"}), @Mapping(target="securityDefinition", source="planSecurity.configuration"), @Mapping(target="definition", expression="java(serializeDefinition(source))"), @Mapping(target="mode", source="planMode"), @Mapping(target="selectionRule", expression="java(serializeSelectionRule(source))"), @Mapping(target="status", source="planStatus"), @Mapping(target="tags", expression="java(serializeTags(source))")})
    public io.gravitee.repository.management.model.Plan toRepository(Plan var1);

    @Mappings(value={@Mapping(target="status", source="planStatus"), @Mapping(target="security", source="planSecurity"), @Mapping(target="mode", source="planMode")})
    public PlanEntity toEntityV4(Plan var1);

    @Mappings(value={@Mapping(target="status", source="planStatus"), @Mapping(target="security", source="planSecurity"), @Mapping(target="mode", source="planMode")})
    public NativePlanEntity toNativePlanEntityV4(Plan var1);

    @Mappings(value={@Mapping(target="api", source="apiId"), @Mapping(target="status", source="planStatus"), @Mapping(target="security", source="planSecurity", conditionQualifiedByName={"mapPlanSecurityTypeV2"}), @Mapping(target="securityDefinition", source="planSecurity.configuration")})
    public io.gravitee.rest.api.model.PlanEntity toEntityV2(Plan var1);

    public NewPlanEntity entityToNewPlanEntity(PlanEntity var1);

    @Mappings(value={@Mapping(target="security", source="planSecurity"), @Mapping(target="mode", source="planMode"), @Mapping(target="selectionRule", expression="java(serializeSelectionRule(source))"), @Mapping(target="status", source="planStatus"), @Mapping(target="tags", expression="java(serializeTags(source))")})
    public PlanCRD toCRD(Plan var1);

    public PlanEntity toEntityV4(PlanCRD var1);

    public io.gravitee.definition.model.v4.plan.Plan toApiDefinition(PlanCRD var1);

    @Mapping(target="security", expression="java(computeBasePlanEntitySecurityV4(source))")
    public io.gravitee.definition.model.v4.plan.Plan toPlanDefinitionHttpV4(io.gravitee.repository.management.model.Plan var1);

    @Mapping(target="security", expression="java(computeBasePlanEntitySecurityV4(source))")
    public NativePlan toPlanDefinitionNativeV4(io.gravitee.repository.management.model.Plan var1);

    @Mappings(value={@Mapping(target="paths", expression="java(computeBasePlanEntityPaths(source))"), @Mapping(target="security", qualifiedByName={"serializeV2PlanSecurityType"})})
    public io.gravitee.definition.model.Plan toPlanDefinitionV2(io.gravitee.repository.management.model.Plan var1);

    default public io.gravitee.definition.model.v4.plan.Plan deserializeDefinitionHttpV4(io.gravitee.repository.management.model.Plan source) {
        if (source.getDefinitionVersion() != DefinitionVersion.V4 || source.getApiType() == ApiType.NATIVE) {
            return null;
        }
        return this.toPlanDefinitionHttpV4(source);
    }

    default public NativePlan deserializeDefinitionNativeV4(io.gravitee.repository.management.model.Plan source) {
        if (source.getDefinitionVersion() != DefinitionVersion.V4 || source.getApiType() != ApiType.NATIVE) {
            return null;
        }
        return this.toPlanDefinitionNativeV4(source);
    }

    default public io.gravitee.definition.model.Plan deserializeDefinitionV2(io.gravitee.repository.management.model.Plan source) {
        if (source.getDefinitionVersion() != null) {
            return null;
        }
        return this.toPlanDefinitionV2(source);
    }

    default public FederatedPlan deserializeDefinitionFederated(io.gravitee.repository.management.model.Plan source) {
        if (source.getDefinitionVersion() != DefinitionVersion.FEDERATED) {
            return null;
        }
        try {
            return (FederatedPlan)GraviteeJacksonMapper.getInstance().readValue(source.getDefinition(), FederatedPlan.class);
        }
        catch (IOException ioe) {
            LOGGER.error("Unexpected error while deserializing Federated Plan definition", (Throwable)ioe);
            return null;
        }
    }

    default public Map<String, io.gravitee.definition.model.v4.plan.Plan> toApiDefinition(Map<String, PlanCRD> source) {
        return source.values().stream().map((? super T planCRD) -> Map.entry(planCRD.getId(), INSTANCE.toApiDefinition((PlanCRD)planCRD))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    default public Set<PlanEntity> toPlanEntityV4(Map<String, PlanCRD> source) {
        return source.values().stream().map(INSTANCE::toEntityV4).collect(Collectors.toSet());
    }

    @Named(value="computeBasePlanEntityMode")
    default public PlanMode computeBasePlanEntityMode(io.gravitee.repository.management.model.Plan plan) {
        return plan.getMode() != null ? PlanMode.valueOf((String)plan.getMode().name()) : PlanMode.STANDARD;
    }

    @Named(value="computeBasePlanEntityStatusV4")
    default public PlanStatus computeBasePlanEntityStatusV4(io.gravitee.repository.management.model.Plan plan) {
        return plan.getStatus() != null ? PlanStatus.valueOf((String)plan.getStatus().name()) : PlanStatus.PUBLISHED;
    }

    @Named(value="computeBasePlanEntityStatusV2")
    default public io.gravitee.rest.api.model.PlanStatus computeBasePlanEntityStatusV2(io.gravitee.repository.management.model.Plan plan) {
        return plan.getStatus() != null ? io.gravitee.rest.api.model.PlanStatus.valueOf((String)plan.getStatus().name()) : io.gravitee.rest.api.model.PlanStatus.PUBLISHED;
    }

    @Named(value="computeBasePlanEntitySecurityV4")
    default public PlanSecurity computeBasePlanEntitySecurityV4(io.gravitee.repository.management.model.Plan plan) {
        if (Plan.PlanMode.PUSH != plan.getMode()) {
            return PlanSecurity.builder().type(PlanSecurityType.valueOf((String)plan.getSecurity().name()).getLabel()).configuration(plan.getSecurityDefinition()).build();
        }
        return null;
    }

    default public io.gravitee.rest.api.model.PlanSecurityType mapPlanSecurityTypeV2(PlanSecurity planSecurity) {
        return planSecurity != null ? io.gravitee.rest.api.model.PlanSecurityType.valueOf((String)PlanSecurityType.valueOfLabel((String)planSecurity.getType()).name()) : io.gravitee.rest.api.model.PlanSecurityType.API_KEY;
    }

    default public PlanSecurityType mapPlanSecurityTypeV4(PlanSecurity planSecurity) {
        return planSecurity != null ? PlanSecurityType.valueOfLabel((String)planSecurity.getType()) : null;
    }

    @Named(value="computeBasePlanEntityPaths")
    default public Map<String, List<Rule>> computeBasePlanEntityPaths(io.gravitee.repository.management.model.Plan plan) {
        if (plan.getDefinition() != null && !plan.getDefinition().isEmpty()) {
            try {
                return (Map)GraviteeJacksonMapper.getInstance().readValue(plan.getDefinition(), (TypeReference)new TypeReference<Map<String, List<Rule>>>(this){});
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while generating policy definition", (Throwable)ioe);
                return null;
            }
        }
        return null;
    }

    default public String serializeDefinition(Plan source) {
        return switch (source.getDefinitionVersion()) {
            case DefinitionVersion.V4 -> null;
            case DefinitionVersion.FEDERATED -> this.serializeFederatedPlan(source.getFederatedPlanDefinition());
            default -> this.serializeV2PlanPaths(source.getPlanDefinitionV2());
        };
    }

    default public String serializeFederatedPlan(FederatedPlan source) {
        try {
            return GraviteeJacksonMapper.getInstance().writeValueAsString((Object)source);
        }
        catch (IOException ioe) {
            LOGGER.error("Unexpected error while serializing federated plan definition", (Throwable)ioe);
            return null;
        }
    }

    default public String serializeV2PlanPaths(io.gravitee.definition.model.Plan plan) {
        if (plan != null && plan.getPaths() != null && !plan.getPaths().isEmpty()) {
            try {
                return GraviteeJacksonMapper.getInstance().writeValueAsString((Object)plan.getPaths());
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while serializing v2 plan paths", (Throwable)ioe);
                return null;
            }
        }
        return null;
    }

    @Named(value="serializeV2PlanSecurityType")
    default public String serializeV2PlanSecurityType(Plan.PlanSecurityType planSecurityType) {
        if (planSecurityType != null) {
            return PlanSecurityType.valueOfLabel((String)planSecurityType.name()).name();
        }
        return null;
    }

    @Named(value="serializeSelectionRule")
    default public String serializeSelectionRule(Plan source) {
        return switch (source.getDefinitionVersion()) {
            default -> throw new MatchException(null, null);
            case DefinitionVersion.V4 -> source.getPlanDefinitionV4().getSelectionRule();
            case DefinitionVersion.V1, DefinitionVersion.V2 -> source.getPlanDefinitionV2().getSelectionRule();
            case DefinitionVersion.FEDERATED, DefinitionVersion.FEDERATED_AGENT -> null;
        };
    }

    @Named(value="serializeTags")
    default public Set<String> serializeTags(Plan source) {
        return switch (source.getDefinitionVersion()) {
            default -> throw new MatchException(null, null);
            case DefinitionVersion.V4 -> source.getPlanDefinitionV4().getTags();
            case DefinitionVersion.V1, DefinitionVersion.V2 -> source.getPlanDefinitionV2().getTags();
            case DefinitionVersion.FEDERATED, DefinitionVersion.FEDERATED_AGENT -> null;
        };
    }

    @Named(value="computeRepositorySecurityType")
    default public Plan.PlanSecurityType computeRepositorySecurityType(PlanSecurity planSecurity) {
        if (planSecurity != null) {
            PlanSecurityType planSecurityType = PlanSecurityType.valueOfLabel((String)planSecurity.getType());
            return Plan.PlanSecurityType.valueOf((String)planSecurityType.name());
        }
        return null;
    }

    default public io.gravitee.rest.api.model.PlanEntity map(GenericPlanEntity entity) {
        GenericPlanEntity genericPlanEntity = entity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{io.gravitee.rest.api.model.PlanEntity.class, PlanEntity.class, NativePlanEntity.class}, (Object)genericPlanEntity, n)) {
            case 0 -> {
                io.gravitee.rest.api.model.PlanEntity p;
                yield p = (io.gravitee.rest.api.model.PlanEntity)genericPlanEntity;
            }
            case 1 -> {
                PlanEntity v4 = (PlanEntity)genericPlanEntity;
                yield this.map(v4);
            }
            case 2 -> {
                NativePlanEntity nativePlan = (NativePlanEntity)genericPlanEntity;
                yield this.map(nativePlan);
            }
            default -> null;
        };
    }

    public io.gravitee.rest.api.model.PlanEntity map(PlanEntity var1);

    public io.gravitee.rest.api.model.PlanEntity map(NativePlanEntity var1);
}

