/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene.searcher;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.ReferenceContext;
import io.gravitee.rest.api.service.impl.search.SearchResult;
import io.gravitee.rest.api.service.impl.search.lucene.searcher.AbstractDocumentSearcher;
import io.gravitee.rest.api.service.search.query.Query;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ApiDocumentSearcher
extends AbstractDocumentSearcher {
    public static final String FIELD_API_TYPE_VALUE = "api";
    private static final Map<String, Float> API_FIELD_BOOST = Map.ofEntries(Map.entry("name", Float.valueOf(20.0f)), Map.entry("name_lowercase", Float.valueOf(20.0f)), Map.entry("name_split", Float.valueOf(18.0f)), Map.entry("paths", Float.valueOf(10.0f)), Map.entry("paths_lowercase", Float.valueOf(10.0f)), Map.entry("hosts", Float.valueOf(10.0f)), Map.entry("hosts_lowercase", Float.valueOf(10.0f)), Map.entry("labels", Float.valueOf(8.0f)), Map.entry("description", Float.valueOf(5.0f)), Map.entry("metadata", Float.valueOf(4.0f)), Map.entry("tags", Float.valueOf(1.0f)));
    private static final String[] API_FIELD_SEARCH = new String[]{"id", "name", "name_sorted", "name_lowercase", "name_split", "description", "description_lowercase", "description_split", "ownerName", "ownerName_lowercase", "labels", "labels_split", "tags", "tags_split", "categories", "categories_split", "paths", "paths_lowercase", "paths_split", "hosts", "hosts_lowercase", "hosts_split", "metadata", "metadata_split"};
    private static final String[] AUTHORIZED_EXPLICIT_FILTER = new String[]{"name", "ownerName", "labels", "categories", "description", "paths", "tags", "origin", "has_health_check", "definition_version"};

    public ApiDocumentSearcher(IndexWriter indexWriter) {
        super(indexWriter);
    }

    private BooleanQuery.Builder buildApiQuery(ExecutionContext executionContext, Optional<org.apache.lucene.search.Query> filterQuery) {
        BooleanQuery.Builder apiQuery = new BooleanQuery.Builder().add((org.apache.lucene.search.Query)new TermQuery(new Term("type", FIELD_API_TYPE_VALUE)), BooleanClause.Occur.FILTER);
        if (executionContext.hasEnvironmentId()) {
            apiQuery.add((org.apache.lucene.search.Query)this.buildEnvCriteria(executionContext), BooleanClause.Occur.FILTER);
        }
        filterQuery.ifPresent(q -> apiQuery.add(q, BooleanClause.Occur.FILTER));
        return apiQuery;
    }

    private Optional<BooleanQuery> buildIdsQuery(ExecutionContext executionContext, Query<?> query) {
        if (!StringUtils.isBlank((CharSequence)query.getQuery()) && query.getIds() != null && !query.getIds().isEmpty()) {
            BooleanQuery.Builder mainQuery = new BooleanQuery.Builder();
            query.getIds().forEach(id -> {
                BooleanQuery.Builder idQuery = new BooleanQuery.Builder();
                if (executionContext.hasEnvironmentId()) {
                    idQuery.add((org.apache.lucene.search.Query)this.buildEnvCriteria(executionContext), BooleanClause.Occur.FILTER);
                }
                idQuery.add((org.apache.lucene.search.Query)new TermQuery(new Term("id", id)), BooleanClause.Occur.FILTER);
                mainQuery.add((org.apache.lucene.search.Query)idQuery.build(), BooleanClause.Occur.SHOULD);
            });
            return Optional.of(mainQuery.build());
        }
        return Optional.empty();
    }

    private Optional<BooleanQuery> buildExactMatchQuery(ExecutionContext executionContext, Query<?> query, Optional<org.apache.lucene.search.Query> filterQuery) throws ParseException {
        if (!StringUtils.isBlank((CharSequence)query.getQuery())) {
            BooleanQuery.Builder apiQuery = this.buildApiQuery(executionContext, filterQuery);
            MultiFieldQueryParser apiParser = new MultiFieldQueryParser(API_FIELD_SEARCH, (Analyzer)new KeywordAnalyzer(), API_FIELD_BOOST);
            String queryEscaped = QueryParserBase.escape((String)query.getQuery());
            org.apache.lucene.search.Query queryParsed = apiParser.parse(queryEscaped);
            apiQuery.add(queryParsed, BooleanClause.Occur.MUST);
            return Optional.of(apiQuery.build());
        }
        return Optional.empty();
    }

    private Optional<BooleanQuery> buildWildcardQuery(ExecutionContext executionContext, Query<?> query, Optional<org.apache.lucene.search.Query> baseFilterQuery) throws ParseException {
        if (!StringUtils.isBlank((CharSequence)query.getQuery())) {
            BooleanQuery.Builder mainQuery = this.buildApiQuery(executionContext, baseFilterQuery);
            MultiFieldQueryParser apiParser = new MultiFieldQueryParser(API_FIELD_SEARCH, (Analyzer)new KeywordAnalyzer(), API_FIELD_BOOST);
            apiParser.setAllowLeadingWildcard(true);
            apiParser.setFuzzyMinSim(0.6f);
            String queryEscaped = QueryParserBase.escape((String)query.getQuery());
            org.apache.lucene.search.Query queryParsed = apiParser.parse(queryEscaped);
            mainQuery.add(queryParsed, BooleanClause.Occur.SHOULD);
            mainQuery.add((org.apache.lucene.search.Query)this.buildApiFields(query.getQuery(), new org.apache.lucene.search.Query[0]), BooleanClause.Occur.MUST);
            return Optional.of(mainQuery.build());
        }
        return Optional.empty();
    }

    @Override
    public SearchResult search(ExecutionContext executionContext, Query<?> query) throws TechnicalException {
        BooleanQuery.Builder apiQuery = new BooleanQuery.Builder();
        try {
            Optional<org.apache.lucene.search.Query> baseFilterQuery = this.buildFilterQuery(query.getFilters(), Map.of(FIELD_API_TYPE_VALUE, "id"));
            this.buildExcludedFilters(query.getExcludedFilters()).ifPresent(q -> apiQuery.add((org.apache.lucene.search.Query)q, BooleanClause.Occur.MUST_NOT));
            this.buildExplicitQuery(executionContext, query, baseFilterQuery).ifPresent(q -> apiQuery.add((org.apache.lucene.search.Query)q, BooleanClause.Occur.MUST));
            this.buildExactMatchQuery(executionContext, query, baseFilterQuery).ifPresent(q -> apiQuery.add((org.apache.lucene.search.Query)new BoostQuery((org.apache.lucene.search.Query)q, 4.0f), BooleanClause.Occur.SHOULD));
            this.buildWildcardQuery(executionContext, query, baseFilterQuery).ifPresent(q -> apiQuery.add((org.apache.lucene.search.Query)q, BooleanClause.Occur.SHOULD));
            this.buildIdsQuery(executionContext, query).ifPresent(q -> apiQuery.add((org.apache.lucene.search.Query)q, BooleanClause.Occur.SHOULD));
        }
        catch (ParseException pe) {
            this.logger.error("Invalid query to search for API documents", (Throwable)pe);
            throw new TechnicalException("Invalid query to search for API documents", (Throwable)pe);
        }
        BooleanQuery finalQuery = apiQuery.build();
        try {
            return this.search((org.apache.lucene.search.Query)finalQuery, query.getSort());
        }
        catch (IndexSearcher.TooManyClauses tooManyClauses) {
            int maxClauseCount = this.getClauseCount((org.apache.lucene.search.Query)finalQuery);
            ApiDocumentSearcher.increaseMaxClauseCountIfNecessary(maxClauseCount);
            return this.search((org.apache.lucene.search.Query)finalQuery, query.getSort());
        }
    }

    private int getClauseCount(org.apache.lucene.search.Query query) {
        int result = 0;
        if (query instanceof BooleanQuery) {
            List clauses = ((BooleanQuery)query).clauses();
            result = clauses.size();
            for (BooleanClause clause : clauses) {
                result += this.getClauseCount(clause.query());
            }
        } else if (query instanceof BoostQuery) {
            result += this.getClauseCount(((BoostQuery)query).getQuery());
        }
        return result;
    }

    private Optional<BooleanQuery> buildExcludedFilters(Map<String, Collection<String>> excludedFilters) {
        if (excludedFilters != null && !excludedFilters.isEmpty()) {
            BooleanQuery.Builder excludedFiltersQuery = new BooleanQuery.Builder();
            List<org.apache.lucene.search.Query> excludedQuery = excludedFilters.keySet().stream().filter(key -> !((Collection)excludedFilters.get(key)).isEmpty()).map(key -> {
                Collection values = (Collection)excludedFilters.get(key);
                BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
                values.forEach(value -> booleanQuery.add((org.apache.lucene.search.Query)new TermQuery(new Term(key, (String)value)), BooleanClause.Occur.SHOULD));
                return booleanQuery.build();
            }).collect(Collectors.toList());
            excludedQuery.forEach(query -> excludedFiltersQuery.add(query, BooleanClause.Occur.SHOULD));
            return Optional.of(excludedFiltersQuery.build());
        }
        return Optional.empty();
    }

    private Optional<BooleanQuery> buildExplicitQuery(ExecutionContext executionContext, Query<?> query, Optional<org.apache.lucene.search.Query> baseFilterQuery) {
        BooleanQuery.Builder filtersQuery = this.buildApiQuery(executionContext, baseFilterQuery);
        String rest = this.completeQueryWithFilters(query, filtersQuery);
        if (!rest.equals(query.getQuery())) {
            query.setQuery(rest);
            return Optional.of(filtersQuery.build());
        }
        return Optional.empty();
    }

    protected String completeQueryWithFilters(Query<?> query, BooleanQuery.Builder mainQuery) {
        if (StringUtils.isBlank((CharSequence)query.getQuery())) {
            return "";
        }
        try {
            BooleanQuery.Builder restQuery = new BooleanQuery.Builder();
            Set<String> rest = this.appendExplicitFilters(query.getQuery(), mainQuery, restQuery);
            BooleanQuery build = restQuery.build();
            if (!build.clauses().isEmpty()) {
                mainQuery.add((org.apache.lucene.search.Query)build, ((BooleanClause)build.clauses().getFirst()).occur());
            }
            if (!CollectionUtils.isEmpty(rest)) {
                return String.join((CharSequence)" ", rest);
            }
            return "";
        }
        catch (ParseException e) {
            this.logger.debug("Unable to parse query", (Throwable)e);
            return query.getQuery();
        }
    }

    protected Set<String> appendExplicitFilters(String query, BooleanQuery.Builder mainQuery, BooleanQuery.Builder restQuery) throws ParseException {
        QueryParser parser = new QueryParser("", (Analyzer)new KeywordAnalyzer());
        parser.setAllowLeadingWildcard(true);
        String escapedQuery = query.replace("[", "\\[").replace("]", "\\]");
        if (escapedQuery.startsWith("/")) {
            escapedQuery = QueryParserBase.escape((String)query);
        }
        org.apache.lucene.search.Query parse = parser.parse(escapedQuery);
        if (this.hasExplicitFilter(query)) {
            return this.appendExplicitFilters(parse, mainQuery, restQuery, null);
        }
        return Collections.singleton(query);
    }

    @Nullable
    private Set<String> appendExplicitFilters(org.apache.lucene.search.Query query, BooleanQuery.Builder mainQuery, BooleanQuery.Builder restQuery, BooleanClause clause) {
        BooleanClause.Occur currentOccur;
        HashSet<String> rest = new HashSet<String>();
        BooleanClause.Occur occur = currentOccur = clause != null ? clause.occur() : BooleanClause.Occur.FILTER;
        if (query instanceof TermQuery) {
            this.appendTermFilters((TermQuery)query, mainQuery, restQuery, clause, rest, currentOccur);
        } else if (query instanceof BooleanQuery) {
            if (this.appendBoolFilters((BooleanQuery)query, mainQuery, restQuery, rest)) {
                return null;
            }
        } else if (query instanceof WildcardQuery) {
            this.appendWildcardFilters((WildcardQuery)query, mainQuery, rest, currentOccur);
        }
        return rest;
    }

    private void appendWildcardFilters(WildcardQuery query, BooleanQuery.Builder mainQuery, Set<String> rest, BooleanClause.Occur currentOccur) {
        Term term = query.getTerm();
        if (Arrays.stream(AUTHORIZED_EXPLICIT_FILTER).anyMatch(field -> field.equals(term.field()))) {
            mainQuery.add((org.apache.lucene.search.Query)query, currentOccur);
        } else {
            rest.add(term.text());
        }
    }

    private boolean appendBoolFilters(BooleanQuery query, BooleanQuery.Builder mainQuery, BooleanQuery.Builder restQuery, Set<String> rest) {
        List clauses = query.clauses();
        if (!clauses.isEmpty()) {
            BooleanQuery.Builder subQuery = new BooleanQuery.Builder();
            for (BooleanClause _clause : clauses) {
                org.apache.lucene.search.Query innerQuery = _clause.query();
                Set<String> innerRest = this.appendExplicitFilters(innerQuery, subQuery, restQuery, _clause);
                if (innerRest == null) {
                    return true;
                }
                rest.addAll(innerRest);
            }
            mainQuery.add((org.apache.lucene.search.Query)subQuery.build(), BooleanClause.Occur.FILTER);
        }
        return false;
    }

    private void appendTermFilters(TermQuery query, BooleanQuery.Builder mainQuery, BooleanQuery.Builder restQuery, BooleanClause clause, Set<String> rest, BooleanClause.Occur currentOccur) {
        Term term = query.getTerm();
        if (Arrays.stream(AUTHORIZED_EXPLICIT_FILTER).anyMatch(field -> field.equals(term.field()))) {
            mainQuery.add(this.buildQueryFilter(term), currentOccur);
        } else if (clause != null) {
            restQuery.add((org.apache.lucene.search.Query)this.buildApiFields(term.text(), new org.apache.lucene.search.Query[0]), clause.occur());
        } else {
            rest.add(term.text());
        }
    }

    private org.apache.lucene.search.Query buildQueryFilter(Term term) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        String field = term.field();
        String text = term.text();
        if ("categories".equals(term.field())) {
            text = ApiDocumentSearcher.formatCategoryField(term.text());
        } else if (!("tags".equals(term.field()) || "origin".equals(term.field()) || "has_health_check".equals(term.field()) || "definition_version".equals(term.field()))) {
            text = text.toLowerCase();
            field = field.concat("_lowercase");
        }
        return builder.add((org.apache.lucene.search.Query)new PhraseQuery(field, new String[]{text}), BooleanClause.Occur.SHOULD).add((org.apache.lucene.search.Query)new WildcardQuery(new Term(field, text)), BooleanClause.Occur.SHOULD).build();
    }

    public static String formatCategoryField(String category) {
        return category.toLowerCase().replace(" ", "-");
    }

    private org.apache.lucene.search.Query toWildcard(String field, String query) {
        return new WildcardQuery(new Term(field, "*" + query + "*"));
    }

    private BooleanQuery buildApiFields(String query, org.apache.lucene.search.Query ... queries) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (queries != null) {
            for (org.apache.lucene.search.Query q : queries) {
                builder.add(q, BooleanClause.Occur.SHOULD);
            }
        }
        String[] tokens = query.split(" ");
        builder.add((org.apache.lucene.search.Query)new BoostQuery(this.toWildcard("name", query), 20.0f), BooleanClause.Occur.SHOULD).add((org.apache.lucene.search.Query)new BoostQuery(this.toWildcard("name_lowercase", query.toLowerCase()), 18.0f), BooleanClause.Occur.SHOULD).add((org.apache.lucene.search.Query)new BoostQuery(this.toWildcard("name_sorted", query.toLowerCase()), 15.0f), BooleanClause.Occur.SHOULD);
        for (String token : tokens) {
            builder.add((org.apache.lucene.search.Query)new BoostQuery(this.toWildcard("name", token), 12.0f), BooleanClause.Occur.SHOULD).add((org.apache.lucene.search.Query)new BoostQuery(this.toWildcard("name_lowercase", token.toLowerCase()), 10.0f), BooleanClause.Occur.SHOULD).add((org.apache.lucene.search.Query)new BoostQuery(this.toWildcard("paths", token), 8.0f), BooleanClause.Occur.SHOULD).add((org.apache.lucene.search.Query)new BoostQuery(this.toWildcard("paths_lowercase", token.toLowerCase()), 7.0f), BooleanClause.Occur.SHOULD).add(this.toWildcard("description", token), BooleanClause.Occur.SHOULD).add(this.toWildcard("description_lowercase", token.toLowerCase()), BooleanClause.Occur.SHOULD).add(this.toWildcard("hosts", token), BooleanClause.Occur.SHOULD).add(this.toWildcard("hosts_lowercase", token.toLowerCase()), BooleanClause.Occur.SHOULD).add(this.toWildcard("ownerName", token), BooleanClause.Occur.SHOULD).add(this.toWildcard("ownerName_lowercase", token.toLowerCase()), BooleanClause.Occur.SHOULD).add(this.toWildcard("labels", token), BooleanClause.Occur.SHOULD).add(this.toWildcard("labels_lowercase", token.toLowerCase()), BooleanClause.Occur.SHOULD).add(this.toWildcard("categories", token), BooleanClause.Occur.SHOULD).add(this.toWildcard("tags", token), BooleanClause.Occur.SHOULD).add(this.toWildcard("metadata", token), BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    private BooleanQuery buildEnvCriteria(ExecutionContext executionContext) {
        return new BooleanQuery.Builder().add((org.apache.lucene.search.Query)new TermQuery(new Term("reference_type", ReferenceContext.Type.ENVIRONMENT.name())), BooleanClause.Occur.FILTER).add((org.apache.lucene.search.Query)new TermQuery(new Term("reference_id", executionContext.getEnvironmentId())), BooleanClause.Occur.FILTER).build();
    }

    private boolean hasExplicitFilter(String query) {
        if (query != null) {
            return Arrays.stream(AUTHORIZED_EXPLICIT_FILTER).anyMatch(field -> query.contains(field + ":"));
        }
        return false;
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return source.isAssignableFrom(ApiEntity.class) || source.isAssignableFrom(io.gravitee.rest.api.model.v4.api.ApiEntity.class);
    }
}

