/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.utils.IdGenerator;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.MetadataRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Metadata;
import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.rest.api.model.MetadataEntity;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.NewMetadataEntity;
import io.gravitee.rest.api.model.UpdateMetadataEntity;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.MetadataService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.DuplicateMetadataNameException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.notification.NotificationTemplateService;
import jakarta.mail.internet.InternetAddress;
import java.io.StringReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class MetadataServiceImpl
extends TransactionalService
implements MetadataService {
    private final Logger LOGGER = LoggerFactory.getLogger(MetadataServiceImpl.class);
    @Lazy
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    private AuditService auditService;
    @Autowired
    private NotificationTemplateService notificationTemplateService;

    public static String getDefaultReferenceId() {
        return GraviteeContext.getDefaultEnvironment();
    }

    @Override
    public List<MetadataEntity> findByReferenceTypeAndReferenceId(MetadataReferenceType referenceType, String referenceId) {
        try {
            this.LOGGER.debug("Find metadata by reference {}/{}", (Object)referenceType, (Object)referenceId);
            return this.metadataRepository.findByReferenceTypeAndReferenceId(referenceType, referenceId).stream().sorted((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName())).map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurred while trying to find metadata by reference", (Throwable)ex);
            throw new TechnicalManagementException("An error occurred while trying to find metadata by reference", ex);
        }
    }

    @Override
    public MetadataEntity create(ExecutionContext executionContext, NewMetadataEntity metadataEntity) {
        return this.create(executionContext, metadataEntity, MetadataReferenceType.ENVIRONMENT, executionContext.getEnvironmentId());
    }

    @Override
    public MetadataEntity create(ExecutionContext executionContext, NewMetadataEntity metadataEntity, MetadataReferenceType referenceType, String referenceId) {
        if (metadataEntity.getFormat() == null) {
            metadataEntity.setFormat(MetadataFormat.STRING);
        }
        try {
            this.checkMetadataValue(metadataEntity.getValue());
            this.checkMetadataFormat(executionContext, metadataEntity.getFormat(), metadataEntity.getValue());
            Metadata metadata = this.convert(executionContext, metadataEntity);
            Date now = new Date();
            metadata.setCreatedAt(now);
            metadata.setUpdatedAt(now);
            metadata.setReferenceType(referenceType);
            metadata.setReferenceId(referenceId);
            Metadata created = this.metadataRepository.create(metadata);
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.METADATA, created.getKey()), (Audit.AuditEvent)Metadata.AuditEvent.METADATA_CREATED, created.getCreatedAt(), null, created);
            return this.convert(created);
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException("An error occurred while trying to create metadata " + metadataEntity.getName(), ex);
        }
    }

    @Override
    public MetadataEntity update(ExecutionContext executionContext, UpdateMetadataEntity metadataEntity) {
        try {
            Optional<Metadata> optionalMetadata = this.metadataRepository.findByReferenceTypeAndReferenceId(MetadataReferenceType.ENVIRONMENT, executionContext.getEnvironmentId()).stream().filter(metadata -> !metadataEntity.getKey().equals(metadata.getKey()) && metadataEntity.getName().equalsIgnoreCase(metadata.getName())).findAny();
            if (optionalMetadata.isPresent()) {
                throw new DuplicateMetadataNameException(optionalMetadata.get().getName());
            }
            this.checkMetadataValue(metadataEntity.getValue());
            this.checkMetadataFormat(executionContext, metadataEntity.getFormat(), metadataEntity.getValue());
            Metadata metadata2 = this.convert(executionContext, metadataEntity);
            Date now = new Date();
            metadata2.setUpdatedAt(now);
            this.metadataRepository.update(metadata2);
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.METADATA, metadata2.getKey()), (Audit.AuditEvent)Metadata.AuditEvent.METADATA_UPDATED, metadata2.getCreatedAt(), null, metadata2);
            return this.convert(metadata2);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurred while trying to update metadata {}", (Object)metadataEntity.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to update metadata " + metadataEntity.getName(), ex);
        }
    }

    private void checkMetadataValue(String value) {
        if (value == null || StringUtils.isBlank((CharSequence)value)) {
            this.LOGGER.error("Error occurred while trying to validate null or empty value");
            throw new TechnicalManagementException("Metadata value is required");
        }
    }

    @Override
    public void delete(ExecutionContext executionContext, String key) {
        try {
            Optional optMetadata = this.metadataRepository.findById(key, executionContext.getEnvironmentId(), MetadataReferenceType.ENVIRONMENT);
            if (optMetadata.isPresent()) {
                this.metadataRepository.delete(key, executionContext.getEnvironmentId(), MetadataReferenceType.ENVIRONMENT);
                this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.METADATA, key), (Audit.AuditEvent)Metadata.AuditEvent.METADATA_DELETED, new Date(), optMetadata.get(), null);
                List apiMetadata = this.metadataRepository.findByKeyAndReferenceType(key, MetadataReferenceType.API);
                for (Metadata metadata : apiMetadata) {
                    this.metadataRepository.delete(key, metadata.getReferenceId(), metadata.getReferenceType());
                    this.auditService.createApiAuditLog(executionContext, metadata.getReferenceId(), Collections.singletonMap(Audit.AuditProperties.METADATA, key), (Audit.AuditEvent)Metadata.AuditEvent.METADATA_DELETED, new Date(), metadata, null);
                }
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete metadata {}", (Object)key, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete metadata " + key, ex);
        }
    }

    @Override
    public MetadataEntity findByKeyAndReferenceTypeAndReferenceId(String key, MetadataReferenceType referenceType, String referenceId) {
        try {
            this.LOGGER.debug("Find by key and reference {}/{}/{}", new Object[]{key, referenceType, referenceId});
            Optional optMetadata = this.metadataRepository.findById(key, referenceId, referenceType);
            return optMetadata.map(this::convert).orElse(null);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurred while trying to find default metadata by key", (Throwable)ex);
            throw new TechnicalManagementException("An error occurred while trying to find default metadata by key", ex);
        }
    }

    @Override
    public void initialize(ExecutionContext executionContext) {
        NewMetadataEntity metadata = new NewMetadataEntity();
        metadata.setFormat(MetadataFormat.MAIL);
        metadata.setName("email-support");
        metadata.setValue("support@change.me");
        this.create(executionContext, metadata);
    }

    @Override
    public List<MetadataEntity> findByKeyAndReferenceType(String key, MetadataReferenceType referenceType) {
        try {
            this.LOGGER.debug("Find metadata by reference type ([{}]) and key [{}]", (Object)referenceType.name(), (Object)key);
            return this.metadataRepository.findByKeyAndReferenceType(key, referenceType).stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException("An error occurred while trying to find metadata by reference ([" + referenceType.name() + "]) and key [" + key + "]", ex);
        }
    }

    @Override
    public void checkMetadataFormat(ExecutionContext executionContext, MetadataFormat format, String value) {
        this.checkMetadataFormat(executionContext, format, value, null, null);
    }

    @Override
    public void checkMetadataFormat(ExecutionContext executionContext, MetadataFormat format, String value, MetadataReferenceType referenceType, Object entity) {
        try {
            String decodedValue = value;
            if (entity != null && !StringUtils.isBlank((CharSequence)value) && value.startsWith("${")) {
                decodedValue = this.notificationTemplateService.resolveInlineTemplateWithParam(executionContext.getOrganizationId(), value, new StringReader(value), Collections.singletonMap(referenceType.name().toLowerCase(), entity));
            }
            if (StringUtils.isBlank((CharSequence)decodedValue)) {
                return;
            }
            switch (format) {
                case BOOLEAN: {
                    Boolean.valueOf(decodedValue);
                    break;
                }
                case URL: {
                    new URL(decodedValue);
                    break;
                }
                case MAIL: {
                    InternetAddress email = new InternetAddress(decodedValue);
                    email.validate();
                    break;
                }
                case DATE: {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    sdf.setLenient(false);
                    sdf.parse(decodedValue);
                    break;
                }
                case NUMERIC: {
                    Double.valueOf(decodedValue);
                }
            }
        }
        catch (Exception e) {
            this.LOGGER.error("Error occurred while trying to validate format '{}' of value '{}'", new Object[]{format, value, e});
            throw new TechnicalManagementException("Error occurred while trying to validate format " + String.valueOf(format) + " of value " + value, e);
        }
    }

    private MetadataEntity convert(Metadata metadata) {
        MetadataEntity metadataEntity = new MetadataEntity();
        metadataEntity.setKey(metadata.getKey());
        metadataEntity.setName(metadata.getName());
        metadataEntity.setValue(metadata.getValue());
        metadataEntity.setFormat(MetadataFormat.valueOf((String)metadata.getFormat().name()));
        return metadataEntity;
    }

    private Metadata convert(ExecutionContext executionContext, NewMetadataEntity metadataEntity) {
        Metadata metadata = new Metadata();
        metadata.setKey(IdGenerator.generate((String)metadataEntity.getName()));
        metadata.setName(metadataEntity.getName());
        metadata.setFormat(io.gravitee.repository.management.model.MetadataFormat.valueOf((String)metadataEntity.getFormat().name()));
        if (metadataEntity.getValue() != null) {
            if (MetadataFormat.DATE.equals((Object)metadataEntity.getFormat())) {
                metadata.setValue(metadataEntity.getValue().substring(0, 10));
            } else {
                metadata.setValue(metadataEntity.getValue());
            }
        }
        metadata.setReferenceId(executionContext.getEnvironmentId());
        metadata.setReferenceType(MetadataReferenceType.ENVIRONMENT);
        return metadata;
    }

    private Metadata convert(ExecutionContext executionContext, UpdateMetadataEntity metadataEntity) {
        Metadata metadata = new Metadata();
        metadata.setKey(metadataEntity.getKey());
        metadata.setName(metadataEntity.getName());
        metadata.setFormat(io.gravitee.repository.management.model.MetadataFormat.valueOf((String)metadataEntity.getFormat().name()));
        if (metadataEntity.getValue() != null) {
            if (MetadataFormat.DATE.equals((Object)metadataEntity.getFormat())) {
                metadata.setValue(metadataEntity.getValue().substring(0, 10));
            } else {
                metadata.setValue(metadataEntity.getValue());
            }
        }
        metadata.setReferenceId(executionContext.getEnvironmentId());
        metadata.setReferenceType(MetadataReferenceType.ENVIRONMENT);
        return metadata;
    }
}

