/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plugin.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.plugin.domain_service.PluginFilterByLicenseDomainService;
import io.gravitee.apim.core.plugin.model.PlatformPlugin;
import io.gravitee.apim.core.plugin.model.ResourcePlugin;
import io.gravitee.apim.core.plugin.query_service.ResourcePluginQueryService;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

@UseCase
public class GetResourcePluginsUseCase {
    private final ResourcePluginQueryService resourcePluginQueryService;
    private final PluginFilterByLicenseDomainService licenseChecker;

    public GetResourcePluginsUseCase(ResourcePluginQueryService resourcePluginQueryService, PluginFilterByLicenseDomainService licenseChecker) {
        this.resourcePluginQueryService = resourcePluginQueryService;
        this.licenseChecker = licenseChecker;
    }

    public Output getResourcesByOrganization(Input input) {
        return new Output(this.licenseChecker.setPluginDeployedStatusDependingOnLicense(this.resourcePluginQueryService.findAll(), input.organizationId).stream().collect(Collectors.toCollection(() -> new TreeSet<ResourcePlugin>(Comparator.comparing(PlatformPlugin::getName)))));
    }

    public record Output(Set<ResourcePlugin> plugins) {
    }

    public record Input(String organizationId) {
    }
}

