/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.exception.NotAllowedDomainException;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import io.gravitee.apim.core.membership.domain_service.IntegrationPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.domain_service.IntegrationPrimaryOwnerFactory;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import lombok.Generated;

@UseCase
public class CreateIntegrationUseCase {
    private final IntegrationCrudService integrationCrudService;
    private final LicenseDomainService licenseDomainService;
    private final IntegrationPrimaryOwnerFactory integrationPrimaryOwnerFactory;
    private final IntegrationPrimaryOwnerDomainService integrationPrimaryOwnerDomainService;

    public Output execute(Input input) {
        if (!this.licenseDomainService.isFederationFeatureAllowed(input.auditInfo.organizationId())) {
            throw NotAllowedDomainException.noLicenseForFederation();
        }
        Integration integration = input.integration();
        Objects.requireNonNull(integration);
        Integration integration2 = integration;
        int n = 0;
        Record integrationToCreate = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integration.ApiIntegration.class, Integration.A2aIntegration.class}, (Object)integration2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Integration.ApiIntegration apiIntegration = (Integration.ApiIntegration)integration2;
                yield Integration.create(apiIntegration);
            }
            case 1 -> {
                Integration.A2aIntegration a2aIntegration = (Integration.A2aIntegration)integration2;
                yield Integration.create(a2aIntegration);
            }
        };
        Record integrationCreated = this.integrationCrudService.create(integrationToCreate);
        PrimaryOwnerEntity primaryOwner = this.integrationPrimaryOwnerFactory.createForNewIntegration(input.auditInfo.organizationId(), input.auditInfo.environmentId(), input.auditInfo.actor().userId());
        this.integrationPrimaryOwnerDomainService.createIntegrationPrimaryOwnerMembership(((Integration)((Object)integrationCreated)).id(), primaryOwner, input.auditInfo);
        return new Output((Integration)((Object)integrationCreated));
    }

    @Generated
    public CreateIntegrationUseCase(IntegrationCrudService integrationCrudService, LicenseDomainService licenseDomainService, IntegrationPrimaryOwnerFactory integrationPrimaryOwnerFactory, IntegrationPrimaryOwnerDomainService integrationPrimaryOwnerDomainService) {
        this.integrationCrudService = integrationCrudService;
        this.licenseDomainService = licenseDomainService;
        this.integrationPrimaryOwnerFactory = integrationPrimaryOwnerFactory;
        this.integrationPrimaryOwnerDomainService = integrationPrimaryOwnerDomainService;
    }

    public record Input(Integration integration, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private Integration integration;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder integration(Integration integration) {
                this.integration = integration;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.integration, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "CreateIntegrationUseCase.Input.InputBuilder(integration=" + String.valueOf(this.integration) + ", auditInfo=" + String.valueOf(this.auditInfo) + ")";
            }
        }
    }

    public record Output(Integration createdIntegration) {
    }
}

