/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.apim.core.template.TemplateProcessor;
import io.gravitee.apim.core.template.TemplateProcessorException;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.service.EmailRecipientsService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EmailRecipientsServiceImpl
implements EmailRecipientsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailRecipientsServiceImpl.class);
    public static final Pattern SPLIT_PATTERN = Pattern.compile("[,;\\s]");
    private final TemplateProcessor templateProcessor;
    private final UserService userService;

    @Override
    public Set<String> processTemplatedRecipients(Collection<String> templatedRecipientsEmail, Map<String, Object> templateData) {
        return templatedRecipientsEmail.stream().flatMap(splittableRecipientsStr -> Arrays.stream(SPLIT_PATTERN.split((CharSequence)splittableRecipientsStr)).filter(Predicate.not(String::isEmpty)).map(recipient -> {
            if (recipient.contains("$")) {
                try {
                    return Optional.ofNullable(this.templateProcessor.processInlineTemplate((String)recipient, templateData));
                }
                catch (TemplateProcessorException e) {
                    log.error("Error while processing template '{}' skipping this email", recipient, (Object)e);
                    return Optional.empty();
                }
            }
            return Optional.of(recipient);
        })).flatMap(Optional::stream).filter(Predicate.not(StringUtils::isEmpty)).collect(Collectors.toSet());
    }

    @Override
    public Set<String> filterRegisteredUser(ExecutionContext executionContext, Collection<String> recipientsEmail) {
        return recipientsEmail.stream().filter(email -> {
            List<UserEntity> users = this.userService.findByEmail(executionContext, (String)email);
            return CollectionUtils.isNotEmpty(users) && users.size() == 1 && users.getFirst().optedIn();
        }).collect(Collectors.toSet());
    }

    @Generated
    public EmailRecipientsServiceImpl(TemplateProcessor templateProcessor, UserService userService) {
        this.templateProcessor = templateProcessor;
        this.userService = userService;
    }
}

