/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.infra.adapter.FlowAdapter;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.flow.Consumer;
import io.gravitee.definition.model.flow.ConsumerType;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.Operator;
import io.gravitee.definition.model.flow.PathOperator;
import io.gravitee.definition.model.flow.Step;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.flow.selector.ChannelSelector;
import io.gravitee.definition.model.v4.flow.selector.ConditionSelector;
import io.gravitee.definition.model.v4.flow.selector.HttpSelector;
import io.gravitee.definition.model.v4.flow.selector.Selector;
import io.gravitee.definition.model.v4.flow.selector.SelectorType;
import io.gravitee.definition.model.v4.flow.step.Step;
import io.gravitee.definition.model.v4.nativeapi.NativeFlow;
import io.gravitee.repository.management.model.flow.Flow;
import io.gravitee.repository.management.model.flow.FlowConsumer;
import io.gravitee.repository.management.model.flow.FlowConsumerType;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.repository.management.model.flow.FlowStep;
import io.gravitee.repository.management.model.flow.selector.FlowChannelSelector;
import io.gravitee.repository.management.model.flow.selector.FlowConditionSelector;
import io.gravitee.repository.management.model.flow.selector.FlowHttpSelector;
import io.gravitee.repository.management.model.flow.selector.FlowOperator;
import io.gravitee.repository.management.model.flow.selector.FlowSelector;
import io.gravitee.repository.management.model.flow.selector.FlowSelectorType;
import io.gravitee.rest.api.service.common.UuidString;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class FlowAdapterImpl
implements FlowAdapter {
    @Override
    public io.gravitee.repository.management.model.flow.Flow toRepository(Flow source, FlowReferenceType referenceType, String referenceId, int order) {
        if (source == null && referenceType == null && referenceId == null) {
            return null;
        }
        Flow.FlowBuilder flow = io.gravitee.repository.management.model.flow.Flow.builder();
        if (source != null) {
            flow.name(source.getName());
            flow.enabled(source.isEnabled());
            flow.request(this.stepListToFlowStepList(source.getRequest()));
            flow.response(this.stepListToFlowStepList(source.getResponse()));
            flow.subscribe(this.stepListToFlowStepList(source.getSubscribe()));
            flow.publish(this.stepListToFlowStepList(source.getPublish()));
            Set set = source.getTags();
            if (set != null) {
                flow.tags(new LinkedHashSet(set));
            }
            flow.selectors(this.selectorListToFlowSelectorList(source.getSelectors()));
        }
        flow.referenceType(referenceType);
        flow.referenceId(referenceId);
        flow.order(Integer.valueOf(order));
        flow.id(UuidString.generateRandom());
        flow.createdAt(Date.from(TimeProvider.instantNow()));
        flow.updatedAt(Date.from(TimeProvider.instantNow()));
        return flow.build();
    }

    @Override
    public io.gravitee.repository.management.model.flow.Flow toRepository(NativeFlow source, FlowReferenceType referenceType, String referenceId, int order) {
        if (source == null && referenceType == null && referenceId == null) {
            return null;
        }
        Flow.FlowBuilder flow = io.gravitee.repository.management.model.flow.Flow.builder();
        if (source != null) {
            flow.name(source.getName());
            flow.enabled(source.isEnabled());
            flow.subscribe(this.stepListToFlowStepList(source.getSubscribe()));
            flow.publish(this.stepListToFlowStepList(source.getPublish()));
            flow.interact(this.stepListToFlowStepList(source.getInteract()));
            flow.connect(this.stepListToFlowStepList(source.getConnect()));
            Set set = source.getTags();
            if (set != null) {
                flow.tags(new LinkedHashSet(set));
            }
        }
        flow.referenceType(referenceType);
        flow.referenceId(referenceId);
        flow.order(Integer.valueOf(order));
        flow.id(UuidString.generateRandom());
        flow.createdAt(Date.from(TimeProvider.instantNow()));
        flow.updatedAt(Date.from(TimeProvider.instantNow()));
        return flow.build();
    }

    @Override
    public io.gravitee.repository.management.model.flow.Flow toRepositoryUpdate(io.gravitee.repository.management.model.flow.Flow repository, Flow source, int order) {
        if (source == null) {
            return repository;
        }
        if (source != null) {
            repository.setName(source.getName());
            repository.setEnabled(source.isEnabled());
            if (repository.getRequest() != null) {
                list = this.stepListToFlowStepList(source.getRequest());
                if (list != null) {
                    repository.getRequest().clear();
                    repository.getRequest().addAll(list);
                } else {
                    repository.setRequest(null);
                }
            } else {
                list = this.stepListToFlowStepList(source.getRequest());
                if (list != null) {
                    repository.setRequest(list);
                }
            }
            if (repository.getResponse() != null) {
                list1 = this.stepListToFlowStepList(source.getResponse());
                if (list1 != null) {
                    repository.getResponse().clear();
                    repository.getResponse().addAll(list1);
                } else {
                    repository.setResponse(null);
                }
            } else {
                list1 = this.stepListToFlowStepList(source.getResponse());
                if (list1 != null) {
                    repository.setResponse(list1);
                }
            }
            if (repository.getSubscribe() != null) {
                list2 = this.stepListToFlowStepList(source.getSubscribe());
                if (list2 != null) {
                    repository.getSubscribe().clear();
                    repository.getSubscribe().addAll(list2);
                } else {
                    repository.setSubscribe(null);
                }
            } else {
                list2 = this.stepListToFlowStepList(source.getSubscribe());
                if (list2 != null) {
                    repository.setSubscribe(list2);
                }
            }
            if (repository.getPublish() != null) {
                list3 = this.stepListToFlowStepList(source.getPublish());
                if (list3 != null) {
                    repository.getPublish().clear();
                    repository.getPublish().addAll(list3);
                } else {
                    repository.setPublish(null);
                }
            } else {
                list3 = this.stepListToFlowStepList(source.getPublish());
                if (list3 != null) {
                    repository.setPublish(list3);
                }
            }
            if (repository.getTags() != null) {
                set = source.getTags();
                if (set != null) {
                    repository.getTags().clear();
                    repository.getTags().addAll(set);
                } else {
                    repository.setTags(null);
                }
            } else {
                set = source.getTags();
                if (set != null) {
                    repository.setTags(new LinkedHashSet(set));
                }
            }
            if (repository.getSelectors() != null) {
                list4 = this.selectorListToFlowSelectorList(source.getSelectors());
                if (list4 != null) {
                    repository.getSelectors().clear();
                    repository.getSelectors().addAll(list4);
                } else {
                    repository.setSelectors(null);
                }
            } else {
                list4 = this.selectorListToFlowSelectorList(source.getSelectors());
                if (list4 != null) {
                    repository.setSelectors(list4);
                }
            }
        }
        repository.setOrder(order);
        repository.setUpdatedAt(Date.from(TimeProvider.instantNow()));
        return repository;
    }

    @Override
    public io.gravitee.repository.management.model.flow.Flow toRepositoryUpdate(io.gravitee.repository.management.model.flow.Flow repository, NativeFlow source, int order) {
        if (source == null) {
            return repository;
        }
        if (source != null) {
            repository.setName(source.getName());
            repository.setEnabled(source.isEnabled());
            if (repository.getSubscribe() != null) {
                list = this.stepListToFlowStepList(source.getSubscribe());
                if (list != null) {
                    repository.getSubscribe().clear();
                    repository.getSubscribe().addAll(list);
                } else {
                    repository.setSubscribe(null);
                }
            } else {
                list = this.stepListToFlowStepList(source.getSubscribe());
                if (list != null) {
                    repository.setSubscribe(list);
                }
            }
            if (repository.getPublish() != null) {
                list1 = this.stepListToFlowStepList(source.getPublish());
                if (list1 != null) {
                    repository.getPublish().clear();
                    repository.getPublish().addAll(list1);
                } else {
                    repository.setPublish(null);
                }
            } else {
                list1 = this.stepListToFlowStepList(source.getPublish());
                if (list1 != null) {
                    repository.setPublish(list1);
                }
            }
            if (repository.getInteract() != null) {
                list2 = this.stepListToFlowStepList(source.getInteract());
                if (list2 != null) {
                    repository.getInteract().clear();
                    repository.getInteract().addAll(list2);
                } else {
                    repository.setInteract(null);
                }
            } else {
                list2 = this.stepListToFlowStepList(source.getInteract());
                if (list2 != null) {
                    repository.setInteract(list2);
                }
            }
            if (repository.getConnect() != null) {
                list3 = this.stepListToFlowStepList(source.getConnect());
                if (list3 != null) {
                    repository.getConnect().clear();
                    repository.getConnect().addAll(list3);
                } else {
                    repository.setConnect(null);
                }
            } else {
                list3 = this.stepListToFlowStepList(source.getConnect());
                if (list3 != null) {
                    repository.setConnect(list3);
                }
            }
            if (repository.getTags() != null) {
                set = source.getTags();
                if (set != null) {
                    repository.getTags().clear();
                    repository.getTags().addAll(set);
                } else {
                    repository.setTags(null);
                }
            } else {
                set = source.getTags();
                if (set != null) {
                    repository.setTags(new LinkedHashSet(set));
                }
            }
        }
        repository.setOrder(order);
        repository.setUpdatedAt(Date.from(TimeProvider.instantNow()));
        return repository;
    }

    @Override
    public io.gravitee.repository.management.model.flow.Flow toRepository(io.gravitee.definition.model.flow.Flow source, FlowReferenceType referenceType, String referenceId, int order) {
        if (source == null && referenceType == null && referenceId == null) {
            return null;
        }
        Flow.FlowBuilder flow = io.gravitee.repository.management.model.flow.Flow.builder();
        if (source != null) {
            flow.name(source.getName());
            flow.enabled(source.isEnabled());
            flow.condition(source.getCondition());
            flow.pre(this.stepListToFlowStepList1(source.getPre()));
            flow.post(this.stepListToFlowStepList1(source.getPost()));
            flow.path(source.getPath());
            flow.operator(this.operatorToFlowOperator(source.getOperator()));
            Set set = source.getMethods();
            if (set != null) {
                flow.methods(new LinkedHashSet(set));
            }
            flow.consumers(this.consumerListToFlowConsumerList(source.getConsumers()));
        }
        flow.referenceType(referenceType);
        flow.referenceId(referenceId);
        flow.order(Integer.valueOf(order));
        flow.id(UuidString.generateRandom());
        flow.createdAt(Date.from(TimeProvider.instantNow()));
        flow.updatedAt(Date.from(TimeProvider.instantNow()));
        return flow.build();
    }

    @Override
    public Flow toFlowV4(io.gravitee.repository.management.model.flow.Flow source) {
        if (source == null) {
            return null;
        }
        Flow.FlowBuilder flow = Flow.builder();
        flow.id(source.getId());
        flow.name(source.getName());
        flow.enabled(source.isEnabled());
        Set set = source.getTags();
        if (set != null) {
            flow.tags(new LinkedHashSet(set));
        }
        flow.request(this.flowStepListToStepList(source.getRequest()));
        flow.response(this.flowStepListToStepList(source.getResponse()));
        flow.subscribe(this.flowStepListToStepList(source.getSubscribe()));
        flow.publish(this.flowStepListToStepList(source.getPublish()));
        flow.selectors(this.flowSelectorListToSelectorList(source.getSelectors()));
        return flow.build();
    }

    @Override
    public List<Flow> toFlowV4(List<io.gravitee.repository.management.model.flow.Flow> source) {
        if (source == null) {
            return null;
        }
        ArrayList<Flow> list = new ArrayList<Flow>(source.size());
        for (io.gravitee.repository.management.model.flow.Flow flow : source) {
            list.add(this.toFlowV4(flow));
        }
        return list;
    }

    @Override
    public NativeFlow toNativeFlow(io.gravitee.repository.management.model.flow.Flow source) {
        if (source == null) {
            return null;
        }
        NativeFlow.NativeFlowBuilder nativeFlow = NativeFlow.builder();
        nativeFlow.id(source.getId());
        nativeFlow.name(source.getName());
        nativeFlow.enabled(source.isEnabled());
        Set set = source.getTags();
        if (set != null) {
            nativeFlow.tags(new LinkedHashSet(set));
        }
        nativeFlow.connect(this.flowStepListToStepList(source.getConnect()));
        nativeFlow.interact(this.flowStepListToStepList(source.getInteract()));
        nativeFlow.subscribe(this.flowStepListToStepList(source.getSubscribe()));
        nativeFlow.publish(this.flowStepListToStepList(source.getPublish()));
        return nativeFlow.build();
    }

    @Override
    public List<NativeFlow> toNativeFlow(List<io.gravitee.repository.management.model.flow.Flow> source) {
        if (source == null) {
            return null;
        }
        ArrayList<NativeFlow> list = new ArrayList<NativeFlow>(source.size());
        for (io.gravitee.repository.management.model.flow.Flow flow : source) {
            list.add(this.toNativeFlow(flow));
        }
        return list;
    }

    @Override
    public io.gravitee.definition.model.flow.Flow toFlowV2(io.gravitee.repository.management.model.flow.Flow source) {
        if (source == null) {
            return null;
        }
        Flow.FlowBuilder flow = io.gravitee.definition.model.flow.Flow.builder();
        flow.pathOperator(this.flowToPathOperator(source));
        flow.id(source.getId());
        flow.name(source.getName());
        flow.pre(this.flowStepListToStepList1(source.getPre()));
        flow.post(this.flowStepListToStepList1(source.getPost()));
        flow.enabled(source.isEnabled());
        Set set = source.getMethods();
        if (set != null) {
            flow.methods(new LinkedHashSet(set));
        }
        flow.condition(source.getCondition());
        flow.consumers(this.flowConsumerListToConsumerList(source.getConsumers()));
        return flow.build();
    }

    @Override
    public FlowHttpSelector toRepository(HttpSelector source) {
        if (source == null) {
            return null;
        }
        FlowHttpSelector.FlowHttpSelectorBuilder flowHttpSelector = FlowHttpSelector.builder();
        flowHttpSelector.type(this.selectorTypeToFlowSelectorType(source.getType()));
        flowHttpSelector.path(source.getPath());
        flowHttpSelector.pathOperator(this.operatorToFlowOperator(source.getPathOperator()));
        Set set = source.getMethods();
        if (set != null) {
            flowHttpSelector.methods(new LinkedHashSet(set));
        }
        return flowHttpSelector.build();
    }

    @Override
    public HttpSelector toModel(FlowHttpSelector source) {
        if (source == null) {
            return null;
        }
        HttpSelector.HttpSelectorBuilder httpSelector = HttpSelector.builder();
        httpSelector.type(this.flowSelectorTypeToSelectorType(source.getType()));
        httpSelector.path(source.getPath());
        httpSelector.pathOperator(this.flowOperatorToOperator(source.getPathOperator()));
        Set set = source.getMethods();
        if (set != null) {
            httpSelector.methods(new LinkedHashSet(set));
        }
        return httpSelector.build();
    }

    @Override
    public FlowChannelSelector toRepository(ChannelSelector source) {
        if (source == null) {
            return null;
        }
        FlowChannelSelector.FlowChannelSelectorBuilder flowChannelSelector = FlowChannelSelector.builder();
        flowChannelSelector.type(this.selectorTypeToFlowSelectorType(source.getType()));
        flowChannelSelector.operations(this.operationSetToOperationSet(source.getOperations()));
        flowChannelSelector.channel(source.getChannel());
        flowChannelSelector.channelOperator(this.operatorToFlowOperator(source.getChannelOperator()));
        Set set1 = source.getEntrypoints();
        if (set1 != null) {
            flowChannelSelector.entrypoints(new LinkedHashSet(set1));
        }
        return flowChannelSelector.build();
    }

    @Override
    public ChannelSelector toModel(FlowChannelSelector source) {
        if (source == null) {
            return null;
        }
        ChannelSelector.ChannelSelectorBuilder channelSelector = ChannelSelector.builder();
        channelSelector.type(this.flowSelectorTypeToSelectorType(source.getType()));
        channelSelector.operations(this.operationSetToOperationSet1(source.getOperations()));
        channelSelector.channel(source.getChannel());
        channelSelector.channelOperator(this.flowOperatorToOperator(source.getChannelOperator()));
        Set set1 = source.getEntrypoints();
        if (set1 != null) {
            channelSelector.entrypoints(new LinkedHashSet(set1));
        }
        return channelSelector.build();
    }

    @Override
    public FlowConditionSelector toRepository(ConditionSelector source) {
        if (source == null) {
            return null;
        }
        FlowConditionSelector.FlowConditionSelectorBuilder flowConditionSelector = FlowConditionSelector.builder();
        flowConditionSelector.type(this.selectorTypeToFlowSelectorType(source.getType()));
        flowConditionSelector.condition(source.getCondition());
        return flowConditionSelector.build();
    }

    @Override
    public ConditionSelector toModel(FlowConditionSelector source) {
        if (source == null) {
            return null;
        }
        ConditionSelector.ConditionSelectorBuilder conditionSelector = ConditionSelector.builder();
        conditionSelector.type(this.flowSelectorTypeToSelectorType(source.getType()));
        conditionSelector.condition(source.getCondition());
        return conditionSelector.build();
    }

    protected FlowStep stepToFlowStep(io.gravitee.definition.model.v4.flow.step.Step step) {
        if (step == null) {
            return null;
        }
        FlowStep.FlowStepBuilder flowStep = FlowStep.builder();
        flowStep.name(step.getName());
        flowStep.policy(step.getPolicy());
        flowStep.description(step.getDescription());
        flowStep.configuration(step.getConfiguration());
        flowStep.enabled(step.isEnabled());
        flowStep.condition(step.getCondition());
        flowStep.messageCondition(step.getMessageCondition());
        return flowStep.build();
    }

    protected List<FlowStep> stepListToFlowStepList(List<io.gravitee.definition.model.v4.flow.step.Step> list) {
        if (list == null) {
            return null;
        }
        ArrayList<FlowStep> list1 = new ArrayList<FlowStep>(list.size());
        for (io.gravitee.definition.model.v4.flow.step.Step step : list) {
            list1.add(this.stepToFlowStep(step));
        }
        return list1;
    }

    protected List<FlowSelector> selectorListToFlowSelectorList(List<Selector> list) {
        if (list == null) {
            return null;
        }
        ArrayList<FlowSelector> list1 = new ArrayList<FlowSelector>(list.size());
        for (Selector selector : list) {
            list1.add(this.toRepository(selector));
        }
        return list1;
    }

    protected FlowStep stepToFlowStep1(Step step) {
        if (step == null) {
            return null;
        }
        FlowStep.FlowStepBuilder flowStep = FlowStep.builder();
        flowStep.name(step.getName());
        flowStep.policy(step.getPolicy());
        flowStep.description(step.getDescription());
        flowStep.configuration(step.getConfiguration());
        flowStep.enabled(step.isEnabled());
        flowStep.condition(step.getCondition());
        return flowStep.build();
    }

    protected List<FlowStep> stepListToFlowStepList1(List<Step> list) {
        if (list == null) {
            return null;
        }
        ArrayList<FlowStep> list1 = new ArrayList<FlowStep>(list.size());
        for (Step step : list) {
            list1.add(this.stepToFlowStep1(step));
        }
        return list1;
    }

    protected FlowOperator operatorToFlowOperator(Operator operator) {
        if (operator == null) {
            return null;
        }
        return switch (operator) {
            case Operator.STARTS_WITH -> FlowOperator.STARTS_WITH;
            case Operator.EQUALS -> FlowOperator.EQUALS;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(operator));
        };
    }

    protected FlowConsumerType consumerTypeToFlowConsumerType(ConsumerType consumerType) {
        if (consumerType == null) {
            return null;
        }
        return switch (consumerType) {
            case ConsumerType.TAG -> FlowConsumerType.TAG;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(consumerType));
        };
    }

    protected FlowConsumer consumerToFlowConsumer(Consumer consumer) {
        if (consumer == null) {
            return null;
        }
        FlowConsumer flowConsumer = new FlowConsumer();
        flowConsumer.setConsumerId(consumer.getConsumerId());
        flowConsumer.setConsumerType(this.consumerTypeToFlowConsumerType(consumer.getConsumerType()));
        return flowConsumer;
    }

    protected List<FlowConsumer> consumerListToFlowConsumerList(List<Consumer> list) {
        if (list == null) {
            return null;
        }
        ArrayList<FlowConsumer> list1 = new ArrayList<FlowConsumer>(list.size());
        for (Consumer consumer : list) {
            list1.add(this.consumerToFlowConsumer(consumer));
        }
        return list1;
    }

    protected io.gravitee.definition.model.v4.flow.step.Step flowStepToStep(FlowStep flowStep) {
        if (flowStep == null) {
            return null;
        }
        Step.StepBuilder step = io.gravitee.definition.model.v4.flow.step.Step.builder();
        step.name(flowStep.getName());
        step.description(flowStep.getDescription());
        step.enabled(flowStep.isEnabled());
        step.policy(flowStep.getPolicy());
        step.configuration((Object)flowStep.getConfiguration());
        step.condition(flowStep.getCondition());
        step.messageCondition(flowStep.getMessageCondition());
        return step.build();
    }

    protected List<io.gravitee.definition.model.v4.flow.step.Step> flowStepListToStepList(List<FlowStep> list) {
        if (list == null) {
            return null;
        }
        ArrayList<io.gravitee.definition.model.v4.flow.step.Step> list1 = new ArrayList<io.gravitee.definition.model.v4.flow.step.Step>(list.size());
        for (FlowStep flowStep : list) {
            list1.add(this.flowStepToStep(flowStep));
        }
        return list1;
    }

    protected List<Selector> flowSelectorListToSelectorList(List<FlowSelector> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Selector> list1 = new ArrayList<Selector>(list.size());
        for (FlowSelector flowSelector : list) {
            list1.add(this.toModel(flowSelector));
        }
        return list1;
    }

    protected Operator flowOperatorToOperator(FlowOperator flowOperator) {
        if (flowOperator == null) {
            return null;
        }
        return switch (flowOperator) {
            case FlowOperator.STARTS_WITH -> Operator.STARTS_WITH;
            case FlowOperator.EQUALS -> Operator.EQUALS;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(flowOperator));
        };
    }

    protected PathOperator flowToPathOperator(io.gravitee.repository.management.model.flow.Flow flow) {
        if (flow == null) {
            return null;
        }
        PathOperator.PathOperatorBuilder pathOperator = PathOperator.builder();
        pathOperator.path(flow.getPath());
        pathOperator.operator(this.flowOperatorToOperator(flow.getOperator()));
        return pathOperator.build();
    }

    protected Step flowStepToStep1(FlowStep flowStep) {
        if (flowStep == null) {
            return null;
        }
        Step.StepBuilder step = Step.builder();
        step.name(flowStep.getName());
        step.policy(flowStep.getPolicy());
        step.description(flowStep.getDescription());
        step.configuration((Object)flowStep.getConfiguration());
        step.enabled(flowStep.isEnabled());
        step.condition(flowStep.getCondition());
        return step.build();
    }

    protected List<Step> flowStepListToStepList1(List<FlowStep> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Step> list1 = new ArrayList<Step>(list.size());
        for (FlowStep flowStep : list) {
            list1.add(this.flowStepToStep1(flowStep));
        }
        return list1;
    }

    protected ConsumerType flowConsumerTypeToConsumerType(FlowConsumerType flowConsumerType) {
        if (flowConsumerType == null) {
            return null;
        }
        return switch (flowConsumerType) {
            case FlowConsumerType.TAG -> ConsumerType.TAG;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(flowConsumerType));
        };
    }

    protected Consumer flowConsumerToConsumer(FlowConsumer flowConsumer) {
        if (flowConsumer == null) {
            return null;
        }
        Consumer.ConsumerBuilder consumer = Consumer.builder();
        consumer.consumerType(this.flowConsumerTypeToConsumerType(flowConsumer.getConsumerType()));
        consumer.consumerId(flowConsumer.getConsumerId());
        return consumer.build();
    }

    protected List<Consumer> flowConsumerListToConsumerList(List<FlowConsumer> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Consumer> list1 = new ArrayList<Consumer>(list.size());
        for (FlowConsumer flowConsumer : list) {
            list1.add(this.flowConsumerToConsumer(flowConsumer));
        }
        return list1;
    }

    protected FlowSelectorType selectorTypeToFlowSelectorType(SelectorType selectorType) {
        if (selectorType == null) {
            return null;
        }
        return switch (selectorType) {
            case SelectorType.HTTP -> FlowSelectorType.HTTP;
            case SelectorType.CHANNEL -> FlowSelectorType.CHANNEL;
            case SelectorType.CONDITION -> FlowSelectorType.CONDITION;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(selectorType));
        };
    }

    protected SelectorType flowSelectorTypeToSelectorType(FlowSelectorType flowSelectorType) {
        if (flowSelectorType == null) {
            return null;
        }
        return switch (flowSelectorType) {
            case FlowSelectorType.HTTP -> SelectorType.HTTP;
            case FlowSelectorType.CHANNEL -> SelectorType.CHANNEL;
            case FlowSelectorType.CONDITION -> SelectorType.CONDITION;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(flowSelectorType));
        };
    }

    protected FlowChannelSelector.Operation operationToOperation(ChannelSelector.Operation operation) {
        if (operation == null) {
            return null;
        }
        return switch (operation) {
            case ChannelSelector.Operation.SUBSCRIBE -> FlowChannelSelector.Operation.SUBSCRIBE;
            case ChannelSelector.Operation.PUBLISH -> FlowChannelSelector.Operation.PUBLISH;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(operation));
        };
    }

    protected Set<FlowChannelSelector.Operation> operationSetToOperationSet(Set<ChannelSelector.Operation> set) {
        if (set == null) {
            return null;
        }
        LinkedHashSet<FlowChannelSelector.Operation> set1 = LinkedHashSet.newLinkedHashSet(set.size());
        for (ChannelSelector.Operation operation : set) {
            set1.add(this.operationToOperation(operation));
        }
        return set1;
    }

    protected ChannelSelector.Operation operationToOperation1(FlowChannelSelector.Operation operation) {
        if (operation == null) {
            return null;
        }
        return switch (operation) {
            case FlowChannelSelector.Operation.SUBSCRIBE -> ChannelSelector.Operation.SUBSCRIBE;
            case FlowChannelSelector.Operation.PUBLISH -> ChannelSelector.Operation.PUBLISH;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(operation));
        };
    }

    protected Set<ChannelSelector.Operation> operationSetToOperationSet1(Set<FlowChannelSelector.Operation> set) {
        if (set == null) {
            return null;
        }
        LinkedHashSet<ChannelSelector.Operation> set1 = LinkedHashSet.newLinkedHashSet(set.size());
        for (FlowChannelSelector.Operation operation : set) {
            set1.add(this.operationToOperation1(operation));
        }
        return set1;
    }
}

