/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.node.api.upgrader.UpgraderException;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.model.Organization;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UpdateRoleEntity;
import io.gravitee.rest.api.model.permissions.OrganizationPermission;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class UserTokenPermissionUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserTokenPermissionUpgrader.class);
    private final RoleService roleService;
    private final OrganizationRepository organizationRepository;

    @Autowired
    public UserTokenPermissionUpgrader(RoleService roleService, @Lazy OrganizationRepository organizationRepository) {
        this.roleService = roleService;
        this.organizationRepository = organizationRepository;
    }

    public int getOrder() {
        return 702;
    }

    public boolean upgrade() throws UpgraderException {
        return this.wrapException(() -> {
            this.organizationRepository.findAll().forEach(organization -> this.roleService.findByScope(RoleScope.ORGANIZATION, organization.getId()).stream().filter(role -> !SystemRole.ADMIN.name().equalsIgnoreCase(role.getName())).forEach(role -> this.processRolePermissions((RoleEntity)role, (Organization)organization)));
            return true;
        });
    }

    private void processRolePermissions(RoleEntity role, Organization organization) {
        HashSet<Character> userTokenPermission = new HashSet<Character>();
        Map permissions = role.getPermissions();
        if (permissions != null) {
            char[] userPermission = (char[])permissions.get(OrganizationPermission.USER.getName());
            if (userPermission != null) {
                block6: for (char permission : userPermission) {
                    switch (permission) {
                        case 'R': {
                            userTokenPermission.addAll(Set.of(Character.valueOf('R'), Character.valueOf('C'), Character.valueOf('D')));
                            continue block6;
                        }
                        case 'C': {
                            userTokenPermission.add(Character.valueOf('C'));
                            continue block6;
                        }
                        case 'D': {
                            userTokenPermission.add(Character.valueOf('D'));
                            continue block6;
                        }
                        case 'U': {
                            userTokenPermission.add(Character.valueOf('U'));
                        }
                    }
                }
            }
            permissions.put(OrganizationPermission.USER_TOKEN.getName(), this.toCharArray(userTokenPermission));
            role.setPermissions(permissions);
            this.roleService.update(new ExecutionContext(organization), this.convert(role));
        }
    }

    private char[] toCharArray(Set<Character> charSet) {
        char[] charArray = new char[charSet.size()];
        int i = 0;
        for (Character ch : charSet) {
            charArray[i++] = ch.charValue();
        }
        return charArray;
    }

    private UpdateRoleEntity convert(RoleEntity role) {
        UpdateRoleEntity updateRoleEntity = new UpdateRoleEntity();
        updateRoleEntity.setId(role.getId());
        updateRoleEntity.setName(role.getName());
        updateRoleEntity.setDescription(role.getDescription());
        updateRoleEntity.setDefaultRole(role.isDefaultRole());
        updateRoleEntity.setPermissions(role.getPermissions());
        updateRoleEntity.setScope(role.getScope());
        return updateRoleEntity;
    }
}

