/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.ApiMetadata;
import io.gravitee.apim.core.metadata.model.Metadata;
import io.gravitee.apim.infra.adapter.MetadataAdapter;
import io.gravitee.repository.management.model.Metadata;
import io.gravitee.repository.management.model.MetadataFormat;
import io.gravitee.repository.management.model.MetadataReferenceType;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class MetadataAdapterImpl
implements MetadataAdapter {
    @Override
    public io.gravitee.apim.core.metadata.model.Metadata toEntity(Metadata source) {
        if (source == null) {
            return null;
        }
        Metadata.MetadataBuilder metadata = io.gravitee.apim.core.metadata.model.Metadata.builder();
        metadata.key(source.getKey());
        metadata.referenceType(this.metadataReferenceTypeToReferenceType(source.getReferenceType()));
        metadata.referenceId(source.getReferenceId());
        metadata.name(source.getName());
        metadata.format(this.metadataFormatToMetadataFormat(source.getFormat()));
        metadata.value(source.getValue());
        if (source.getCreatedAt() != null) {
            metadata.createdAt(ZonedDateTime.ofInstant(source.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (source.getUpdatedAt() != null) {
            metadata.updatedAt(ZonedDateTime.ofInstant(source.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        return metadata.build();
    }

    @Override
    public Metadata toRepository(io.gravitee.apim.core.metadata.model.Metadata source) {
        if (source == null) {
            return null;
        }
        Metadata.MetadataBuilder metadata = Metadata.builder();
        metadata.key(source.getKey());
        metadata.referenceId(source.getReferenceId());
        metadata.referenceType(this.referenceTypeToMetadataReferenceType(source.getReferenceType()));
        metadata.name(source.getName());
        metadata.format(this.metadataFormatToMetadataFormat1(source.getFormat()));
        metadata.value(source.getValue());
        if (source.getCreatedAt() != null) {
            metadata.createdAt(Date.from(source.getCreatedAt().toInstant()));
        }
        if (source.getUpdatedAt() != null) {
            metadata.updatedAt(Date.from(source.getUpdatedAt().toInstant()));
        }
        return metadata.build();
    }

    @Override
    public io.gravitee.apim.core.metadata.model.Metadata toMetadata(ApiMetadata source) {
        if (source == null) {
            return null;
        }
        Metadata.MetadataBuilder metadata = io.gravitee.apim.core.metadata.model.Metadata.builder();
        metadata.referenceId(source.getApiId());
        metadata.key(source.getKey());
        metadata.name(source.getName());
        metadata.format(source.getFormat());
        metadata.value(source.getValue());
        metadata.referenceType(Metadata.ReferenceType.API);
        return metadata.build();
    }

    protected Metadata.ReferenceType metadataReferenceTypeToReferenceType(MetadataReferenceType metadataReferenceType) {
        if (metadataReferenceType == null) {
            return null;
        }
        return switch (metadataReferenceType) {
            case MetadataReferenceType.DEFAULT -> Metadata.ReferenceType.DEFAULT;
            case MetadataReferenceType.API -> Metadata.ReferenceType.API;
            case MetadataReferenceType.APPLICATION -> Metadata.ReferenceType.APPLICATION;
            case MetadataReferenceType.ENVIRONMENT -> Metadata.ReferenceType.ENVIRONMENT;
            case MetadataReferenceType.USER -> Metadata.ReferenceType.USER;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(metadataReferenceType));
        };
    }

    protected Metadata.MetadataFormat metadataFormatToMetadataFormat(MetadataFormat metadataFormat) {
        if (metadataFormat == null) {
            return null;
        }
        return switch (metadataFormat) {
            case MetadataFormat.STRING -> Metadata.MetadataFormat.STRING;
            case MetadataFormat.NUMERIC -> Metadata.MetadataFormat.NUMERIC;
            case MetadataFormat.BOOLEAN -> Metadata.MetadataFormat.BOOLEAN;
            case MetadataFormat.DATE -> Metadata.MetadataFormat.DATE;
            case MetadataFormat.MAIL -> Metadata.MetadataFormat.MAIL;
            case MetadataFormat.URL -> Metadata.MetadataFormat.URL;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(metadataFormat));
        };
    }

    protected MetadataReferenceType referenceTypeToMetadataReferenceType(Metadata.ReferenceType referenceType) {
        if (referenceType == null) {
            return null;
        }
        return switch (referenceType) {
            case Metadata.ReferenceType.DEFAULT -> MetadataReferenceType.DEFAULT;
            case Metadata.ReferenceType.API -> MetadataReferenceType.API;
            case Metadata.ReferenceType.APPLICATION -> MetadataReferenceType.APPLICATION;
            case Metadata.ReferenceType.ENVIRONMENT -> MetadataReferenceType.ENVIRONMENT;
            case Metadata.ReferenceType.USER -> MetadataReferenceType.USER;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)referenceType));
        };
    }

    protected MetadataFormat metadataFormatToMetadataFormat1(Metadata.MetadataFormat metadataFormat) {
        if (metadataFormat == null) {
            return null;
        }
        return switch (metadataFormat) {
            case Metadata.MetadataFormat.STRING -> MetadataFormat.STRING;
            case Metadata.MetadataFormat.NUMERIC -> MetadataFormat.NUMERIC;
            case Metadata.MetadataFormat.BOOLEAN -> MetadataFormat.BOOLEAN;
            case Metadata.MetadataFormat.DATE -> MetadataFormat.DATE;
            case Metadata.MetadataFormat.MAIL -> MetadataFormat.MAIL;
            case Metadata.MetadataFormat.URL -> MetadataFormat.URL;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)metadataFormat));
        };
    }
}

