/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.membership.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.event.MembershipAuditEvent;
import io.gravitee.apim.core.membership.crud_service.MembershipCrudService;
import io.gravitee.apim.core.membership.model.Membership;
import io.gravitee.apim.core.membership.query_service.MembershipQueryService;
import io.gravitee.common.utils.TimeProvider;
import java.util.Collection;
import java.util.Collections;

@DomainService
public class DeleteMembershipDomainService {
    MembershipQueryService membershipQueryService;
    MembershipCrudService membershipCrudService;
    AuditDomainService auditDomainService;

    public DeleteMembershipDomainService(MembershipQueryService membershipQueryService, MembershipCrudService membershipCrudService, AuditDomainService auditDomainService) {
        this.membershipQueryService = membershipQueryService;
        this.membershipCrudService = membershipCrudService;
        this.auditDomainService = auditDomainService;
    }

    public void deleteApiMemberships(String apiId, AuditInfo auditInfo) {
        Collection<Membership> memberships = this.membershipQueryService.findByReference(Membership.ReferenceType.API, apiId);
        memberships.forEach(membership -> {
            this.membershipCrudService.delete(membership.getId());
            this.createAuditLog(auditInfo, (Membership)membership, apiId);
        });
    }

    public void deleteIntegrationMemberships(String integrationId) {
        Collection<Membership> memberships = this.membershipQueryService.findByReference(Membership.ReferenceType.INTEGRATION, integrationId);
        memberships.forEach(membership -> this.membershipCrudService.delete(membership.getId()));
    }

    private void createAuditLog(AuditInfo auditInfo, Membership membership, String apiId) {
        this.auditDomainService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(apiId).event(MembershipAuditEvent.MEMBERSHIP_DELETED).actor(auditInfo.actor()).oldValue(membership).createdAt(TimeProvider.now()).properties(Collections.emptyMap()).build());
    }
}

