/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.ExecutionMode;
import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.node.api.upgrader.UpgraderException;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.Api;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ExecutionModeUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutionModeUpgrader.class);
    private static final int BULK_SIZE = 100;
    private final ApiRepository apiRepository;
    private int modelCounter;
    private final ObjectMapper objectMapper;

    @Autowired
    public ExecutionModeUpgrader(@Lazy ApiRepository apiRepository, @Lazy ObjectMapper objectMapper) {
        this.apiRepository = apiRepository;
        this.objectMapper = objectMapper;
    }

    public int getOrder() {
        return 610;
    }

    public boolean upgrade() throws UpgraderException {
        return this.wrapException(this::migrateApiEvents);
    }

    private boolean migrateApiEvents() throws UpgraderException {
        log.info("Starting migrating execution mode for APIs");
        this.modelCounter = 0;
        ApiCriteria onlyV2ApiCriteria = new ApiCriteria.Builder().definitionVersion(List.of(DefinitionVersion.V2)).build();
        List apis = this.apiRepository.search(onlyV2ApiCriteria, null, new ApiFieldFilter.Builder().excludePicture().build()).toList();
        for (Api api : apis) {
            try {
                ObjectNode objectNode;
                JsonNode executionMode;
                JsonNode apiDefinitionNode;
                if (api.getDefinition() == null || !(apiDefinitionNode = this.objectMapper.readTree(api.getDefinition())).isObject() || (executionMode = (objectNode = (ObjectNode)apiDefinitionNode).get("execution_mode")) == null || !executionMode.asText().equals("jupiter")) continue;
                ++this.modelCounter;
                objectNode.put("execution_mode", ExecutionMode.V4_EMULATION_ENGINE.getLabel());
                api.setDefinition(this.objectMapper.writeValueAsString((Object)apiDefinitionNode));
                this.apiRepository.update((Object)api);
            }
            catch (JsonProcessingException | TechnicalException e) {
                log.error("Error processing API {}: {}", (Object)api.getId(), (Object)e.getMessage());
                throw new UpgraderException(e);
            }
        }
        log.info("{} jupiter APIs have been migrated to use v4-emulation-engine execution mode", (Object)this.modelCounter);
        return true;
    }
}

