/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.model;

import io.gravitee.apim.core.documentation.model.AccessControl;
import io.gravitee.apim.core.documentation.model.PageMedia;
import io.gravitee.apim.core.documentation.model.PageSource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class Page {
    private String id;
    private String crossId;
    private String referenceId;
    private ReferenceType referenceType;
    private String name;
    private Type type;
    private String lastContributor;
    private int order;
    private boolean published;
    private Visibility visibility;
    private Date createdAt;
    private Date updatedAt;
    private String parentId;
    private boolean excludedAccessControls;
    private Set<AccessControl> accessControls;
    private Boolean hidden;
    private String content;
    private boolean homepage;
    private Boolean generalConditions;
    private PageSource source;
    private Map<String, String> configuration;
    private Map<String, String> metadata;
    private Boolean useAutoFetch;
    private List<PageMedia> attachedMedia;
    private boolean ingested;

    public boolean isMarkdown() {
        return Type.MARKDOWN.equals((Object)this.type);
    }

    public boolean isSwagger() {
        return Type.SWAGGER.equals((Object)this.type);
    }

    public boolean isAsyncApi() {
        return Type.ASYNCAPI.equals((Object)this.type);
    }

    public boolean isSwaggerOrMarkdown() {
        return Type.SWAGGER.equals((Object)this.type) || Type.MARKDOWN.equals((Object)this.type);
    }

    public boolean isFolder() {
        return Type.FOLDER.equals((Object)this.type);
    }

    public boolean isRoot() {
        return Type.ROOT.equals((Object)this.type);
    }

    @Generated
    public static PageBuilder builder() {
        return new PageBuilder();
    }

    @Generated
    public PageBuilder toBuilder() {
        return new PageBuilder().id(this.id).crossId(this.crossId).referenceId(this.referenceId).referenceType(this.referenceType).name(this.name).type(this.type).lastContributor(this.lastContributor).order(this.order).published(this.published).visibility(this.visibility).createdAt(this.createdAt).updatedAt(this.updatedAt).parentId(this.parentId).excludedAccessControls(this.excludedAccessControls).accessControls(this.accessControls).hidden(this.hidden).content(this.content).homepage(this.homepage).generalConditions(this.generalConditions).source(this.source).configuration(this.configuration).metadata(this.metadata).useAutoFetch(this.useAutoFetch).attachedMedia(this.attachedMedia).ingested(this.ingested);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getCrossId() {
        return this.crossId;
    }

    @Generated
    public String getReferenceId() {
        return this.referenceId;
    }

    @Generated
    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public String getLastContributor() {
        return this.lastContributor;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public boolean isPublished() {
        return this.published;
    }

    @Generated
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public String getParentId() {
        return this.parentId;
    }

    @Generated
    public boolean isExcludedAccessControls() {
        return this.excludedAccessControls;
    }

    @Generated
    public Set<AccessControl> getAccessControls() {
        return this.accessControls;
    }

    @Generated
    public Boolean getHidden() {
        return this.hidden;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public boolean isHomepage() {
        return this.homepage;
    }

    @Generated
    public Boolean getGeneralConditions() {
        return this.generalConditions;
    }

    @Generated
    public PageSource getSource() {
        return this.source;
    }

    @Generated
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Boolean getUseAutoFetch() {
        return this.useAutoFetch;
    }

    @Generated
    public List<PageMedia> getAttachedMedia() {
        return this.attachedMedia;
    }

    @Generated
    public boolean isIngested() {
        return this.ingested;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    @Generated
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Generated
    public void setReferenceType(ReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(Type type) {
        this.type = type;
    }

    @Generated
    public void setLastContributor(String lastContributor) {
        this.lastContributor = lastContributor;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setPublished(boolean published) {
        this.published = published;
    }

    @Generated
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Generated
    public void setExcludedAccessControls(boolean excludedAccessControls) {
        this.excludedAccessControls = excludedAccessControls;
    }

    @Generated
    public void setAccessControls(Set<AccessControl> accessControls) {
        this.accessControls = accessControls;
    }

    @Generated
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setHomepage(boolean homepage) {
        this.homepage = homepage;
    }

    @Generated
    public void setGeneralConditions(Boolean generalConditions) {
        this.generalConditions = generalConditions;
    }

    @Generated
    public void setSource(PageSource source) {
        this.source = source;
    }

    @Generated
    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setUseAutoFetch(Boolean useAutoFetch) {
        this.useAutoFetch = useAutoFetch;
    }

    @Generated
    public void setAttachedMedia(List<PageMedia> attachedMedia) {
        this.attachedMedia = attachedMedia;
    }

    @Generated
    public void setIngested(boolean ingested) {
        this.ingested = ingested;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOrder() != other.getOrder()) {
            return false;
        }
        if (this.isPublished() != other.isPublished()) {
            return false;
        }
        if (this.isExcludedAccessControls() != other.isExcludedAccessControls()) {
            return false;
        }
        if (this.isHomepage() != other.isHomepage()) {
            return false;
        }
        if (this.isIngested() != other.isIngested()) {
            return false;
        }
        Boolean this$hidden = this.getHidden();
        Boolean other$hidden = other.getHidden();
        if (this$hidden == null ? other$hidden != null : !((Object)this$hidden).equals(other$hidden)) {
            return false;
        }
        Boolean this$generalConditions = this.getGeneralConditions();
        Boolean other$generalConditions = other.getGeneralConditions();
        if (this$generalConditions == null ? other$generalConditions != null : !((Object)this$generalConditions).equals(other$generalConditions)) {
            return false;
        }
        Boolean this$useAutoFetch = this.getUseAutoFetch();
        Boolean other$useAutoFetch = other.getUseAutoFetch();
        if (this$useAutoFetch == null ? other$useAutoFetch != null : !((Object)this$useAutoFetch).equals(other$useAutoFetch)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$crossId = this.getCrossId();
        String other$crossId = other.getCrossId();
        if (this$crossId == null ? other$crossId != null : !this$crossId.equals(other$crossId)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        ReferenceType this$referenceType = this.getReferenceType();
        ReferenceType other$referenceType = other.getReferenceType();
        if (this$referenceType == null ? other$referenceType != null : !((Object)((Object)this$referenceType)).equals((Object)other$referenceType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$lastContributor = this.getLastContributor();
        String other$lastContributor = other.getLastContributor();
        if (this$lastContributor == null ? other$lastContributor != null : !this$lastContributor.equals(other$lastContributor)) {
            return false;
        }
        Visibility this$visibility = this.getVisibility();
        Visibility other$visibility = other.getVisibility();
        if (this$visibility == null ? other$visibility != null : !((Object)((Object)this$visibility)).equals((Object)other$visibility)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        Set<AccessControl> this$accessControls = this.getAccessControls();
        Set<AccessControl> other$accessControls = other.getAccessControls();
        if (this$accessControls == null ? other$accessControls != null : !((Object)this$accessControls).equals(other$accessControls)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        PageSource this$source = this.getSource();
        PageSource other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        Map<String, String> this$configuration = this.getConfiguration();
        Map<String, String> other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        List<PageMedia> this$attachedMedia = this.getAttachedMedia();
        List<PageMedia> other$attachedMedia = other.getAttachedMedia();
        return !(this$attachedMedia == null ? other$attachedMedia != null : !((Object)this$attachedMedia).equals(other$attachedMedia));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOrder();
        result = result * 59 + (this.isPublished() ? 79 : 97);
        result = result * 59 + (this.isExcludedAccessControls() ? 79 : 97);
        result = result * 59 + (this.isHomepage() ? 79 : 97);
        result = result * 59 + (this.isIngested() ? 79 : 97);
        Boolean $hidden = this.getHidden();
        result = result * 59 + ($hidden == null ? 43 : ((Object)$hidden).hashCode());
        Boolean $generalConditions = this.getGeneralConditions();
        result = result * 59 + ($generalConditions == null ? 43 : ((Object)$generalConditions).hashCode());
        Boolean $useAutoFetch = this.getUseAutoFetch();
        result = result * 59 + ($useAutoFetch == null ? 43 : ((Object)$useAutoFetch).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $crossId = this.getCrossId();
        result = result * 59 + ($crossId == null ? 43 : $crossId.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        ReferenceType $referenceType = this.getReferenceType();
        result = result * 59 + ($referenceType == null ? 43 : ((Object)((Object)$referenceType)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $lastContributor = this.getLastContributor();
        result = result * 59 + ($lastContributor == null ? 43 : $lastContributor.hashCode());
        Visibility $visibility = this.getVisibility();
        result = result * 59 + ($visibility == null ? 43 : ((Object)((Object)$visibility)).hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        Set<AccessControl> $accessControls = this.getAccessControls();
        result = result * 59 + ($accessControls == null ? 43 : ((Object)$accessControls).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        PageSource $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        Map<String, String> $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        List<PageMedia> $attachedMedia = this.getAttachedMedia();
        result = result * 59 + ($attachedMedia == null ? 43 : ((Object)$attachedMedia).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Page(id=" + this.getId() + ", crossId=" + this.getCrossId() + ", referenceId=" + this.getReferenceId() + ", referenceType=" + String.valueOf((Object)this.getReferenceType()) + ", name=" + this.getName() + ", type=" + String.valueOf((Object)this.getType()) + ", lastContributor=" + this.getLastContributor() + ", order=" + this.getOrder() + ", published=" + this.isPublished() + ", visibility=" + String.valueOf((Object)this.getVisibility()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", parentId=" + this.getParentId() + ", excludedAccessControls=" + this.isExcludedAccessControls() + ", accessControls=" + String.valueOf(this.getAccessControls()) + ", hidden=" + this.getHidden() + ", content=" + this.getContent() + ", homepage=" + this.isHomepage() + ", generalConditions=" + this.getGeneralConditions() + ", source=" + String.valueOf(this.getSource()) + ", configuration=" + String.valueOf(this.getConfiguration()) + ", metadata=" + String.valueOf(this.getMetadata()) + ", useAutoFetch=" + this.getUseAutoFetch() + ", attachedMedia=" + String.valueOf(this.getAttachedMedia()) + ", ingested=" + this.isIngested() + ")";
    }

    @Generated
    public Page() {
    }

    @Generated
    public Page(String id, String crossId, String referenceId, ReferenceType referenceType, String name, Type type, String lastContributor, int order, boolean published, Visibility visibility, Date createdAt, Date updatedAt, String parentId, boolean excludedAccessControls, Set<AccessControl> accessControls, Boolean hidden, String content, boolean homepage, Boolean generalConditions, PageSource source, Map<String, String> configuration, Map<String, String> metadata, Boolean useAutoFetch, List<PageMedia> attachedMedia, boolean ingested) {
        this.id = id;
        this.crossId = crossId;
        this.referenceId = referenceId;
        this.referenceType = referenceType;
        this.name = name;
        this.type = type;
        this.lastContributor = lastContributor;
        this.order = order;
        this.published = published;
        this.visibility = visibility;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.parentId = parentId;
        this.excludedAccessControls = excludedAccessControls;
        this.accessControls = accessControls;
        this.hidden = hidden;
        this.content = content;
        this.homepage = homepage;
        this.generalConditions = generalConditions;
        this.source = source;
        this.configuration = configuration;
        this.metadata = metadata;
        this.useAutoFetch = useAutoFetch;
        this.attachedMedia = attachedMedia;
        this.ingested = ingested;
    }

    @Generated
    public Page withHidden(Boolean hidden) {
        return this.hidden == hidden ? this : new Page(this.id, this.crossId, this.referenceId, this.referenceType, this.name, this.type, this.lastContributor, this.order, this.published, this.visibility, this.createdAt, this.updatedAt, this.parentId, this.excludedAccessControls, this.accessControls, hidden, this.content, this.homepage, this.generalConditions, this.source, this.configuration, this.metadata, this.useAutoFetch, this.attachedMedia, this.ingested);
    }

    @Generated
    public Page withGeneralConditions(Boolean generalConditions) {
        return this.generalConditions == generalConditions ? this : new Page(this.id, this.crossId, this.referenceId, this.referenceType, this.name, this.type, this.lastContributor, this.order, this.published, this.visibility, this.createdAt, this.updatedAt, this.parentId, this.excludedAccessControls, this.accessControls, this.hidden, this.content, this.homepage, generalConditions, this.source, this.configuration, this.metadata, this.useAutoFetch, this.attachedMedia, this.ingested);
    }

    public static enum Type {
        FOLDER,
        MARKDOWN,
        ASCIIDOC,
        ASYNCAPI,
        LINK,
        MARKDOWN_TEMPLATE,
        ROOT,
        SWAGGER,
        SYSTEM_FOLDER,
        TRANSLATION;

    }

    @Generated
    public static class PageBuilder {
        @Generated
        private String id;
        @Generated
        private String crossId;
        @Generated
        private String referenceId;
        @Generated
        private ReferenceType referenceType;
        @Generated
        private String name;
        @Generated
        private Type type;
        @Generated
        private String lastContributor;
        @Generated
        private int order;
        @Generated
        private boolean published;
        @Generated
        private Visibility visibility;
        @Generated
        private Date createdAt;
        @Generated
        private Date updatedAt;
        @Generated
        private String parentId;
        @Generated
        private boolean excludedAccessControls;
        @Generated
        private Set<AccessControl> accessControls;
        @Generated
        private Boolean hidden;
        @Generated
        private String content;
        @Generated
        private boolean homepage;
        @Generated
        private Boolean generalConditions;
        @Generated
        private PageSource source;
        @Generated
        private Map<String, String> configuration;
        @Generated
        private Map<String, String> metadata;
        @Generated
        private Boolean useAutoFetch;
        @Generated
        private List<PageMedia> attachedMedia;
        @Generated
        private boolean ingested;

        @Generated
        PageBuilder() {
        }

        @Generated
        public PageBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public PageBuilder crossId(String crossId) {
            this.crossId = crossId;
            return this;
        }

        @Generated
        public PageBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @Generated
        public PageBuilder referenceType(ReferenceType referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @Generated
        public PageBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public PageBuilder type(Type type) {
            this.type = type;
            return this;
        }

        @Generated
        public PageBuilder lastContributor(String lastContributor) {
            this.lastContributor = lastContributor;
            return this;
        }

        @Generated
        public PageBuilder order(int order) {
            this.order = order;
            return this;
        }

        @Generated
        public PageBuilder published(boolean published) {
            this.published = published;
            return this;
        }

        @Generated
        public PageBuilder visibility(Visibility visibility) {
            this.visibility = visibility;
            return this;
        }

        @Generated
        public PageBuilder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public PageBuilder updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Generated
        public PageBuilder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        @Generated
        public PageBuilder excludedAccessControls(boolean excludedAccessControls) {
            this.excludedAccessControls = excludedAccessControls;
            return this;
        }

        @Generated
        public PageBuilder accessControls(Set<AccessControl> accessControls) {
            this.accessControls = accessControls;
            return this;
        }

        @Generated
        public PageBuilder hidden(Boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        @Generated
        public PageBuilder content(String content) {
            this.content = content;
            return this;
        }

        @Generated
        public PageBuilder homepage(boolean homepage) {
            this.homepage = homepage;
            return this;
        }

        @Generated
        public PageBuilder generalConditions(Boolean generalConditions) {
            this.generalConditions = generalConditions;
            return this;
        }

        @Generated
        public PageBuilder source(PageSource source) {
            this.source = source;
            return this;
        }

        @Generated
        public PageBuilder configuration(Map<String, String> configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public PageBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public PageBuilder useAutoFetch(Boolean useAutoFetch) {
            this.useAutoFetch = useAutoFetch;
            return this;
        }

        @Generated
        public PageBuilder attachedMedia(List<PageMedia> attachedMedia) {
            this.attachedMedia = attachedMedia;
            return this;
        }

        @Generated
        public PageBuilder ingested(boolean ingested) {
            this.ingested = ingested;
            return this;
        }

        @Generated
        public Page build() {
            return new Page(this.id, this.crossId, this.referenceId, this.referenceType, this.name, this.type, this.lastContributor, this.order, this.published, this.visibility, this.createdAt, this.updatedAt, this.parentId, this.excludedAccessControls, this.accessControls, this.hidden, this.content, this.homepage, this.generalConditions, this.source, this.configuration, this.metadata, this.useAutoFetch, this.attachedMedia, this.ingested);
        }

        @Generated
        public String toString() {
            return "Page.PageBuilder(id=" + this.id + ", crossId=" + this.crossId + ", referenceId=" + this.referenceId + ", referenceType=" + String.valueOf((Object)this.referenceType) + ", name=" + this.name + ", type=" + String.valueOf((Object)this.type) + ", lastContributor=" + this.lastContributor + ", order=" + this.order + ", published=" + this.published + ", visibility=" + String.valueOf((Object)this.visibility) + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", parentId=" + this.parentId + ", excludedAccessControls=" + this.excludedAccessControls + ", accessControls=" + String.valueOf(this.accessControls) + ", hidden=" + this.hidden + ", content=" + this.content + ", homepage=" + this.homepage + ", generalConditions=" + this.generalConditions + ", source=" + String.valueOf(this.source) + ", configuration=" + String.valueOf(this.configuration) + ", metadata=" + String.valueOf(this.metadata) + ", useAutoFetch=" + this.useAutoFetch + ", attachedMedia=" + String.valueOf(this.attachedMedia) + ", ingested=" + this.ingested + ")";
        }
    }

    public static enum ReferenceType {
        ENVIRONMENT,
        API;

    }

    public static enum Visibility {
        PUBLIC,
        PRIVATE;

    }
}

