/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics.model.ResponseStatusOvertime;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.exception.ApiInvalidDefinitionVersionException;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.exception.TcpProxyNotSupportedException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.utils.DurationUtils;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class SearchResponseStatusOverTimeUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchResponseStatusOverTimeUseCase.class);
    private final AnalyticsQueryService analyticsQueryService;
    private final ApiCrudService apiCrudService;

    public Output execute(ExecutionContext executionContext, Input input) {
        Api api = this.validateApiRequirements(input);
        Duration interval = DurationUtils.buildIntervalFromTimePeriod(input.from(), input.to());
        ResponseStatusOvertime result = this.analyticsQueryService.searchResponseStatusOvertime(executionContext, new AnalyticsQueryService.ResponseStatusOverTimeQuery(List.of(api.getId()), input.from(), input.to(), interval, List.of(api.getDefinitionVersion())));
        return new Output(result);
    }

    private Api validateApiRequirements(Input input) {
        Api api = this.apiCrudService.get(input.apiId);
        SearchResponseStatusOverTimeUseCase.validateApiDefinitionVersion(api.getDefinitionVersion(), input.apiId);
        SearchResponseStatusOverTimeUseCase.validateApiMultiTenancyAccess(api, input.environmentId);
        this.validateApiIsNotTcp(api);
        return api;
    }

    private void validateApiIsNotTcp(Api api) {
        if (api.getApiDefinitionHttpV4().isTcpProxy()) {
            throw new TcpProxyNotSupportedException(api.getId());
        }
    }

    private static void validateApiMultiTenancyAccess(Api api, String environmentId) {
        if (!api.belongsToEnvironment(environmentId)) {
            throw new ApiNotFoundException(api.getId());
        }
    }

    private static void validateApiDefinitionVersion(DefinitionVersion definitionVersion, String apiId) {
        if (!DefinitionVersion.V4.equals((Object)definitionVersion)) {
            throw new ApiInvalidDefinitionVersionException(apiId);
        }
    }

    @Generated
    public SearchResponseStatusOverTimeUseCase(AnalyticsQueryService analyticsQueryService, ApiCrudService apiCrudService) {
        this.analyticsQueryService = analyticsQueryService;
        this.apiCrudService = apiCrudService;
    }

    public record Input(String apiId, String environmentId, Instant from, Instant to) {
    }

    public record Output(ResponseStatusOvertime responseStatusOvertime) {
    }
}

