/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.model.property;

import io.gravitee.definition.model.v4.property.Property;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DynamicApiProperties {
    final Map<String, Property> currentPropertiesByKey;
    private final List<Property> currentUserDefinedProperties;

    public DynamicApiProperties(List<Property> currentProperties) {
        this.currentPropertiesByKey = currentProperties.stream().collect(Collectors.toMap(Property::getKey, Function.identity()));
        this.currentUserDefinedProperties = currentProperties.stream().filter(Predicate.not(Property::isDynamic)).toList();
    }

    public DynamicPropertiesResult updateDynamicProperties(List<Property> dynamicProperties) {
        ArrayList updatedDynamicProperties = new ArrayList();
        AtomicBoolean needToBeSaved = new AtomicBoolean(false);
        dynamicProperties.forEach(dynamicProperty -> {
            Property existingMatchingProperty = this.currentPropertiesByKey.get(dynamicProperty.getKey());
            if (DynamicApiProperties.isNewProperty(existingMatchingProperty) || existingMatchingProperty.isDynamic()) {
                updatedDynamicProperties.add(dynamicProperty);
                needToBeSaved.compareAndSet(false, DynamicApiProperties.isNewProperty(existingMatchingProperty) || DynamicApiProperties.isUpdatingPreviousProperty(dynamicProperty, existingMatchingProperty));
            }
        });
        List<Property> orderedProperties = Stream.concat(this.currentUserDefinedProperties.stream(), updatedDynamicProperties.stream()).sorted(Comparator.comparing(Property::getKey)).toList();
        return new DynamicPropertiesResult(orderedProperties, needToBeSaved.get());
    }

    private static boolean isNewProperty(Property previousProperty) {
        return previousProperty == null;
    }

    private static boolean isUpdatingPreviousProperty(Property newProperty, Property previousProperty) {
        return !newProperty.getValue().equals(previousProperty.getValue());
    }

    public record DynamicPropertiesResult(List<Property> orderedProperties, boolean needToUpdate) {
    }
}

