/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.common.data.domain.Page;
import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.node.api.upgrader.UpgraderException;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.IntegrationRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.RoleRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.repository.management.model.Integration;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipMemberType;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.Role;
import io.gravitee.repository.management.model.RoleReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class IntegrationPrimaryOwnerUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrationPrimaryOwnerUpgrader.class);
    private static final int PAGE_SIZE = 100;
    private static final String DEFAULT_SOURCE = "system";
    private final EnvironmentRepository environmentRepository;
    private IntegrationRepository integrationRepository;
    private final ApiRepository apiRepository;
    private final MembershipRepository membershipRepository;
    private final RoleRepository roleRepository;

    @Autowired
    public IntegrationPrimaryOwnerUpgrader(@Lazy EnvironmentRepository environmentRepository, @Lazy IntegrationRepository integrationRepository, @Lazy ApiRepository apiRepository, @Lazy MembershipRepository membershipRepository, @Lazy RoleRepository roleRepository) {
        this.environmentRepository = environmentRepository;
        this.integrationRepository = integrationRepository;
        this.apiRepository = apiRepository;
        this.membershipRepository = membershipRepository;
        this.roleRepository = roleRepository;
    }

    public boolean upgrade() throws UpgraderException {
        return this.wrapException(this::applyUpgrade);
    }

    private boolean applyUpgrade() throws TechnicalException {
        this.environmentRepository.findAll().forEach(environment -> {
            ExecutionContext executionContext = new ExecutionContext((Environment)environment);
            try {
                this.setPrimaryOwnersForIntegrations(executionContext);
            }
            catch (TechnicalException e) {
                log.error("An error occurs while updating primary owner for integrations", (Throwable)e);
            }
        });
        return true;
    }

    private void setPrimaryOwnersForIntegrations(ExecutionContext executionContext) throws TechnicalException {
        Page integrationPage;
        log.info("Start to set primary owners for integrations");
        int handledIntegrations = 0;
        do {
            integrationPage = this.integrationRepository.findAllByEnvironment(executionContext.getEnvironmentId(), new PageableBuilder().pageNumber(handledIntegrations / 100).pageSize(100).build());
            this.setPrimaryOwnersForIntegrations((Page<Integration>)integrationPage, executionContext);
        } while ((long)(handledIntegrations += (int)integrationPage.getPageElements()) < integrationPage.getTotalElements());
        log.info("Finish to set primary owners for integrations");
    }

    private void setPrimaryOwnersForIntegrations(Page<Integration> integrationPage, ExecutionContext executionContext) {
        log.info("Migrating page: {} of integrations", (Object)integrationPage.getPageNumber());
        ArrayList<String> integrationsIdsWithNoApis = new ArrayList<String>();
        integrationPage.getContent().stream().map(Integration::getId).forEach(id -> this.findAssociatedApis((String)id).findFirst().ifPresentOrElse(api -> this.setPrimaryOwnerForIntegration((Api)api, (String)id, executionContext), () -> integrationsIdsWithNoApis.add((String)id)));
        if (!integrationsIdsWithNoApis.isEmpty()) {
            log.info("Integrations with no associated APIs have been found and will be deleted");
            this.deleteIntegrationWithNoApiIngested(integrationsIdsWithNoApis);
        }
    }

    private void deleteIntegrationWithNoApiIngested(List<String> integrationIds) {
        log.info("List of Integrations to delete: {}", integrationIds);
        integrationIds.forEach(id -> {
            try {
                this.integrationRepository.delete(id);
            }
            catch (TechnicalException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void setPrimaryOwnerForIntegration(Api api, String integrationId, ExecutionContext executionContext) {
        log.info("Set primary owner for integration {} inherited from API {}", (Object)integrationId, (Object)api.getId());
        try {
            String apiPrimaryOwnerRoleId = this.findPrimaryOwnerRoleId(executionContext.getOrganizationId(), RoleScope.API);
            String integrationPrimaryOwnerRoleId = this.findPrimaryOwnerRoleId(executionContext.getOrganizationId(), RoleScope.INTEGRATION);
            Membership membership = this.findPrimaryOwnerMembership(apiPrimaryOwnerRoleId, List.of(api.getId())).map(m -> IntegrationPrimaryOwnerUpgrader.integrationMembership(m.getMemberId(), m.getMemberType(), integrationPrimaryOwnerRoleId, integrationId)).orElseThrow(() -> new TechnicalException("No membership found"));
            this.membershipRepository.create(membership);
        }
        catch (TechnicalException e) {
            throw new RuntimeException(e);
        }
    }

    private String findPrimaryOwnerRoleId(String organizationId, RoleScope roleScope) throws TechnicalException {
        return this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(roleScope, SystemRole.PRIMARY_OWNER.name(), organizationId, RoleReferenceType.ORGANIZATION).map(Role::getId).orElseThrow(() -> new TechnicalException("Unable to find " + String.valueOf(roleScope) + " Primary Owner role for organization: " + organizationId));
    }

    private Stream<Api> findAssociatedApis(String integrationId) {
        ApiCriteria searchCriteria = new ApiCriteria.Builder().integrationId(integrationId).build();
        ApiFieldFilter fieldFilter = new ApiFieldFilter.Builder().excludeDefinition().excludePicture().build();
        return this.apiRepository.search(searchCriteria, fieldFilter).stream();
    }

    private Optional<Membership> findPrimaryOwnerMembership(String apiPrimaryOwnerRoleId, List<String> apiIds) throws TechnicalException {
        return this.membershipRepository.findByReferencesAndRoleId(MembershipReferenceType.API, apiIds, apiPrimaryOwnerRoleId).stream().findFirst();
    }

    private static Membership integrationMembership(String memberId, MembershipMemberType memberType, String roleId, String integrationId) {
        Membership membership = new Membership(UuidString.generateRandom(), memberId, memberType, integrationId, MembershipReferenceType.INTEGRATION, roleId);
        Date now = new Date();
        membership.setCreatedAt(now);
        membership.setUpdatedAt(now);
        membership.setSource(DEFAULT_SOURCE);
        return membership;
    }

    public int getOrder() {
        return 703;
    }
}

