/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.shared_policy_group.exception;

import io.gravitee.rest.api.service.exceptions.AbstractNotFoundException;
import java.util.Map;

public class SharedPolicyGroupDuplicateCrossIdException
extends AbstractNotFoundException {
    private final String sharedPolicyGroupId;
    private final String environmentId;

    public SharedPolicyGroupDuplicateCrossIdException(String sharedPolicyGroupId, String environmentId) {
        this.sharedPolicyGroupId = sharedPolicyGroupId;
        this.environmentId = environmentId;
    }

    @Override
    public String getMessage() {
        return String.format("SharedPolicyGroup with crossId [%s] already exists for environment [%s].", this.sharedPolicyGroupId, this.environmentId);
    }

    @Override
    public String getTechnicalCode() {
        return "sharedPolicyGroup.duplicateCrossId";
    }

    @Override
    public Map<String, String> getParameters() {
        return Map.of("sharedPolicyGroupId", this.sharedPolicyGroupId, "environmentId", this.environmentId);
    }
}

