/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.apim.core.access_point.query_service.AccessPointQueryService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import io.gravitee.definition.model.v4.listener.tcp.TcpListener;
import io.gravitee.definition.model.v4.nativeapi.kafka.KafkaListener;
import io.gravitee.rest.api.model.EntrypointEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiEntrypointEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.nativeapi.NativeApiEntity;
import io.gravitee.rest.api.service.EntrypointService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.EntrypointNotFoundException;
import io.gravitee.rest.api.service.v4.ApiEntrypointService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiEntrypointServiceImpl
implements ApiEntrypointService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiEntrypointServiceImpl.class);
    private static final Pattern DUPLICATE_SLASH_REMOVER = Pattern.compile("(?<!(http:|https:))[//]+");
    private static final String URI_PATH_SEPARATOR = "/";
    public static final Set<DefinitionVersion> APIS_WITHOUT_ENTRYPOINT = EnumSet.of(DefinitionVersion.FEDERATED, DefinitionVersion.FEDERATED_AGENT);
    private final ParameterService parameterService;
    private final EntrypointService entrypointService;
    private final AccessPointQueryService accessPointQueryService;

    public ApiEntrypointServiceImpl(ParameterService parameterService, EntrypointService entrypointService, AccessPointQueryService accessPointQueryService) {
        this.parameterService = parameterService;
        this.entrypointService = entrypointService;
        this.accessPointQueryService = accessPointQueryService;
    }

    @Override
    public List<ApiEntrypointEntity> getApiEntrypoints(ExecutionContext executionContext, GenericApiEntity genericApiEntity) {
        ArrayList<ApiEntrypointEntity> apiEntrypoints = new ArrayList<ApiEntrypointEntity>();
        if (APIS_WITHOUT_ENTRYPOINT.contains(genericApiEntity.getDefinitionVersion())) {
            return apiEntrypoints;
        }
        String defaultTcpPort = this.parameterService.find(executionContext, Key.PORTAL_TCP_PORT, executionContext.getEnvironmentId(), ParameterReferenceType.ENVIRONMENT);
        String defaultKafkaDomain = this.parameterService.find(executionContext, Key.PORTAL_KAFKA_DOMAIN, executionContext.getEnvironmentId(), ParameterReferenceType.ENVIRONMENT);
        String defaultKafkaPort = this.parameterService.find(executionContext, Key.PORTAL_KAFKA_PORT, executionContext.getEnvironmentId(), ParameterReferenceType.ENVIRONMENT);
        if (genericApiEntity.getTags() != null && !genericApiEntity.getTags().isEmpty()) {
            List<EntrypointEntity> organizationEntrypoints = this.entrypointService.findAll(executionContext);
            organizationEntrypoints.forEach(entrypoint -> {
                String entrypointValue;
                boolean isEntrypointMatching = Arrays.stream(entrypoint.getTags()).allMatch(tag -> genericApiEntity.getTags().stream().toList().contains(tag));
                if (!isEntrypointMatching) {
                    return;
                }
                if (entrypoint.getTarget() != this.getApiTarget(genericApiEntity)) {
                    return;
                }
                apiEntrypoints.addAll(this.getEntrypoints(genericApiEntity, entrypointValue, defaultTcpPort, (entrypointValue = entrypoint.getValue()).lastIndexOf(":") > 0 ? entrypointValue.substring(0, entrypointValue.lastIndexOf(":")) : defaultKafkaDomain, entrypointValue.lastIndexOf(":") > 0 ? entrypointValue.substring(entrypointValue.lastIndexOf(":") + 1) : defaultKafkaPort, genericApiEntity.getTags(), executionContext.getEnvironmentId()));
            });
        }
        if (apiEntrypoints.isEmpty()) {
            String defaultEntrypoint = this.parameterService.find(executionContext, Key.PORTAL_ENTRYPOINT, executionContext.getEnvironmentId(), ParameterReferenceType.ENVIRONMENT);
            apiEntrypoints.addAll(this.getEntrypoints(genericApiEntity, defaultEntrypoint, defaultTcpPort, defaultKafkaDomain, defaultKafkaPort, null, executionContext.getEnvironmentId()));
        }
        return apiEntrypoints;
    }

    private List<ApiEntrypointEntity> getEntrypoints(GenericApiEntity genericApiEntity, String entrypointValue, String tcpPort, String kafkaDomain, String kafkaPort, Set<String> tagEntrypoints, String environmentId) {
        if (genericApiEntity.getDefinitionVersion() != DefinitionVersion.V4) {
            ApiEntity api = (ApiEntity)genericApiEntity;
            return api.getProxy().getVirtualHosts().stream().flatMap(virtualHost -> this.getHttpApiEntrypointEntity(entrypointValue, virtualHost.getHost(), virtualHost.getPath(), virtualHost.isOverrideEntrypoint(), tagEntrypoints, environmentId).stream()).toList();
        }
        if (genericApiEntity.getDefinitionVersion() == DefinitionVersion.V4 && genericApiEntity instanceof NativeApiEntity) {
            NativeApiEntity api = (NativeApiEntity)genericApiEntity;
            return api.getListeners().stream().filter(listener -> listener instanceof KafkaListener).flatMap(listener -> {
                KafkaListener kafkaListener = (KafkaListener)listener;
                return this.getKafkaNativeApiEntrypointEntity(kafkaListener.getHost(), kafkaDomain, kafkaPort, tagEntrypoints, environmentId).stream();
            }).toList();
        }
        io.gravitee.rest.api.model.v4.api.ApiEntity api = (io.gravitee.rest.api.model.v4.api.ApiEntity)genericApiEntity;
        return api.getListeners().stream().flatMap(listener -> {
            if (listener instanceof HttpListener) {
                HttpListener httpListener = (HttpListener)listener;
                return httpListener.getPaths().stream().flatMap(path -> this.getHttpApiEntrypointEntity(entrypointValue, path.getHost(), path.getPath(), path.isOverrideAccess(), tagEntrypoints, environmentId).stream());
            }
            if (listener instanceof TcpListener) {
                TcpListener tcpListener = (TcpListener)listener;
                return tcpListener.getHosts().stream().map(tcpHost -> this.getTcpApiEntrypointEntity((String)tcpHost, tcpPort, entrypointValue, tagEntrypoints));
            }
            return Stream.empty();
        }).toList();
    }

    private List<ApiEntrypointEntity> getHttpApiEntrypointEntity(String entrypointHost, String host, String path, boolean isOverride, Set<String> tags, String environmentId) {
        String defaultScheme = this.getScheme(entrypointHost);
        ArrayList<ApiEntrypointEntity> entrypoints = new ArrayList<ApiEntrypointEntity>();
        if (host == null || !isOverride) {
            List<AccessPoint> accessPoints = this.accessPointQueryService.getGatewayAccessPoints(environmentId);
            if (accessPoints.isEmpty() || tags != null && !tags.isEmpty()) {
                entrypoints.add(this.createHttpApiEntrypointEntity(defaultScheme, entrypointHost, path, tags, host));
            } else {
                for (AccessPoint accessPoint : accessPoints) {
                    String targetHost = accessPoint.getHost();
                    String scheme = accessPoint.isSecured() ? "https" : "http";
                    entrypoints.add(this.createHttpApiEntrypointEntity(scheme, targetHost, path, tags, targetHost));
                }
            }
        } else {
            entrypoints.add(this.createHttpApiEntrypointEntity(defaultScheme, host, path, tags, host));
        }
        return entrypoints;
    }

    ApiEntrypointEntity createHttpApiEntrypointEntity(String defaultScheme, String host, String path, Set<String> tags, String originalHost) {
        String url;
        if (!((String)host).toLowerCase().startsWith("http")) {
            host = defaultScheme + "://" + (String)host;
        }
        if ((url = DUPLICATE_SLASH_REMOVER.matcher((String)host + URI_PATH_SEPARATOR + path).replaceAll(URI_PATH_SEPARATOR)).endsWith(URI_PATH_SEPARATOR)) {
            url = url.substring(0, url.length() - URI_PATH_SEPARATOR.length());
        }
        return new ApiEntrypointEntity(tags, url, originalHost);
    }

    private ApiEntrypointEntity getTcpApiEntrypointEntity(String tcpHost, String tcpPort, String host, Set<String> tags) {
        String target = String.join((CharSequence)":", tcpHost, tcpPort);
        return new ApiEntrypointEntity(tags, target, host);
    }

    private List<ApiEntrypointEntity> getKafkaNativeApiEntrypointEntity(String host, String domain, String port, Set<String> tags, String environmentId) {
        ArrayList<ApiEntrypointEntity> entrypoints = new ArrayList<ApiEntrypointEntity>();
        List<AccessPoint> accessPoints = this.accessPointQueryService.getKafkaGatewayAccessPoints(environmentId);
        if (accessPoints.isEmpty() || tags != null && !tags.isEmpty()) {
            entrypoints.add(this.createKafkaNativeApiEntrypointEntity(host, domain, port, tags));
        } else {
            for (AccessPoint accessPoint : accessPoints) {
                String accessPointDomain = accessPoint.getHost();
                String targetDomain = accessPointDomain.contains(":") ? accessPointDomain.substring(0, accessPointDomain.indexOf(":")) : accessPointDomain;
                String targetPort = accessPointDomain.contains(":") ? accessPointDomain.substring(accessPointDomain.indexOf(":") + 1) : port;
                entrypoints.add(this.createKafkaNativeApiEntrypointEntity(host, targetDomain, targetPort, tags));
            }
        }
        return entrypoints;
    }

    private ApiEntrypointEntity createKafkaNativeApiEntrypointEntity(String host, String domain, String port, Set<String> tags) {
        Object kafkaDomain = domain == null || domain.isBlank() ? host : (domain.contains("{apiHost}") ? domain.replace("{apiHost}", host) : host + "." + domain);
        String target = (String)kafkaDomain + ":" + port;
        return new ApiEntrypointEntity(tags, target, host);
    }

    private String getScheme(String entrypointValue) {
        String scheme = "https";
        if (entrypointValue != null) {
            try {
                scheme = new URL(entrypointValue).getProtocol();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return scheme;
    }

    @Override
    public String getApiEntrypointsListenerType(GenericApiEntity genericApiEntity) {
        if (genericApiEntity.getDefinitionVersion() == DefinitionVersion.V1 || genericApiEntity.getDefinitionVersion() == DefinitionVersion.V2) {
            return "HTTP";
        }
        if (genericApiEntity instanceof NativeApiEntity) {
            NativeApiEntity api = (NativeApiEntity)genericApiEntity;
            return api.getListeners().stream().findFirst().map(listener -> listener.getType().toString()).orElseThrow(() -> new EntrypointNotFoundException(api.getId()));
        }
        io.gravitee.rest.api.model.v4.api.ApiEntity api = (io.gravitee.rest.api.model.v4.api.ApiEntity)genericApiEntity;
        return api.getListeners().stream().findFirst().map(listener -> listener.getType().toString()).orElseThrow(() -> new EntrypointNotFoundException(api.getId()));
    }

    private EntrypointEntity.Target getApiTarget(GenericApiEntity genericApiEntity) {
        NativeApiEntity nativeApiEntity;
        if (genericApiEntity.getDefinitionVersion() != DefinitionVersion.V4) {
            return EntrypointEntity.Target.HTTP;
        }
        if (genericApiEntity instanceof NativeApiEntity && (nativeApiEntity = (NativeApiEntity)genericApiEntity).getListeners().stream().anyMatch(listener -> listener instanceof KafkaListener)) {
            return EntrypointEntity.Target.KAFKA;
        }
        if (genericApiEntity instanceof io.gravitee.rest.api.model.v4.api.ApiEntity) {
            io.gravitee.rest.api.model.v4.api.ApiEntity apiEntity = (io.gravitee.rest.api.model.v4.api.ApiEntity)genericApiEntity;
            if (apiEntity.getListeners().stream().anyMatch(listener -> listener instanceof TcpListener)) {
                return EntrypointEntity.Target.TCP;
            }
            if (apiEntity.getListeners().stream().anyMatch(listener -> listener instanceof HttpListener)) {
                return EntrypointEntity.Target.HTTP;
            }
        }
        throw new EntrypointNotFoundException(genericApiEntity.getId());
    }
}

