/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.shared_policy_group.model;

import io.gravitee.apim.core.plugin.model.FlowPhase;
import io.gravitee.apim.core.shared_policy_group.model.CreateSharedPolicyGroup;
import io.gravitee.apim.core.shared_policy_group.model.UpdateSharedPolicyGroup;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.flow.step.Step;
import io.gravitee.definition.model.v4.sharedpolicygroup.SharedPolicyGroup;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.service.common.UuidString;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class SharedPolicyGroup {
    private String hrid;
    private String id;
    private String environmentId;
    private String organizationId;
    private String crossId;
    private String name;
    private String description;
    private String prerequisiteMessage;
    private Integer version;
    private ApiType apiType;
    private OriginContext originContext = new OriginContext.Management();
    private FlowPhase phase;
    private List<Step> steps;
    private ZonedDateTime deployedAt;
    private ZonedDateTime createdAt;
    private ZonedDateTime updatedAt;
    private SharedPolicyGroupLifecycleState lifecycleState;

    public static SharedPolicyGroupBuilder builder() {
        return new SharedPolicyGroupBuilder();
    }

    public void deploy() {
        ZonedDateTime now;
        this.lifecycleState = SharedPolicyGroupLifecycleState.DEPLOYED;
        this.version = this.version != null ? this.version + 1 : 1;
        this.deployedAt = now = TimeProvider.now();
        this.updatedAt = now;
    }

    public void undeploy() {
        ZonedDateTime now;
        this.lifecycleState = SharedPolicyGroupLifecycleState.UNDEPLOYED;
        this.deployedAt = now = TimeProvider.now();
        this.updatedAt = now;
    }

    public io.gravitee.definition.model.v4.sharedpolicygroup.SharedPolicyGroup toDefinition() {
        return io.gravitee.definition.model.v4.sharedpolicygroup.SharedPolicyGroup.builder().id(this.crossId).environmentId(this.environmentId).policies(this.steps).phase(SharedPolicyGroup.Phase.valueOf((String)this.phase.name())).name(this.name).deployedAt(Date.from(this.deployedAt.toInstant())).build();
    }

    public SharedPolicyGroupBuilder toBuilder() {
        return new SharedPolicyGroupBuilder().id(this.id).hrid(this.hrid).environmentId(this.environmentId).organizationId(this.organizationId).crossId(this.crossId).name(this.name).description(this.description).prerequisiteMessage(this.prerequisiteMessage).version(this.version).apiType(this.apiType).originContext(this.originContext).phase(this.phase).steps(this.steps).deployedAt(this.deployedAt).createdAt(this.createdAt).updatedAt(this.updatedAt).lifecycleState(this.lifecycleState);
    }

    public static SharedPolicyGroup from(CreateSharedPolicyGroup createSharedPolicyGroup) {
        return SharedPolicyGroup.builder().hrid(createSharedPolicyGroup.getHrid()).crossId(createSharedPolicyGroup.getCrossId() == null ? UuidString.generateRandom() : createSharedPolicyGroup.getCrossId()).name(createSharedPolicyGroup.getName()).description(createSharedPolicyGroup.getDescription()).prerequisiteMessage(createSharedPolicyGroup.getPrerequisiteMessage()).apiType(createSharedPolicyGroup.getApiType()).originContext(createSharedPolicyGroup.getOriginContext()).phase(createSharedPolicyGroup.getPhase()).steps(Optional.ofNullable(createSharedPolicyGroup.getSteps()).orElse(Collections.emptyList())).build();
    }

    public SharedPolicyGroup update(UpdateSharedPolicyGroup updateSharedPolicyGroup) {
        return this.toBuilder().hrid(updateSharedPolicyGroup.getHrid()).crossId(updateSharedPolicyGroup.getCrossId() == null ? this.getCrossId() : updateSharedPolicyGroup.getCrossId()).name(updateSharedPolicyGroup.getName() == null ? this.getName() : updateSharedPolicyGroup.getName()).description(updateSharedPolicyGroup.getDescription() == null ? this.getDescription() : updateSharedPolicyGroup.getDescription()).prerequisiteMessage(updateSharedPolicyGroup.getPrerequisiteMessage() == null ? this.getPrerequisiteMessage() : updateSharedPolicyGroup.getPrerequisiteMessage()).steps(updateSharedPolicyGroup.getSteps() == null ? this.getSteps() : updateSharedPolicyGroup.getSteps()).updatedAt(TimeProvider.now()).lifecycleState(this.lifecycleState == SharedPolicyGroupLifecycleState.DEPLOYED ? SharedPolicyGroupLifecycleState.PENDING : this.lifecycleState).build();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean isDeployed() {
        return this.lifecycleState == SharedPolicyGroupLifecycleState.DEPLOYED;
    }

    public boolean hasValidPhase() {
        if (this.apiType == ApiType.PROXY) {
            return this.phase == FlowPhase.REQUEST || this.phase == FlowPhase.RESPONSE;
        }
        if (this.apiType == ApiType.MESSAGE) {
            return this.phase == FlowPhase.REQUEST || this.phase == FlowPhase.RESPONSE || this.phase == FlowPhase.PUBLISH || this.phase == FlowPhase.SUBSCRIBE;
        }
        return false;
    }

    @Generated
    public String getHrid() {
        return this.hrid;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Generated
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public String getCrossId() {
        return this.crossId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getPrerequisiteMessage() {
        return this.prerequisiteMessage;
    }

    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @Generated
    public ApiType getApiType() {
        return this.apiType;
    }

    @Generated
    public OriginContext getOriginContext() {
        return this.originContext;
    }

    @Generated
    public FlowPhase getPhase() {
        return this.phase;
    }

    @Generated
    public List<Step> getSteps() {
        return this.steps;
    }

    @Generated
    public ZonedDateTime getDeployedAt() {
        return this.deployedAt;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public SharedPolicyGroupLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    @Generated
    public void setHrid(String hrid) {
        this.hrid = hrid;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Generated
    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    @Generated
    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setPrerequisiteMessage(String prerequisiteMessage) {
        this.prerequisiteMessage = prerequisiteMessage;
    }

    @Generated
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Generated
    public void setApiType(ApiType apiType) {
        this.apiType = apiType;
    }

    @Generated
    public void setOriginContext(OriginContext originContext) {
        this.originContext = originContext;
    }

    @Generated
    public void setPhase(FlowPhase phase) {
        this.phase = phase;
    }

    @Generated
    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    @Generated
    public void setDeployedAt(ZonedDateTime deployedAt) {
        this.deployedAt = deployedAt;
    }

    @Generated
    public void setCreatedAt(ZonedDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(ZonedDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setLifecycleState(SharedPolicyGroupLifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SharedPolicyGroup)) {
            return false;
        }
        SharedPolicyGroup other = (SharedPolicyGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$hrid = this.getHrid();
        String other$hrid = other.getHrid();
        if (this$hrid == null ? other$hrid != null : !this$hrid.equals(other$hrid)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$environmentId = this.getEnvironmentId();
        String other$environmentId = other.getEnvironmentId();
        if (this$environmentId == null ? other$environmentId != null : !this$environmentId.equals(other$environmentId)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$crossId = this.getCrossId();
        String other$crossId = other.getCrossId();
        if (this$crossId == null ? other$crossId != null : !this$crossId.equals(other$crossId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$prerequisiteMessage = this.getPrerequisiteMessage();
        String other$prerequisiteMessage = other.getPrerequisiteMessage();
        if (this$prerequisiteMessage == null ? other$prerequisiteMessage != null : !this$prerequisiteMessage.equals(other$prerequisiteMessage)) {
            return false;
        }
        ApiType this$apiType = this.getApiType();
        ApiType other$apiType = other.getApiType();
        if (this$apiType == null ? other$apiType != null : !this$apiType.equals(other$apiType)) {
            return false;
        }
        OriginContext this$originContext = this.getOriginContext();
        OriginContext other$originContext = other.getOriginContext();
        if (this$originContext == null ? other$originContext != null : !this$originContext.equals(other$originContext)) {
            return false;
        }
        FlowPhase this$phase = this.getPhase();
        FlowPhase other$phase = other.getPhase();
        if (this$phase == null ? other$phase != null : !((Object)((Object)this$phase)).equals((Object)other$phase)) {
            return false;
        }
        List<Step> this$steps = this.getSteps();
        List<Step> other$steps = other.getSteps();
        if (this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps)) {
            return false;
        }
        ZonedDateTime this$deployedAt = this.getDeployedAt();
        ZonedDateTime other$deployedAt = other.getDeployedAt();
        if (this$deployedAt == null ? other$deployedAt != null : !((Object)this$deployedAt).equals(other$deployedAt)) {
            return false;
        }
        ZonedDateTime this$createdAt = this.getCreatedAt();
        ZonedDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        ZonedDateTime this$updatedAt = this.getUpdatedAt();
        ZonedDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        SharedPolicyGroupLifecycleState this$lifecycleState = this.getLifecycleState();
        SharedPolicyGroupLifecycleState other$lifecycleState = other.getLifecycleState();
        return !(this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SharedPolicyGroup;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $hrid = this.getHrid();
        result = result * 59 + ($hrid == null ? 43 : $hrid.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $environmentId = this.getEnvironmentId();
        result = result * 59 + ($environmentId == null ? 43 : $environmentId.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $crossId = this.getCrossId();
        result = result * 59 + ($crossId == null ? 43 : $crossId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $prerequisiteMessage = this.getPrerequisiteMessage();
        result = result * 59 + ($prerequisiteMessage == null ? 43 : $prerequisiteMessage.hashCode());
        ApiType $apiType = this.getApiType();
        result = result * 59 + ($apiType == null ? 43 : $apiType.hashCode());
        OriginContext $originContext = this.getOriginContext();
        result = result * 59 + ($originContext == null ? 43 : $originContext.hashCode());
        FlowPhase $phase = this.getPhase();
        result = result * 59 + ($phase == null ? 43 : ((Object)((Object)$phase)).hashCode());
        List<Step> $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        ZonedDateTime $deployedAt = this.getDeployedAt();
        result = result * 59 + ($deployedAt == null ? 43 : ((Object)$deployedAt).hashCode());
        ZonedDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        ZonedDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        SharedPolicyGroupLifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SharedPolicyGroup(hrid=" + this.getHrid() + ", id=" + this.getId() + ", environmentId=" + this.getEnvironmentId() + ", organizationId=" + this.getOrganizationId() + ", crossId=" + this.getCrossId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", prerequisiteMessage=" + this.getPrerequisiteMessage() + ", version=" + this.getVersion() + ", apiType=" + String.valueOf(this.getApiType()) + ", originContext=" + String.valueOf(this.getOriginContext()) + ", phase=" + String.valueOf((Object)this.getPhase()) + ", steps=" + String.valueOf(this.getSteps()) + ", deployedAt=" + String.valueOf(this.getDeployedAt()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", lifecycleState=" + String.valueOf((Object)this.getLifecycleState()) + ")";
    }

    @Generated
    public SharedPolicyGroup() {
    }

    @Generated
    public SharedPolicyGroup(String hrid, String id, String environmentId, String organizationId, String crossId, String name, String description, String prerequisiteMessage, Integer version, ApiType apiType, OriginContext originContext, FlowPhase phase, List<Step> steps, ZonedDateTime deployedAt, ZonedDateTime createdAt, ZonedDateTime updatedAt, SharedPolicyGroupLifecycleState lifecycleState) {
        this.hrid = hrid;
        this.id = id;
        this.environmentId = environmentId;
        this.organizationId = organizationId;
        this.crossId = crossId;
        this.name = name;
        this.description = description;
        this.prerequisiteMessage = prerequisiteMessage;
        this.version = version;
        this.apiType = apiType;
        this.originContext = originContext;
        this.phase = phase;
        this.steps = steps;
        this.deployedAt = deployedAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.lifecycleState = lifecycleState;
    }

    public static class SharedPolicyGroupBuilder {
        private String hrid;
        private String id;
        private String environmentId;
        private String organizationId;
        private String crossId;
        private String name;
        private String description;
        private String prerequisiteMessage;
        private Integer version;
        private ApiType apiType;
        private OriginContext originContext;
        private FlowPhase phase;
        private List<Step> steps;
        private ZonedDateTime deployedAt;
        private ZonedDateTime createdAt;
        private ZonedDateTime updatedAt;
        private SharedPolicyGroupLifecycleState lifecycleState;

        SharedPolicyGroupBuilder() {
        }

        public SharedPolicyGroupBuilder hrid(String hrid) {
            this.hrid = hrid;
            return this;
        }

        public SharedPolicyGroupBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SharedPolicyGroupBuilder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public SharedPolicyGroupBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public SharedPolicyGroupBuilder crossId(String crossId) {
            this.crossId = crossId;
            return this;
        }

        public SharedPolicyGroupBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SharedPolicyGroupBuilder description(String description) {
            this.description = description;
            return this;
        }

        public SharedPolicyGroupBuilder prerequisiteMessage(String prerequisiteMessage) {
            this.prerequisiteMessage = prerequisiteMessage;
            return this;
        }

        public SharedPolicyGroupBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public SharedPolicyGroupBuilder apiType(ApiType apiType) {
            this.apiType = apiType;
            return this;
        }

        public SharedPolicyGroupBuilder originContext(OriginContext originContext) {
            this.originContext = originContext;
            return this;
        }

        public SharedPolicyGroupBuilder phase(FlowPhase phase) {
            this.phase = phase;
            return this;
        }

        public SharedPolicyGroupBuilder steps(List<Step> steps) {
            this.steps = steps;
            return this;
        }

        public SharedPolicyGroupBuilder deployedAt(ZonedDateTime deployedAt) {
            this.deployedAt = deployedAt;
            return this;
        }

        public SharedPolicyGroupBuilder createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public SharedPolicyGroupBuilder updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public SharedPolicyGroupBuilder lifecycleState(SharedPolicyGroupLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public SharedPolicyGroup build() {
            if (this.originContext == null) {
                this.originContext = new OriginContext.Management();
            }
            return new SharedPolicyGroup(this.hrid, this.id, this.environmentId, this.organizationId, this.crossId, this.name, this.description, this.prerequisiteMessage, this.version, this.apiType, this.originContext, this.phase, this.steps, this.deployedAt, this.createdAt, this.updatedAt, this.lifecycleState);
        }

        public String toString() {
            return "SharedPolicyGroup.SharedPolicyGroupBuilder(id=" + this.id + ", hrid=" + this.hrid + ", environmentId=" + this.environmentId + ", organizationId=" + this.organizationId + ", crossId=" + this.crossId + ", name=" + this.name + ", description=" + this.description + ", prerequisiteMessage=" + this.prerequisiteMessage + ", version=" + this.version + ", apiType=" + String.valueOf(this.apiType) + ", originContext=" + String.valueOf(this.originContext) + ", phase=" + String.valueOf((Object)this.phase) + ", steps=" + String.valueOf(this.steps) + ", deployedAt=" + String.valueOf(this.deployedAt) + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", lifecycleState=" + String.valueOf((Object)this.lifecycleState) + ")";
        }
    }

    public static enum SharedPolicyGroupLifecycleState {
        UNDEPLOYED,
        DEPLOYED,
        PENDING;

    }
}

