/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiIndexerDomainService;
import io.gravitee.apim.core.api.domain_service.ApiMetadataDomainService;
import io.gravitee.apim.core.api.domain_service.CreateApiDomainService;
import io.gravitee.apim.core.api.domain_service.UpdateFederatedApiDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateFederatedApiDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiMetadata;
import io.gravitee.apim.core.api.model.factory.ApiModelFactory;
import io.gravitee.apim.core.async_job.crud_service.AsyncJobCrudService;
import io.gravitee.apim.core.audit.model.AuditActor;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.domain_service.ClearIngestedApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.domain_service.CreateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.domain_service.HomepageDomainService;
import io.gravitee.apim.core.documentation.domain_service.UpdateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.query_service.PageQueryService;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.integration.model.IntegrationApi;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerFactory;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.metadata.model.Metadata;
import io.gravitee.apim.core.notification.domain_service.TriggerNotificationDomainService;
import io.gravitee.apim.core.notification.model.hook.portal.FederatedApisIngestionCompleteHookContext;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.domain_service.CreatePlanDomainService;
import io.gravitee.apim.core.plan.domain_service.UpdatePlanDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.model.factory.PlanModelFactory;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.rest.api.service.common.UuidString;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class IngestFederatedApisUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IngestFederatedApisUseCase.class);
    private final AsyncJobCrudService asyncJobCrudService;
    private final ApiPrimaryOwnerFactory apiPrimaryOwnerFactory;
    private final ValidateFederatedApiDomainService validateFederatedApi;
    private final ApiCrudService apiCrudService;
    private final PlanCrudService planCrudService;
    private final PageQueryService pageQueryService;
    private final CreateApiDomainService createApiDomainService;
    private final UpdateFederatedApiDomainService updateFederatedApiDomainService;
    private final CreatePlanDomainService createPlanDomainService;
    private final UpdatePlanDomainService updatePlanDomainService;
    private final CreateApiDocumentationDomainService createApiDocumentationDomainService;
    private final UpdateApiDocumentationDomainService updateApiDocumentationDomainService;
    private final TriggerNotificationDomainService triggerNotificationDomainService;
    private final ApiMetadataDomainService apiMetadataDomainService;
    private final ApiIndexerDomainService apiIndexerDomainService;
    private final HomepageDomainService homepageDomainService;
    private final ClearIngestedApiDocumentationDomainService clearIngestedApiDocumentationDomainService;
    private final IntegrationCrudService integrationCrudService;

    public Completable execute(Input input) {
        log.info("Ingesting {} federated APIs [jobId={}]", (Object)input.apisToIngest().size(), (Object)input.ingestJobId);
        String ingestJobId = input.ingestJobId;
        String organizationId = input.organizationId();
        return Maybe.defer(() -> Maybe.fromOptional(this.asyncJobCrudService.findById(ingestJobId))).subscribeOn(Schedulers.computation()).doOnSuccess(job -> {
            String environmentId = job.getEnvironmentId();
            String userId = job.getInitiatorId();
            AuditInfo auditInfo = new AuditInfo(organizationId, environmentId, new AuditActor(userId, null, null));
            PrimaryOwnerEntity primaryOwner = this.apiPrimaryOwnerFactory.createForNewApi(organizationId, environmentId, userId);
            try (ApiIndexerDomainService.Bulk bulk = this.apiIndexerDomainService.bulk(auditInfo);){
                for (IntegrationApi api : input.apisToIngest) {
                    Integration.ApiIntegration integration = this.integrationCrudService.findApiIntegrationById(job.getSourceId()).orElseThrow(() -> new IllegalStateException("Integration %s not found".formatted(job.getSourceId())));
                    Api federatedApi = ApiModelFactory.fromIngestionJob(api, job, integration);
                    this.apiCrudService.findById(federatedApi.getId()).ifPresentOrElse(existingApi -> this.updateApi(bulk, federatedApi, api, auditInfo, primaryOwner), () -> this.createApi(bulk, federatedApi, api, auditInfo, primaryOwner));
                    List<ApiMetadata> metadata = IngestFederatedApisUseCase.metadata(api, federatedApi);
                    this.apiMetadataDomainService.saveApiMetadata(federatedApi.getId(), metadata, bulk.auditInfo());
                }
            }
            if (input.completed) {
                this.asyncJobCrudService.update(job.complete());
                this.triggerNotificationDomainService.triggerPortalNotification(organizationId, environmentId, new FederatedApisIngestionCompleteHookContext(job.getSourceId()));
            } else {
                this.asyncJobCrudService.delay(job.getId(), TimeProvider.now().plusMinutes(5L));
            }
        }).ignoreElement();
    }

    private void createApi(ApiIndexerDomainService.Bulk bulk, Api federatedApi, IntegrationApi integrationApi, AuditInfo auditInfo, PrimaryOwnerEntity primaryOwner) {
        try {
            this.createApiDomainService.create(federatedApi, primaryOwner, auditInfo, newApi -> this.validateFederatedApi.validateAndSanitizeForCreation((Api)newApi, primaryOwner), bulk.get());
            CollectionUtils.stream(integrationApi.plans()).map(plan -> PlanModelFactory.fromIntegration(plan, federatedApi)).forEach(p -> this.createPlanDomainService.create((Plan)p, List.of(), federatedApi, bulk.auditInfo()));
            CollectionUtils.stream(integrationApi.pages()).flatMap(page -> this.buildPage((IntegrationApi.Page)page, integrationApi, federatedApi.getId())).forEach(page -> this.createApiDocumentationDomainService.createPage((Page)page, bulk.auditInfo()));
        }
        catch (Exception e) {
            log.warn("An error occurred while importing api {}", (Object)federatedApi, (Object)e);
        }
    }

    private void updateApi(ApiIndexerDomainService.Bulk bulk, Api federatedApi, IntegrationApi integrationApi, AuditInfo auditInfo, PrimaryOwnerEntity primaryOwner) {
        log.debug("API already ingested [id={}] [name={}], performing update", (Object)federatedApi.getId(), (Object)federatedApi.getName());
        try {
            UnaryOperator<Api> updater = IngestFederatedApisUseCase.update(federatedApi);
            this.updateFederatedApiDomainService.update(federatedApi.getId(), updater, auditInfo, primaryOwner, bulk.get());
            CollectionUtils.stream(integrationApi.plans()).map(p -> PlanModelFactory.fromIntegration(p, federatedApi)).forEach(p -> this.planCrudService.findById(p.getId()).ifPresentOrElse(existingPlan -> this.updatePlanDomainService.update((Plan)p, List.of(), Map.of(), null, bulk.auditInfo()), () -> this.createPlanDomainService.create((Plan)p, List.of(), federatedApi, bulk.auditInfo())));
            List<String> ingestedPagesNames = integrationApi.pages().stream().map(IntegrationApi.Page::filename).toList();
            this.clearIngestedApiDocumentationDomainService.clearIngestedPagesOf(federatedApi.getId(), ingestedPagesNames, bulk.auditInfo());
            Map existingPages = this.pageQueryService.searchByApiId(federatedApi.getId()).stream().collect(Collectors.toMap(Page::getName, Function.identity()));
            List<Page> updatedOrNewPages = CollectionUtils.stream(integrationApi.pages()).flatMap(page -> this.buildPage((IntegrationApi.Page)page, integrationApi, federatedApi.getId())).map(page -> {
                Page existingPage = (Page)existingPages.get(page.getName());
                if (existingPage == null) {
                    return this.createApiDocumentationDomainService.createPage((Page)page, bulk.auditInfo());
                }
                Page pageWithProperCreatedAt = page.toBuilder().createdAt(existingPage.getCreatedAt()).id(existingPage.getId()).build();
                return this.updateApiDocumentationDomainService.updatePage(pageWithProperCreatedAt, existingPage, bulk.auditInfo());
            }).toList();
            updatedOrNewPages.stream().filter(Page::isHomepage).sorted(Comparator.comparing(Page::getCreatedAt).reversed()).map(Page::getId).distinct().findFirst().ifPresent(homepageId -> this.homepageDomainService.setPreviousHomepageToFalse(federatedApi.getId(), (String)homepageId));
        }
        catch (Exception e) {
            log.warn("An error occurred while updating api {}", (Object)federatedApi, (Object)e);
        }
    }

    private Stream<Page> buildPage(IntegrationApi.Page page, IntegrationApi integrationApi, String referenceId) {
        if (page == null || page.pageType() == null) {
            return Stream.empty();
        }
        return switch (page.pageType()) {
            default -> throw new MatchException(null, null);
            case IntegrationApi.PageType.SWAGGER -> Stream.of(this.buildSwaggerPage(referenceId, page));
            case IntegrationApi.PageType.ASYNCAPI -> Stream.of(this.buildAsyncApiPage(referenceId, page));
            case IntegrationApi.PageType.ASCIIDOC, IntegrationApi.PageType.MARKDOWN, IntegrationApi.PageType.MARKDOWN_TEMPLATE -> {
                log.error("Impossible to import {} documentation for {}", (Object)page.pageType(), (Object)integrationApi.name());
                yield Stream.empty();
            }
        };
    }

    private Page buildSwaggerPage(String referenceId, IntegrationApi.Page page) {
        Date now = Date.from(TimeProvider.instantNow());
        return Page.builder().id(UuidString.generateRandom()).name(page.filename()).content(page.content()).type(Page.Type.SWAGGER).referenceId(referenceId).referenceType(Page.ReferenceType.API).published(true).visibility(Page.Visibility.PRIVATE).homepage(true).configuration(Map.of("tryIt", "true", "viewer", "Swagger")).createdAt(now).updatedAt(now).ingested(true).build();
    }

    private Page buildAsyncApiPage(String referenceId, IntegrationApi.Page page) {
        Date now = Date.from(TimeProvider.instantNow());
        return Page.builder().id(UuidString.generateRandom()).name(page.filename()).content(page.content()).type(Page.Type.ASYNCAPI).referenceId(referenceId).referenceType(Page.ReferenceType.API).published(true).visibility(Page.Visibility.PRIVATE).homepage(true).createdAt(now).updatedAt(now).ingested(true).build();
    }

    static UnaryOperator<Api> update(Api newOne) {
        return previousApi -> ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)previousApi.toBuilder().name(newOne.getName())).description(newOne.getDescription())).version(newOne.getVersion())).federatedApiDefinition(newOne.getFederatedApiDefinition())).build();
    }

    private static List<ApiMetadata> metadata(IntegrationApi api, Api federatedApi) {
        return CollectionUtils.stream(api.metadata()).map(md -> {
            Metadata.MetadataFormat format = switch (md.format()) {
                default -> throw new MatchException(null, null);
                case Metadata.MetadataFormat.STRING -> Metadata.MetadataFormat.STRING;
                case Metadata.MetadataFormat.NUMERIC -> Metadata.MetadataFormat.NUMERIC;
                case Metadata.MetadataFormat.MAIL -> Metadata.MetadataFormat.MAIL;
                case Metadata.MetadataFormat.DATE -> Metadata.MetadataFormat.DATE;
                case Metadata.MetadataFormat.URL -> Metadata.MetadataFormat.URL;
                case Metadata.MetadataFormat.BOOLEAN -> Metadata.MetadataFormat.BOOLEAN;
            };
            return ApiMetadata.builder().apiId(federatedApi.getId()).name(md.name()).key(md.name()).value(md.value()).format(format).build();
        }).toList();
    }

    @Generated
    public IngestFederatedApisUseCase(AsyncJobCrudService asyncJobCrudService, ApiPrimaryOwnerFactory apiPrimaryOwnerFactory, ValidateFederatedApiDomainService validateFederatedApi, ApiCrudService apiCrudService, PlanCrudService planCrudService, PageQueryService pageQueryService, CreateApiDomainService createApiDomainService, UpdateFederatedApiDomainService updateFederatedApiDomainService, CreatePlanDomainService createPlanDomainService, UpdatePlanDomainService updatePlanDomainService, CreateApiDocumentationDomainService createApiDocumentationDomainService, UpdateApiDocumentationDomainService updateApiDocumentationDomainService, TriggerNotificationDomainService triggerNotificationDomainService, ApiMetadataDomainService apiMetadataDomainService, ApiIndexerDomainService apiIndexerDomainService, HomepageDomainService homepageDomainService, ClearIngestedApiDocumentationDomainService clearIngestedApiDocumentationDomainService, IntegrationCrudService integrationCrudService) {
        this.asyncJobCrudService = asyncJobCrudService;
        this.apiPrimaryOwnerFactory = apiPrimaryOwnerFactory;
        this.validateFederatedApi = validateFederatedApi;
        this.apiCrudService = apiCrudService;
        this.planCrudService = planCrudService;
        this.pageQueryService = pageQueryService;
        this.createApiDomainService = createApiDomainService;
        this.updateFederatedApiDomainService = updateFederatedApiDomainService;
        this.createPlanDomainService = createPlanDomainService;
        this.updatePlanDomainService = updatePlanDomainService;
        this.createApiDocumentationDomainService = createApiDocumentationDomainService;
        this.updateApiDocumentationDomainService = updateApiDocumentationDomainService;
        this.triggerNotificationDomainService = triggerNotificationDomainService;
        this.apiMetadataDomainService = apiMetadataDomainService;
        this.apiIndexerDomainService = apiIndexerDomainService;
        this.homepageDomainService = homepageDomainService;
        this.clearIngestedApiDocumentationDomainService = clearIngestedApiDocumentationDomainService;
        this.integrationCrudService = integrationCrudService;
    }

    public record Input(String organizationId, String ingestJobId, List<IntegrationApi> apisToIngest, boolean completed) {
    }
}

