/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.exception.ApiInvalidDefinitionVersionException;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.exception.TcpProxyNotSupportedException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.utils.DurationUtils;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import lombok.Generated;

@UseCase
public class SearchResponseTimeUseCase {
    private final AnalyticsQueryService analyticsQueryService;
    private final ApiCrudService apiCrudService;

    public Single<Output> execute(ExecutionContext executionContext, Input input) {
        Instant to = input.to();
        Instant from = input.from();
        Duration interval = DurationUtils.buildIntervalFromTimePeriod(from, to);
        return this.validateApiRequirements(input).flatMapMaybe(api -> this.analyticsQueryService.searchAvgResponseTimeOverTime(executionContext, List.of(api.getId()), from, to, interval, List.of(api.getDefinitionVersion()))).map(statsData -> new Output(from, to, interval, statsData.values().stream().map(Math::round).toList())).defaultIfEmpty((Object)new Output(from, to, interval, List.of()));
    }

    private Single<Api> validateApiRequirements(Input input) {
        return Maybe.fromOptional(this.apiCrudService.findById(input.apiId)).switchIfEmpty((SingleSource)Single.error((Throwable)new ApiNotFoundException(input.apiId))).flatMap(SearchResponseTimeUseCase::validateApiDefinitionVersion).flatMap(api -> SearchResponseTimeUseCase.validateApiMultiTenancyAccess(api, input.environmentId)).flatMap(SearchResponseTimeUseCase::validateApiIsNotTcp);
    }

    private static Single<Api> validateApiIsNotTcp(Api api) {
        return api.getApiDefinitionHttpV4().isTcpProxy() ? Single.error((Throwable)new TcpProxyNotSupportedException(api.getId())) : Single.just((Object)api);
    }

    private static Single<Api> validateApiMultiTenancyAccess(Api api, String environmentId) {
        return api.belongsToEnvironment(environmentId) ? Single.just((Object)api) : Single.error((Throwable)new ApiNotFoundException(api.getId()));
    }

    private static Single<Api> validateApiDefinitionVersion(Api api) {
        return DefinitionVersion.V4.equals((Object)api.getDefinitionVersion()) ? Single.just((Object)api) : Single.error((Throwable)new ApiInvalidDefinitionVersionException(api.getId()));
    }

    @Generated
    public SearchResponseTimeUseCase(AnalyticsQueryService analyticsQueryService, ApiCrudService apiCrudService) {
        this.analyticsQueryService = analyticsQueryService;
        this.apiCrudService = apiCrudService;
    }

    public record Input(String apiId, String environmentId, Instant from, Instant to) {
    }

    public record Output(Instant from, Instant to, Duration interval, List<Long> data) {
    }
}

