/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.notification;

import io.gravitee.apim.core.api.domain_service.NotificationCRDDomainService;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.rest.api.model.notification.PortalNotificationConfigEntity;
import io.gravitee.rest.api.service.PortalNotificationConfigService;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class NotificationCRDDomainServiceImpl
implements NotificationCRDDomainService {
    private final PortalNotificationConfigService portalNotificationConfigService;

    @Override
    public void syncApiPortalNotifications(String apiId, String user, PortalNotificationConfigEntity notificationConfig) {
        this.syncPortalNotifications(apiId, NotificationReferenceType.API, user, notificationConfig);
    }

    public void syncPortalNotifications(String referenceId, NotificationReferenceType referenceType, String user, PortalNotificationConfigEntity notificationConfig) {
        Objects.requireNonNull(referenceId);
        Objects.requireNonNull(user);
        if (notificationConfig != null) {
            notificationConfig.setUser(user);
            notificationConfig.setReferenceId(referenceId);
            notificationConfig.setReferenceType(referenceType.name());
            this.portalNotificationConfigService.save(notificationConfig);
            return;
        }
        PortalNotificationConfigEntity existing = this.portalNotificationConfigService.findById(user, referenceType, referenceId);
        if (!existing.isDefaultEmpty()) {
            this.portalNotificationConfigService.save(PortalNotificationConfigEntity.newDefaultEmpty((String)user, (String)referenceType.name(), (String)referenceId));
        }
    }

    @Generated
    public NotificationCRDDomainServiceImpl(PortalNotificationConfigService portalNotificationConfigService) {
        this.portalNotificationConfigService = portalNotificationConfigService;
    }
}

