/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.notification;

import io.gravitee.rest.api.service.notification.Hook;
import io.gravitee.rest.api.service.notification.HookScope;

public enum PortalHook implements Hook
{
    USER_REGISTRATION_REQUEST("User Registration Request", "Triggered when a new user is created and automatic validation is disabled", "USER"),
    USER_REGISTERED("User Registered", "Triggered when an user is registered", "USER"),
    USER_CREATED("User Created", "Triggered when an user is created", "USER"),
    USER_FIRST_LOGIN("First Login", "Triggered when an user log in for the first time", "USER"),
    PASSWORD_RESET("Password Reset", "Triggered when a password is reset", "USER"),
    NEW_SUPPORT_TICKET("New Support Ticket", "Triggered when a new support ticket is created", "SUPPORT"),
    FEDERATED_APIS_INGESTION_COMPLETE("Ingestion complete", "Triggered when an ingestion has completed.", "FEDERATION"),
    GROUP_INVITATION("Group invitation", "Triggered when an user is invited in a group", "GROUP"),
    MESSAGE("Message", "Used when sending a custom message to an Environment Role", null, true);

    private String label;
    private String description;
    private String category;
    private boolean hidden;

    private PortalHook(String label, String description, String category) {
        this(label, description, category, false);
    }

    private PortalHook(String label, String description, String category, boolean hidden) {
        this.label = label;
        this.description = description;
        this.category = category;
        this.hidden = hidden;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public HookScope getScope() {
        return HookScope.PORTAL;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }
}

