/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.member;

import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.group.model.crd.GroupCRDSpec;
import io.gravitee.apim.core.member.domain_service.CRDMembersDomainService;
import io.gravitee.apim.core.member.model.RoleScope;
import io.gravitee.apim.core.member.model.crd.MemberCRD;
import io.gravitee.apim.core.utils.StringUtils;
import io.gravitee.apim.infra.adapter.GroupCRDAdapter;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.RoleNotFoundException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CRDMembersDomainServiceImpl
implements CRDMembersDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CRDMembersDomainServiceImpl.class);
    private final MembershipService membershipService;
    private final RoleService roleService;

    @Override
    public void updateApiMembers(AuditInfo auditInfo, String apiId, Set<MemberCRD> members) {
        this.updateMembers(auditInfo, apiId, RoleScope.API, MembershipReferenceType.API, members);
        this.deleteOrphans(auditInfo, apiId, RoleScope.API, MembershipReferenceType.API, members);
        this.transferOwnerShip(auditInfo, apiId, RoleScope.API, MembershipReferenceType.API);
    }

    @Override
    public void updateApplicationMembers(AuditInfo auditInfo, String applicationId, Set<MemberCRD> members) {
        this.updateMembers(auditInfo, applicationId, RoleScope.APPLICATION, MembershipReferenceType.APPLICATION, members);
        this.deleteOrphans(auditInfo, applicationId, RoleScope.APPLICATION, MembershipReferenceType.APPLICATION, members);
        this.transferOwnerShip(auditInfo, applicationId, RoleScope.APPLICATION, MembershipReferenceType.APPLICATION);
    }

    @Override
    public void updateGroupMembers(AuditInfo auditInfo, String groupId, Set<GroupCRDSpec.Member> members) {
        Set<MemberCRD> apiMembers = GroupCRDAdapter.INSTANCE.toApiMemberCRDSet(members);
        Set<MemberCRD> applicationMembers = GroupCRDAdapter.INSTANCE.toApplicationMemberCRDSet(members);
        Set<MemberCRD> integrationMembers = GroupCRDAdapter.INSTANCE.toIntegrationMemberCRDSet(members);
        this.updateMembers(auditInfo, groupId, RoleScope.API, MembershipReferenceType.GROUP, apiMembers);
        this.updateMembers(auditInfo, groupId, RoleScope.APPLICATION, MembershipReferenceType.GROUP, applicationMembers);
        this.updateMembers(auditInfo, groupId, RoleScope.INTEGRATION, MembershipReferenceType.GROUP, integrationMembers);
        this.deleteOrphans(auditInfo, groupId, RoleScope.API, MembershipReferenceType.GROUP, apiMembers);
        this.deleteOrphans(auditInfo, groupId, RoleScope.APPLICATION, MembershipReferenceType.GROUP, applicationMembers);
        this.deleteOrphans(auditInfo, groupId, RoleScope.INTEGRATION, MembershipReferenceType.GROUP, integrationMembers);
    }

    private void updateMembers(AuditInfo auditInfo, String referenceId, RoleScope roleScope, MembershipReferenceType referenceType, Set<MemberCRD> members) {
        ExecutionContext executionContext = new ExecutionContext(auditInfo.organizationId(), auditInfo.environmentId());
        RoleEntity defaultRole = this.roleService.findDefaultRoleByScopes(auditInfo.organizationId(), this.mapRoleScope(roleScope)).iterator().next();
        for (MemberCRD member : members) {
            if (StringUtils.isEmpty(member.getRole())) {
                log.warn("There is no role associated with member [{}]. Default role will be applied", (Object)member.getSourceId());
            }
            this.membershipService.getRoles(referenceType, referenceId, MembershipMemberType.USER, member.getId()).stream().filter(role -> role.getScope().name().equals(roleScope.name())).findFirst().ifPresent(role -> this.membershipService.removeRole(referenceType, referenceId, MembershipMemberType.USER, member.getId(), role.getId()));
            RoleEntity memberRoleEntity = StringUtils.isEmpty(member.getRole()) ? defaultRole : this.findRoleEntity(auditInfo.organizationId(), roleScope, member.getRole(), defaultRole);
            this.membershipService.addRoleToMemberOnReference(executionContext, referenceType, referenceId, MembershipMemberType.USER, member.getId(), memberRoleEntity.getId());
        }
        log.debug("Members successfully created for {} [{}]", (Object)referenceType, (Object)referenceId);
    }

    private void deleteOrphans(AuditInfo auditInfo, String referenceId, RoleScope roleScope, MembershipReferenceType referenceType, Set<MemberCRD> members) {
        log.debug("Deleting orphan members");
        ExecutionContext executionContext = new ExecutionContext(auditInfo.organizationId(), auditInfo.environmentId());
        io.gravitee.rest.api.model.permissions.RoleScope scope = io.gravitee.rest.api.model.permissions.RoleScope.valueOf((String)roleScope.name());
        RoleEntity poRole = this.roleService.findPrimaryOwnerRoleByOrganization(auditInfo.organizationId(), scope);
        Set givenMemberIds = members.stream().map(MemberCRD::getId).collect(Collectors.toSet());
        HashSet<String> existingMemberIds = new HashSet<String>(this.membershipService.getMembersByReference(executionContext, referenceType, referenceId).stream().filter(member -> member.getRoles().stream().noneMatch(arg_0 -> ((RoleEntity)poRole).equals(arg_0))).map(MemberEntity::getId).toList());
        existingMemberIds.removeAll(givenMemberIds);
        existingMemberIds.forEach(memberId -> this.membershipService.deleteReferenceMember(executionContext, referenceType, referenceId, MembershipMemberType.USER, (String)memberId));
    }

    private void transferOwnerShip(AuditInfo auditInfo, String referenceId, RoleScope roleScope, MembershipReferenceType referenceType) {
        log.debug("Transferring owner ship to authenticated user {}", (Object)auditInfo.actor().userSourceId());
        MembershipEntity currentPrimaryOwner = this.membershipService.getPrimaryOwner(auditInfo.organizationId(), referenceType, referenceId);
        if (currentPrimaryOwner != null && currentPrimaryOwner.getMemberId().equals(auditInfo.actor().userId())) {
            log.debug("User {} is already the primary owner for {} {}", new Object[]{auditInfo.actor().userSourceId(), referenceType, referenceId});
            return;
        }
        ExecutionContext executionContext = new ExecutionContext(auditInfo.organizationId(), auditInfo.environmentId());
        MembershipService.MembershipMember primaryOwner = new MembershipService.MembershipMember(auditInfo.actor().userId(), null, MembershipMemberType.USER);
        switch (roleScope) {
            case API: {
                this.membershipService.transferApiOwnership(executionContext, referenceId, primaryOwner, List.of());
                break;
            }
            case APPLICATION: {
                this.membershipService.transferApplicationOwnership(executionContext, referenceId, primaryOwner, List.of());
                break;
            }
            default: {
                throw new TechnicalDomainException(String.format("Unknown role scope [%s]", new Object[]{roleScope}));
            }
        }
    }

    private RoleEntity findRoleEntity(String organizationId, RoleScope roleScope, String roleNameOrId, RoleEntity defaultRole) {
        try {
            return this.roleService.findByScopeAndName(this.mapRoleScope(roleScope), roleNameOrId, organizationId).orElseGet(() -> this.roleService.findById(roleNameOrId));
        }
        catch (RoleNotFoundException e) {
            log.warn("Unable to find role [{}]. Using default role [{}]", (Object)roleNameOrId, (Object)defaultRole);
            return defaultRole;
        }
    }

    private io.gravitee.rest.api.model.permissions.RoleScope mapRoleScope(RoleScope roleScope) {
        return roleScope == null ? null : io.gravitee.rest.api.model.permissions.RoleScope.valueOf((String)roleScope.name());
    }

    @Generated
    public CRDMembersDomainServiceImpl(MembershipService membershipService, RoleService roleService) {
        this.membershipService = membershipService;
        this.roleService = roleService;
    }
}

