/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.model.factory;

import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.api.model.crd.PlanCRD;
import io.gravitee.apim.core.integration.model.IntegrationApi;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.federation.FederatedPlan;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.nativeapi.NativePlan;
import io.gravitee.definition.model.v4.plan.Plan;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.rest.api.model.v4.plan.PlanSecurityType;
import io.gravitee.rest.api.service.common.UuidString;
import java.time.ZonedDateTime;

public class PlanModelFactory {
    private PlanModelFactory() {
    }

    public static Plan fromCRDSpec(PlanCRD planCRD, ApiCRDSpec api) {
        Object plan = ((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)Plan.builder().id(planCRD.getId())).name(planCRD.getName())).description(planCRD.getDescription())).characteristics(planCRD.getCharacteristics())).definitionVersion(DefinitionVersion.valueOf((String)api.getDefinitionVersion()))).crossId(planCRD.getCrossId())).excludedGroups(planCRD.getExcludedGroups())).generalConditions(planCRD.getGeneralConditions())).order(planCRD.getOrder())).type(planCRD.getType())).validation(planCRD.getValidation())).apiType(ApiType.valueOf((String)api.getType()))).apiId(api.getId())).build();
        if (ApiType.NATIVE.getLabel().equalsIgnoreCase(api.getType())) {
            ((Plan)plan).setPlanDefinitionNativeV4(((NativePlan.NativePlanBuilder)((NativePlan.NativePlanBuilder)((NativePlan.NativePlanBuilder)((NativePlan.NativePlanBuilder)((NativePlan.NativePlanBuilder)((NativePlan.NativePlanBuilder)NativePlan.builder().security(planCRD.getSecurity())).selectionRule(planCRD.getSelectionRule())).status(planCRD.getStatus())).tags(planCRD.getTags())).mode(planCRD.getMode())).name(planCRD.getName())).build());
        } else {
            ((Plan)plan).setPlanDefinitionHttpV4(((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)io.gravitee.definition.model.v4.plan.Plan.builder().security(planCRD.getSecurity())).selectionRule(planCRD.getSelectionRule())).status(planCRD.getStatus())).tags(planCRD.getTags())).mode(planCRD.getMode())).name(planCRD.getName())).build());
        }
        return plan;
    }

    public static Plan fromIntegration(IntegrationApi.Plan plan, Api federatedApi) {
        String id = PlanModelFactory.generateFederatedPlanId(plan, federatedApi);
        ZonedDateTime now = TimeProvider.now();
        return ((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)Plan.builder().id(id)).name(plan.name())).description(plan.description())).apiId(federatedApi.getId())).federatedPlanDefinition(FederatedPlan.builder().id(id).providerId(plan.id()).security(PlanSecurity.builder().type(PlanSecurityType.valueOf((String)plan.type().name()).getLabel()).build()).status(PlanStatus.PUBLISHED).build())).characteristics(plan.characteristics())).createdAt(now)).updatedAt(now)).validation(Plan.PlanValidationType.MANUAL)).build();
    }

    private static String generateFederatedPlanId(IntegrationApi.Plan plan, Api api) {
        return UuidString.generateForEnvironment(api.getId(), plan.id());
    }
}

