/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.rest.api.model.DeploymentRequired;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SynchronizationService {
    private final Logger LOGGER = LoggerFactory.getLogger(SynchronizationService.class);
    private final ObjectMapper objectMapper;

    public SynchronizationService(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> boolean checkSynchronization(Class<T> entityClass, T deployedEntity, T entityToDeploy) {
        try {
            String requiredFieldsDeployedApiDefinition = this.objectMapper.writeValueAsString(this.getRequiredFieldsForComparison(entityClass, deployedEntity));
            String requiredFieldsApiToDeployDefinition = this.objectMapper.writeValueAsString(this.getRequiredFieldsForComparison(entityClass, entityToDeploy));
            return this.objectMapper.readTree(requiredFieldsDeployedApiDefinition).equals((Object)this.objectMapper.readTree(requiredFieldsApiToDeployDefinition));
        }
        catch (Exception e) {
            this.LOGGER.error("Unexpected error while generating API deployment required fields definition", (Throwable)e);
            return false;
        }
    }

    public <T> List<Object> getRequiredFieldsForComparison(Class<T> entityClass, T entity) {
        ArrayList<Object> requiredEntityFields = new ArrayList<Object>();
        if (Objects.nonNull(entityClass)) {
            for (Field entityField : entityClass.getDeclaredFields()) {
                this.addRequiredEntityFieldToList(entityField, entity, requiredEntityFields);
            }
        }
        return requiredEntityFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addRequiredEntityFieldToList(Field entityField, T entity, List<Object> requiredEntityFields) {
        if (this.isFieldRequiredForDeployment(entityField)) {
            boolean previousAccessibleState = entityField.isAccessible();
            entityField.setAccessible(true);
            try {
                requiredEntityFields.add(entityField.get(entity));
            }
            catch (Exception e) {
                this.LOGGER.error("Error access entity required deployment fields", (Throwable)e);
            }
            finally {
                entityField.setAccessible(previousAccessibleState);
            }
        }
    }

    public boolean isFieldRequiredForDeployment(Field classField) {
        return classField.getAnnotation(DeploymentRequired.class) != null;
    }
}

