/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.integration;

import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.integration.query_service.IntegrationQueryService;
import io.gravitee.apim.infra.adapter.IntegrationAdapter;
import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.IntegrationRepository;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class IntegrationQueryServiceImpl
extends AbstractService
implements IntegrationQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrationQueryServiceImpl.class);
    private final IntegrationRepository integrationRepository;
    private final MembershipService membershipService;

    public IntegrationQueryServiceImpl(@Lazy IntegrationRepository integrationRepository, MembershipService membershipService) {
        this.integrationRepository = integrationRepository;
        this.membershipService = membershipService;
    }

    @Override
    public Page<Integration> findByEnvironment(String environmentId, Pageable pageable) {
        try {
            return this.integrationRepository.findAllByEnvironment(environmentId, IntegrationQueryServiceImpl.convert(pageable)).map(IntegrationAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            log.error("An error occurred while finding Integrations by environment", (Throwable)e);
            throw new TechnicalManagementException("An error occurred while finding Integrations by environment id: " + environmentId, e);
        }
    }

    @Override
    public Page<Integration> findByEnvironmentAndContext(String environmentId, String userId, Collection<String> groups, boolean isAdmin, Pageable pageable) {
        try {
            Page integrations;
            if (isAdmin) {
                integrations = this.integrationRepository.findAllByEnvironment(environmentId, IntegrationQueryServiceImpl.convert(pageable));
            } else {
                Set integrationAccessibleDirectlyByUser = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.INTEGRATION).stream().map(MembershipEntity::getReferenceId).collect(Collectors.toSet());
                integrations = this.integrationRepository.findAllByEnvironmentAndGroups(environmentId, integrationAccessibleDirectlyByUser, groups, IntegrationQueryServiceImpl.convert(pageable));
            }
            return integrations.map(IntegrationAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            log.error("An error occurred while finding Integrations by environment", (Throwable)e);
            throw new TechnicalManagementException("An error occurred while finding Integrations by environment id: " + environmentId, e);
        }
    }
}

